/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.internal.core.model;

import com.dubture.twig.internal.core.model.TwigType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.php.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class TwigCallable
extends TwigType {
    protected PHPDocBlock doc;
    protected JSONArray filterArguments = new JSONArray();
    protected Map<String, String> arguments = new HashMap<String, String>();
    protected IScriptProject _project;

    public TwigCallable(ModelElement parent, String name) {
        super(parent, name);
    }

    protected String getDocString() {
        if (this.description != null) {
            return this.description;
        }
        if (this.doc == null) {
            return "";
        }
        String longDesc = this.doc.getLongDescription() != null ? this.doc.getLongDescription() : "";
        String shortDesc = this.doc.getShortDescription() != null ? this.doc.getShortDescription() : "";
        this.description = String.valueOf(longDesc) + shortDesc;
        return this.description;
    }

    @Override
    public void setMetadata(JSONObject data) {
        this.phpClass = (String)data.get((Object)"phpClass");
        this.description = (String)data.get((Object)"doc");
        this.filterArguments = (JSONArray)data.get((Object)"args");
        this.internalFunction = (String)data.get((Object)"internal");
        for (Object o : this.filterArguments) {
            JSONObject json = (JSONObject)o;
            if (json == null) continue;
            for (String param : json.keySet()) {
                String def = (String)json.get((Object)param);
                this.arguments.put(param, def);
            }
        }
    }

    public void addArgs(List arguments) {
        JSONArray args = new JSONArray();
        for (Object o : arguments) {
            String defaultValue;
            FormalParameter param = (FormalParameter)o;
            if (param == null) continue;
            JSONObject arg = new JSONObject();
            ASTNode init = param.getInitialization();
            String string = defaultValue = init != null ? init.getClass().toString() : "";
            if (init instanceof Scalar) {
                Scalar scalar = (Scalar)init;
                defaultValue = scalar.getValue();
            }
            this.arguments.put(param.getName(), defaultValue);
            arg.put((Object)param.getName(), (Object)defaultValue);
            args.add((Object)arg);
        }
        this.filterArguments = args;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public void setScriptProject(IScriptProject scriptProject) {
        this._project = scriptProject;
    }

    public IScriptProject getScriptProject() {
        return this._project;
    }

    @Override
    public String getMetadata() {
        JSONObject data = new JSONObject();
        data.put((Object)"phpClass", (Object)this.phpClass);
        data.put((Object)"doc", (Object)this.getDocString());
        data.put((Object)"args", (Object)this.filterArguments);
        data.put((Object)"internal", (Object)this.internalFunction);
        return data.toString();
    }

    public void addDoc(PHPDocBlock doc) {
        this.doc = doc;
    }

    public String[] getParameterNames() {
        return this.getArguments().keySet().toArray(new String[this.getArguments().size()]);
    }
}

