/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui;

import com.dubture.twig.core.log.Logger;
import com.dubture.twig.ui.editor.configuration.TwigContributionContextTypeRegistry;
import com.dubture.twig.ui.viewsupport.ImagesOnFileSystemRegistry;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.php.internal.ui.preferences.PHPTemplateStore;
import org.eclipse.php.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.osgi.framework.BundleContext;

public class TwigUICorePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.dubture.twig.ui";
    private static TwigUICorePlugin plugin;
    protected ContextTypeRegistry contentTypeRegistry = null;
    protected TemplateStore templateStore = null;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private ImagesOnFileSystemRegistry fImagesOnFSRegistry;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static TwigUICorePlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return TwigUICorePlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    private synchronized ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        if (this.contentTypeRegistry == null) {
            TwigContributionContextTypeRegistry registry = new TwigContributionContextTypeRegistry();
            registry.addContextType("twig");
            this.contentTypeRegistry = registry;
        }
        return this.contentTypeRegistry;
    }

    public TemplateStore getTemplateStore() {
        if (this.templateStore == null) {
            this.templateStore = new PHPTemplateStore(this.getTemplateContextRegistry(), this.getPreferenceStore(), "org.eclipse.php.smarty.ui.editor.templates");
            try {
                this.templateStore.load();
            }
            catch (IOException e) {
                Logger.logException((Throwable)e);
            }
        }
        return this.templateStore;
    }

    public ImagesOnFileSystemRegistry getImagesOnFSRegistry() {
        if (this.fImagesOnFSRegistry == null) {
            this.fImagesOnFSRegistry = new ImagesOnFileSystemRegistry();
        }
        return this.fImagesOnFSRegistry;
    }

    public IFile getFile(IDocument document) {
        IFile file = null;
        IStructuredModel structuredModel = null;
        try {
            String location;
            structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (structuredModel != null && (location = structuredModel.getBaseLocation()) != null) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(location));
            }
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
        return file;
    }

    public static IWorkbenchPage getActivePage() {
        return TwigUICorePlugin.getDefault().internalGetActivePage();
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }
}

