/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.editor;

import com.dubture.twig.core.documentModel.parser.regions.ITwigScriptRegion;
import com.dubture.twig.ui.preferences.PreferenceConstants;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.editor.highlighter.LineStyleProviderForPHP;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;

public class LineStyleProviderForTwig
extends LineStyleProviderForPHP {
    private IPreferenceStore twigColorPreferences;
    private static final Map<String, String> fTwigColorTypes = new HashMap<String, String>();

    static {
        fTwigColorTypes.put("TWIG_OPEN", "editorColorBoundarymaker");
        fTwigColorTypes.put("TWIG_CLOSE", "editorColorBoundarymaker");
        fTwigColorTypes.put("TWIG_STMT_OPEN", "editorStmtColorBoundarymaker");
        fTwigColorTypes.put("TWIG_STMT_CLOSE", "editorStmtColorBoundarymaker");
        fTwigColorTypes.put("TWIG_CONTENT", "editorColorKeyword");
        fTwigColorTypes.put("TWIG_COMMENT", "editorColorComment");
        fTwigColorTypes.put("TWIG_COMMENT_OPEN", "editorColorComment");
        fTwigColorTypes.put("TWIG_COMMENT_TEXT", "editorColorComment");
        fTwigColorTypes.put("TWIG_COMMENT_CLOSE", "editorColorComment");
        fTwigColorTypes.put("TWIG_VARIABLE", "editorColorVariable");
        fTwigColorTypes.put("TWIG_KEYWORD", "editorColorKeyword");
        fTwigColorTypes.put("TWIG_BLOCKNAME", "editorBlocknameColor");
        fTwigColorTypes.put("TWIG_HASH_START", "editorColorJson");
        fTwigColorTypes.put("TWIG_HASH_END", "editorColorJson");
        fTwigColorTypes.put("TWIG_INTERPOLATION_START", "editorColorInterpolation");
        fTwigColorTypes.put("TWIG_INTERPOLATION_END", "editorColorInterpolation");
        fTwigColorTypes.put("TWIG_DELIMITER", "editorColorComment");
        fTwigColorTypes.put("TWIG_WHITESPACE", "editorColorKeyword");
        fTwigColorTypes.put("TWIG_NUMBER", "editorColorNumber");
        fTwigColorTypes.put("TWIG_LABEL", "codeStyleNormal");
        fTwigColorTypes.put("TWIG_CONSTANT_ENCAPSED_STRING", "editorColorString");
        fTwigColorTypes.put("TWIG_DOUBLE_QUOTES_CONTENT", "editorColorString");
        fTwigColorTypes.put("TWIG_DOUBLE_QUOTES_START", "editorColorString");
        fTwigColorTypes.put("TWIG_DOUBLE_QUOTES_END", "editorColorString");
        fTwigColorTypes.put("ST_TWIG_BACKTICK_END", "editorColorKeyword");
        fTwigColorTypes.put("TWIG_BACKTICK_START", "editorColorKeyword");
        fColorTypes.putAll(fTwigColorTypes);
    }

    public TextAttribute getAttributeFor(ITextRegion region) {
        String type = region.getType();
        if (type != null && type.startsWith("TWIG_")) {
            return this.getAttributeFor(type);
        }
        return super.getAttributeFor(region);
    }

    protected TextAttribute getAttributeFor(String type) {
        return super.getAttributeFor(type);
    }

    public boolean prepareTextRegion(ITextRegionCollection blockedRegion, int partitionStartOffset, int partitionLength, Collection<StyleRange> holdResults) {
        boolean handled = false;
        int partitionEndOffset = partitionStartOffset + partitionLength - 1;
        ITextRegion region = null;
        ITextRegionList regions = blockedRegion.getRegions();
        int nRegions = regions.size();
        StyleRange styleRange = null;
        int i = 0;
        while (i < nRegions) {
            region = regions.get(i);
            TextAttribute attr = null;
            int startOffset = blockedRegion.getStartOffset(region);
            if (startOffset > partitionEndOffset) break;
            if (blockedRegion.getEndOffset(region) > partitionStartOffset) {
                if (region instanceof ITextRegionCollection) {
                    handled = this.prepareTextRegion((ITextRegionCollection)region, partitionStartOffset, partitionLength, holdResults);
                } else if (region.getType() == "TWIG_CONTENT" || region.getType() == "TWIG_COMMENT") {
                    handled = this.prepareTwigRegions(holdResults, (ITwigScriptRegion)region, startOffset, partitionStartOffset, partitionLength);
                } else {
                    attr = this.getAttributeFor(region);
                    if (attr != null) {
                        handled = true;
                        styleRange = this.createStyleRange(blockedRegion, region, attr, partitionStartOffset, partitionLength);
                        holdResults.add(styleRange);
                    }
                }
            }
            ++i;
        }
        return handled;
    }

    private boolean prepareTwigRegions(Collection<StyleRange> holdResults, ITwigScriptRegion region, int regionStart, int partitionStartOffset, int partitionLength) {
        assert (region.getType() == "TWIG_CONTENT" || region.getType() == "TWIG_COMMENT");
        StyleRange styleRange = null;
        TextAttribute previousAttr = null;
        ITextRegion[] twigTokens = null;
        try {
            int length;
            int from;
            if (partitionStartOffset < regionStart) {
                from = 0;
                length = partitionLength - (regionStart - partitionStartOffset);
            } else {
                from = partitionStartOffset - regionStart;
                length = partitionLength;
            }
            twigTokens = region.getTwigTokens(from, Math.min(length, region.getLength()));
            ITextRegion prevElement = null;
            int i = 0;
            while (i < twigTokens.length) {
                block19: {
                    ITextRegion element;
                    block21: {
                        int styleLength;
                        TextAttribute attr;
                        block20: {
                            element = twigTokens[i];
                            attr = this.getAttributeFor(element);
                            if (prevElement == element || attr == null) break block19;
                            if (styleRange == null || previousAttr == null || !previousAttr.equals((Object)attr) || prevElement == null || prevElement.getLength() != prevElement.getLength()) break block20;
                            styleRange.length += element.getLength();
                            if (styleRange.start + styleRange.length > partitionStartOffset + partitionLength) {
                                styleRange.length -= styleRange.start + styleRange.length - (partitionStartOffset + partitionLength);
                            }
                            break block21;
                        }
                        int styleStart = regionStart + element.getStart();
                        if (styleStart + (styleLength = element.getLength()) < partitionStartOffset) break block19;
                        if (styleStart < partitionStartOffset) {
                            styleLength -= partitionStartOffset - styleStart;
                            styleStart = partitionStartOffset;
                        }
                        if (styleStart > partitionStartOffset + partitionLength) {
                            styleLength -= styleStart - (partitionStartOffset + partitionLength);
                        }
                        if (attr.getBackground() != null && element.getTextEnd() != element.getEnd()) {
                            styleRange = new StyleRange(styleStart, styleLength - (element.getEnd() - element.getTextEnd()), attr.getForeground(), attr.getBackground(), attr.getStyle());
                            if ((attr.getStyle() & 0x40000000) != 0) {
                                styleRange.underline = true;
                                styleRange.fontStyle &= 0xBFFFFFFF;
                            }
                            if ((attr.getStyle() & 0x20000000) != 0) {
                                styleRange.strikeout = true;
                                styleRange.fontStyle &= 0xDFFFFFFF;
                            }
                            holdResults.add(styleRange);
                            styleRange = new StyleRange(regionStart + element.getTextEnd(), element.getEnd() - element.getTextEnd(), attr.getForeground(), null, attr.getStyle());
                            holdResults.add(styleRange);
                            previousAttr = null;
                        } else {
                            styleRange = new StyleRange(styleStart, styleLength, attr.getForeground(), attr.getBackground(), attr.getStyle());
                            if ((attr.getStyle() & 0x40000000) != 0) {
                                styleRange.underline = true;
                                styleRange.fontStyle &= 0xBFFFFFFF;
                            }
                            if ((attr.getStyle() & 0x20000000) != 0) {
                                styleRange.strikeout = true;
                                styleRange.fontStyle &= 0xDFFFFFFF;
                            }
                            holdResults.add(styleRange);
                            previousAttr = attr;
                        }
                    }
                    prevElement = element;
                }
                ++i;
            }
            return true;
        }
        catch (BadLocationException e) {
            Logger.logException((Throwable)e);
            return false;
        }
    }

    public boolean prepareTextRegions(IStructuredDocumentRegion structuredDocumentRegion, int partitionStartOffset, int partitionLength, Collection<StyleRange> holdResults) {
        boolean handled = false;
        int partitionEndOffset = partitionStartOffset + partitionLength - 1;
        while (structuredDocumentRegion != null && structuredDocumentRegion.getStartOffset() <= partitionEndOffset) {
            ITextRegion region = null;
            ITextRegionList regions = structuredDocumentRegion.getRegions();
            int nRegions = regions.size();
            StyleRange styleRange = null;
            int i = 0;
            while (i < nRegions) {
                region = regions.get(i);
                TextAttribute attr = null;
                int startOffset = structuredDocumentRegion.getStartOffset(region);
                if (startOffset > partitionEndOffset) break;
                if (structuredDocumentRegion.getEndOffset(region) > partitionStartOffset) {
                    if (region instanceof ITextRegionCollection) {
                        handled = this.prepareTextRegion((ITextRegionCollection)region, partitionStartOffset, partitionLength, holdResults);
                    } else if (region.getType() == "TWIG_CONTENT" || region.getType() == "TWIG_COMMENT") {
                        handled = this.prepareTwigRegions(holdResults, (ITwigScriptRegion)region, startOffset, partitionStartOffset, partitionLength);
                    } else {
                        attr = this.getAttributeFor(region);
                        if (attr != null) {
                            handled = true;
                            styleRange = this.createStyleRange((ITextRegionCollection)structuredDocumentRegion, region, attr, partitionStartOffset, partitionLength);
                            holdResults.add(styleRange);
                        }
                    }
                }
                ++i;
            }
            structuredDocumentRegion = structuredDocumentRegion.getNext();
        }
        return handled;
    }

    public Map<String, String> getTwigColorTypesMap() {
        return fTwigColorTypes;
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        if (event != null) {
            String prefKey = event.getProperty();
            if ("codeStyleNormal".equals(prefKey) || "editorColorBoundarymaker".equals(prefKey) || "editorStmtColorBoundarymaker".equals(prefKey) || "editorColorVariable".equals(prefKey) || "editorColorString".equals(prefKey) || "editorColorComment".equals(prefKey) || "editorColorPhpdoc".equals(prefKey) || "editorColorNumber".equals(prefKey) || "editorColorKeyword".equals(prefKey) || "editorColorTask".equals(prefKey)) {
                this.addTextAttribute(prefKey);
            } else if (PreferenceConstants.getEnabledPreferenceKey("codeStyleNormal").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorBoundarymaker").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorStmtColorBoundarymaker").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorBlocknameColor").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorJson").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorVariable").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorString").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorKeyword").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorComment").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorPhpdoc").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorNumber").equals(prefKey) || PreferenceConstants.getEnabledPreferenceKey("editorColorTask").equals(prefKey)) {
                boolean enabled = this.getColorPreferences().getBoolean(prefKey);
                prefKey = prefKey.split("\\.")[1];
                if (enabled) {
                    this.addTextAttribute(prefKey);
                } else {
                    this.addDefaultTextAttribute(prefKey);
                }
            }
        } else {
            this.loadColors();
        }
        if (this.fRecHighlighter != null) {
            this.fRecHighlighter.refreshDisplay();
        }
    }

    public void loadColors() {
        this.addTextAttribute("codeStyleNormal");
        this.addTextAttribute("editorColorBoundarymaker");
        this.addTextAttribute("editorStmtColorBoundarymaker");
        this.addTextAttribute("editorColorKeyword");
        this.addTextAttribute("editorBlocknameColor");
        this.addTextAttribute("editorColorVariable");
        this.addTextAttribute("editorColorString");
        this.addTextAttribute("editorColorComment");
        this.addTextAttribute("editorColorJson");
        this.addTextAttribute("editorColorInterpolation");
        this.addTextAttribute("editorColorLineComment");
        this.addTextAttribute("editorColorPHPDocComment");
        this.addTextAttribute("editorColorPhpdoc");
        this.addTextAttribute("editorColorNumber");
        this.addTextAttribute("editorColorHeredoc");
        this.addTextAttribute("editorColorTask");
    }

    protected void clearColors() {
        this.getTextAttributes().clear();
    }

    protected void addTextAttribute(String colorKey) {
        String prefString;
        String[] stylePrefs;
        if (this.getColorPreferences() != null && (stylePrefs = ColorHelper.unpackStylePreferences((String)(prefString = this.getColorPreferences().getString(colorKey)))) != null) {
            this.getTextAttributes().put(colorKey, this.createTextAttribute(stylePrefs));
        }
    }

    protected void addDefaultTextAttribute(String colorKey) {
        if (this.getColorPreferences() != null) {
            String prefString = PreferenceConstants.EDITOR_NORMAL_DEFAULT_COLOR;
            this.getColorPreferences().setValue(colorKey, prefString);
            String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
            if (stylePrefs != null) {
                this.getTextAttributes().put(colorKey, this.createTextAttribute(stylePrefs));
            }
        }
    }

    protected TextAttribute createTextAttribute(String[] stylePrefs) {
        int fontModifier = 0;
        if (Boolean.valueOf(stylePrefs[2]).booleanValue()) {
            fontModifier |= 1;
        }
        if (Boolean.valueOf(stylePrefs[3]).booleanValue()) {
            fontModifier |= 2;
        }
        if (Boolean.valueOf(stylePrefs[4]).booleanValue()) {
            fontModifier |= 0x20000000;
        }
        if (Boolean.valueOf(stylePrefs[5]).booleanValue()) {
            fontModifier |= 0x40000000;
        }
        return new TextAttribute(EditorUtility.getColor((RGB)ColorHelper.toRGB((String)stylePrefs[0])), EditorUtility.getColor((RGB)ColorHelper.toRGB((String)stylePrefs[1])), fontModifier);
    }

    public TextAttribute getTextAttributeForColor(String colorKey) {
        return (TextAttribute)this.getTextAttributes().get(colorKey);
    }

    public void setColorPreferences(IPreferenceStore preferenceStore) {
        this.twigColorPreferences = preferenceStore;
    }

    public IPreferenceStore getColorPreferences() {
        if (this.twigColorPreferences != null) {
            return this.twigColorPreferences;
        }
        return PreferenceConstants.getPreferenceStore();
    }
}

