/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.editor;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;

public class SemanticHighlightingStyle {
    private String preferenceKey;
    private boolean boldByDefault = false;
    private boolean italicByDefault = false;
    private boolean strikethroughByDefault = false;
    private boolean underlineByDefault = false;
    private RGB defaultTextColor = new RGB(0, 0, 0);
    private boolean enabledByDefault = true;
    private RGB defaultBackgroundColor = new RGB(255, 255, 255);

    public SemanticHighlightingStyle setDefaultTextColor(int red, int green, int blue) {
        return this.setDefaultTextColor(new RGB(red, green, blue));
    }

    public SemanticHighlightingStyle setDefaultTextColor(RGB defaultTextColor) {
        this.defaultTextColor = defaultTextColor;
        return this;
    }

    public SemanticHighlightingStyle setDefaultBackgroundColor(int red, int green, int blue) {
        return this.setDefaultBackgroundColor(new RGB(red, green, blue));
    }

    public SemanticHighlightingStyle setDefaultBackgroundColor(RGB defaultBackgroundColor) {
        this.defaultBackgroundColor = defaultBackgroundColor;
        return this;
    }

    public SemanticHighlightingStyle(String preferenceKey) {
        this.preferenceKey = preferenceKey;
        this.defaultTextColor = SemanticHighlightingStyle.findRGB(this.getThemeColorKey(), this.getDefaultTextColor());
    }

    public SemanticHighlightingStyle(String preferenceKey, String displayName, boolean boldByDefault, boolean italicByDefault, boolean strikethroughByDefault, boolean underlineByDefault, RGB defaultTextColor) {
        this.preferenceKey = preferenceKey;
        this.boldByDefault = boldByDefault;
        this.italicByDefault = italicByDefault;
        this.strikethroughByDefault = strikethroughByDefault;
        this.underlineByDefault = underlineByDefault;
        this.defaultTextColor = defaultTextColor;
    }

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    protected RGB getDefaultTextColor() {
        return this.defaultTextColor;
    }

    protected RGB getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    private String getThemeColorKey() {
        return "com.dubture.twig.ui." + this.getPreferenceKey() + "Highlighting";
    }

    private static RGB findRGB(String key, RGB defaultRGB) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return defaultRGB;
        }
        ColorRegistry registry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        RGB rgb = registry.getRGB(key);
        if (rgb != null) {
            return rgb;
        }
        return defaultRGB;
    }

    public boolean isBoldByDefault() {
        return this.boldByDefault;
    }

    public SemanticHighlightingStyle setBoldByDefault(boolean boldByDefault) {
        this.boldByDefault = boldByDefault;
        return this;
    }

    public boolean isItalicByDefault() {
        return this.italicByDefault;
    }

    public SemanticHighlightingStyle setItalicByDefault(boolean italicByDefault) {
        this.italicByDefault = italicByDefault;
        return this;
    }

    public boolean isStrikethroughByDefault() {
        return this.strikethroughByDefault;
    }

    public SemanticHighlightingStyle setStrikethroughByDefault(boolean strikethroughByDefault) {
        this.strikethroughByDefault = strikethroughByDefault;
        return this;
    }

    public boolean isUnderlineByDefault() {
        return this.underlineByDefault;
    }

    public SemanticHighlightingStyle setUnderlineByDefault(boolean underlineByDefault) {
        this.underlineByDefault = underlineByDefault;
        return this;
    }

    public SemanticHighlightingStyle setPreferenceKey(String preferenceKey) {
        this.preferenceKey = preferenceKey;
        return this;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public SemanticHighlightingStyle setEnabledByDefault(boolean enabledByDefault) {
        this.enabledByDefault = enabledByDefault;
        return this;
    }
}

