/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;

public class StructuredTextMultiPassContentFormatter
extends MultiPassContentFormatter {
    private static final String SLAVE_FORMATTING_STRATEGY_EXTENDED_ID = "slaveformattingstrategy";
    private List<String> fInstalledPartitionTypes;

    public StructuredTextMultiPassContentFormatter(String partitioning, String type) {
        super(partitioning, type);
    }

    protected void formatMaster(IFormattingContext context, IDocument document, int offset, int length) {
        long startTime = System.currentTimeMillis();
        super.formatMaster(context, document, offset, length);
        if (Logger.DEBUG_FORMAT) {
            long endTime = System.currentTimeMillis();
            System.out.println("formatModel time: " + (endTime - startTime));
        }
    }

    protected void formatSlave(IFormattingContext context, IDocument document, int offset, int length, String type) {
        List<String> installedTypes = this.getInstalledPartitionTypes();
        if (installedTypes.contains(type)) {
            super.formatSlave(context, document, offset, length, type);
        } else {
            String contextType;
            boolean findExtendedSlaveFormatter = true;
            super.formatSlave(context, document, offset, length, type);
            Object contextPartition = context.getProperty((Object)"formatting.context.partition");
            if (contextPartition instanceof TypedPosition && (contextType = ((TypedPosition)contextPartition).getType()) == type) {
                installedTypes.add(type);
                findExtendedSlaveFormatter = false;
            }
            if (findExtendedSlaveFormatter) {
                Object configuration = ExtendedConfigurationBuilder.getInstance().getConfiguration(SLAVE_FORMATTING_STRATEGY_EXTENDED_ID, type);
                if (configuration instanceof IFormattingStrategy) {
                    this.setSlaveStrategy((IFormattingStrategy)configuration, type);
                    super.formatSlave(context, document, offset, length, type);
                }
                installedTypes.add(type);
            }
        }
    }

    private List<String> getInstalledPartitionTypes() {
        if (this.fInstalledPartitionTypes == null) {
            this.fInstalledPartitionTypes = new ArrayList<String>();
        }
        return this.fInstalledPartitionTypes;
    }
}

