/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.editor;

import com.dubture.twig.core.documentModel.dom.IImplForTwig;
import com.dubture.twig.core.documentModel.parser.TwigSourceParser;
import com.dubture.twig.core.search.IOccurrencesFinder;
import com.dubture.twig.ui.actions.TwigRefactorActionGroup;
import com.dubture.twig.ui.editor.TwigStructuredTextViewer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.actions.CompositeActionGroup;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;

public class TwigStructuredEditor
extends StructuredTextEditor {
    private OccurrencesFinderJob fOccurrencesFinderJob;
    private OccurrencesFinderJobCanceler fOccurrencesFinderJobCanceler;
    private ISelection fForcedMarkOccurrencesSelection;
    private CompositeActionGroup fContextMenuGroup;
    private TwigRefactorActionGroup refactorGroup = null;
    private CompositeActionGroup fActionGroups;
    private Annotation[] fOccurrenceAnnotations = null;

    public TwigStructuredEditor() {
        this.setDocumentProvider((IDocumentProvider)DLTKUIPlugin.getDocumentProvider());
    }

    private TwigRefactorActionGroup getRefactorGroup() {
        if (this.refactorGroup != null) {
            return this.refactorGroup;
        }
        this.refactorGroup = new TwigRefactorActionGroup(this);
        return this.refactorGroup;
    }

    protected void createActions() {
        this.fActionGroups = new CompositeActionGroup(new ActionGroup[]{this.getRefactorGroup()});
        this.fContextMenuGroup = new CompositeActionGroup(new ActionGroup[]{this.getRefactorGroup()});
        super.createActions();
    }

    public ActionGroup getActionGroup() {
        return this.fActionGroups;
    }

    public CompositeActionGroup getContextMenuGroup() {
        return this.fContextMenuGroup;
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        if (this.fContextMenuGroup != null) {
            ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
            this.fContextMenuGroup.setContext(context);
            this.fContextMenuGroup.fillContextMenu(menu);
            this.fContextMenuGroup.setContext(null);
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        IFile resource = null;
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            resource = fileInput.getFile();
        } else {
            boolean cfr_ignored_0 = input instanceof IStorageEditorInput;
        }
        if (resource instanceof IFile) {
            String ext = resource.getFileExtension();
            if (ext != null && (ext.contains("twig") || ext.contains("html"))) {
                TwigSourceParser.editFile.set(resource);
                super.doSetInput(input);
            } else {
                super.doSetInput(input);
            }
        } else {
            super.doSetInput(input);
        }
        ImageDescriptor imageDescriptor = input.getImageDescriptor();
        if (imageDescriptor != null) {
            this.setTitleImage(JFaceResources.getResources().createImageWithDefault(imageDescriptor));
        }
    }

    protected StructuredTextViewer createStructedTextViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
        return new TwigStructuredTextViewer((ITextEditor)this, parent, verticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTwigOccurrenceAnnotations() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOccurrenceAnnotations.length;
                while (i < length) {
                    annotationModel.removeAnnotation(this.fOccurrenceAnnotations[i]);
                    ++i;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    protected void uninstallOccurrencesFinder() {
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
            this.fOccurrencesFinderJob = null;
        }
        if (this.fOccurrencesFinderJobCanceler != null) {
            this.fOccurrencesFinderJobCanceler.uninstall();
            this.fOccurrencesFinderJobCanceler = null;
        }
        this.removeTwigOccurrenceAnnotations();
    }

    protected void setSelection(ISourceReference reference, boolean moveCursor) {
        block20: {
            if (this.getSelectionProvider() == null) {
                return;
            }
            final ISelection[] selections = new ISelection[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    selections[0] = TwigStructuredEditor.this.getSelectionProvider().getSelection();
                }
            });
            if (selections[0] == null) {
                return;
            }
            ISelection selection = selections[0];
            if (selection instanceof TextSelection) {
                TextSelection textSelection = (TextSelection)selection;
                if (textSelection instanceof IStructuredSelection) {
                    Object firstElement = ((IStructuredSelection)textSelection).getFirstElement();
                    boolean cfr_ignored_0 = firstElement instanceof IImplForTwig;
                }
                if (moveCursor && (textSelection.getOffset() != 0 || textSelection.getLength() != 0)) {
                    this.markInNavigationHistory();
                }
            }
            if (reference != null) {
                StyledText textWidget = null;
                ISourceViewer sourceViewer = this.getSourceViewer();
                if (sourceViewer != null) {
                    textWidget = sourceViewer.getTextWidget();
                }
                if (textWidget == null) {
                    return;
                }
                try {
                    ISourceRange range = null;
                    range = reference.getSourceRange();
                    if (range == null) {
                        return;
                    }
                    int offset = range.getOffset();
                    int length = range.getLength();
                    if (offset < 0 || length < 0) {
                        return;
                    }
                    this.setHighlightRange(offset, length, moveCursor);
                    if (!moveCursor) {
                        return;
                    }
                    offset = -1;
                    length = -1;
                    if (reference instanceof IMember && (range = ((IMember)reference).getNameRange()) != null) {
                        offset = range.getOffset();
                        length = range.getLength();
                    }
                    if (offset <= -1 || length <= 0) break block20;
                    try {
                        textWidget.setRedraw(false);
                        sourceViewer.revealRange(offset, length);
                        sourceViewer.setSelectedRange(offset, length);
                    }
                    finally {
                        textWidget.setRedraw(true);
                    }
                    this.markInNavigationHistory();
                }
                catch (ModelException modelException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (moveCursor) {
                this.resetHighlightRange();
                this.markInNavigationHistory();
            }
        }
    }

    public void dispose() {
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
            this.fActionGroups = null;
        }
        super.dispose();
    }

    public IDocument getDocument() {
        if (this.getSourceViewer() != null) {
            return this.getSourceViewer().getDocument();
        }
        return null;
    }

    class OccurrencesFinderJob
    extends Job {
        private final IDocument fDocument;
        private final ISelection fSelection;
        private final ISelectionValidator fPostSelectionValidator;
        private boolean fCanceled;
        private final IOccurrencesFinder.OccurrenceLocation[] fLocations;

        public OccurrencesFinderJob(IDocument document, IOccurrencesFinder.OccurrenceLocation[] locations, ISelection selection) {
            super("mark occrrences job name");
            this.fCanceled = false;
            this.fDocument = document;
            this.fSelection = selection;
            this.fLocations = locations;
            this.fPostSelectionValidator = TwigStructuredEditor.this.getSelectionProvider() instanceof ISelectionValidator ? (ISelectionValidator)TwigStructuredEditor.this.getSelectionProvider() : null;
        }

        void doCancel() {
            this.fCanceled = true;
            this.cancel();
        }

        private boolean isCanceled(IProgressMonitor progressMonitor) {
            return this.fCanceled || progressMonitor.isCanceled() || this.fPostSelectionValidator != null && !this.fPostSelectionValidator.isValid(this.fSelection) && TwigStructuredEditor.this.fForcedMarkOccurrencesSelection != this.fSelection || LinkedModeModel.hasInstalledModel((IDocument)this.fDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            StructuredTextViewer textViewer = TwigStructuredEditor.this.getTextViewer();
            if (textViewer == null) {
                return Status.CANCEL_STATUS;
            }
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return Status.CANCEL_STATUS;
            }
            IDocumentProvider documentProvider = TwigStructuredEditor.this.getDocumentProvider();
            if (documentProvider == null) {
                return Status.CANCEL_STATUS;
            }
            IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)TwigStructuredEditor.this.getEditorInput());
            if (annotationModel == null) {
                return Status.CANCEL_STATUS;
            }
            int length = this.fLocations.length;
            HashMap<1, Position> annotationMap = new HashMap<1, Position>(length);
            int i = 0;
            while (i < length) {
                if (this.isCanceled(progressMonitor)) {
                    return Status.CANCEL_STATUS;
                }
                IOccurrencesFinder.OccurrenceLocation location = this.fLocations[i];
                Position position = new Position(location.getOffset(), location.getLength());
                String description = location.getDescription();
                String annotationType = location.getFlags() == 1 ? "org.eclipse.php.ui.occurrences.write" : "org.eclipse.php.ui.occurrences";
                ReconcileAnnotationKey reconcileAnnotationKey = new ReconcileAnnotationKey(null, "org.eclipse.php.PHP_DEFAULT", 0);
                TemporaryAnnotation annotation = new TemporaryAnnotation(position, annotationType, description, reconcileAnnotationKey){

                    public void paint(GC gc, Canvas canvas, Rectangle r) {
                        ImageUtilities.drawImage((Image)PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_OBJS_OCCURRENCES), (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
                    }
                };
                annotationMap.put(annotation, position);
                ++i;
            }
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            Object object = TwigStructuredEditor.this.getLockObject(annotationModel);
            synchronized (object) {
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(TwigStructuredEditor.this.fOccurrenceAnnotations, annotationMap);
                } else {
                    TwigStructuredEditor.this.removeTwigOccurrenceAnnotations();
                    for (Map.Entry entry : annotationMap.entrySet()) {
                        annotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
                    }
                }
                TwigStructuredEditor.this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
            }
            return Status.OK_STATUS;
        }
    }

    class OccurrencesFinderJobCanceler
    implements IDocumentListener,
    ITextInputListener {
        OccurrencesFinderJobCanceler() {
        }

        public void install() {
            ISourceViewer sourceViewer = TwigStructuredEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            StyledText text = sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            sourceViewer.addTextInputListener((ITextInputListener)this);
            IDocument document = sourceViewer.getDocument();
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void uninstall() {
            IDocument document;
            IDocumentProvider documentProvider;
            ISourceViewer sourceViewer = TwigStructuredEditor.this.getSourceViewer();
            if (sourceViewer != null) {
                sourceViewer.removeTextInputListener((ITextInputListener)this);
            }
            if ((documentProvider = TwigStructuredEditor.this.getDocumentProvider()) != null && (document = documentProvider.getDocument((Object)TwigStructuredEditor.this.getEditorInput())) != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (TwigStructuredEditor.this.fOccurrencesFinderJob != null) {
                TwigStructuredEditor.this.fOccurrencesFinderJob.doCancel();
            }
        }

        public void documentChanged(DocumentEvent event) {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == null) {
                return;
            }
            oldInput.removeDocumentListener((IDocumentListener)this);
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput == null) {
                return;
            }
            newInput.addDocumentListener((IDocumentListener)this);
        }
    }
}

