/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.editor.adapter;

import com.dubture.twig.core.documentModel.dom.ElementImplForTwig;
import com.dubture.twig.core.documentModel.parser.regions.TwigScriptRegion;
import com.dubture.twig.core.log.Logger;
import com.dubture.twig.ui.TwigPluginImages;
import com.dubture.twig.ui.editor.adapter.RefreshStructureJob;
import java.util.Collection;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.html.ui.internal.contentoutline.JFaceNodeAdapterForHTML;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeAdapterFactory;
import org.w3c.dom.Node;

public class JFaceNodeAdapterForTwig
extends JFaceNodeAdapterForHTML {
    JFaceNodeAdapterFactory fAdapterFactory;
    private RefreshStructureJob fRefreshJob = null;

    public JFaceNodeAdapterForTwig(JFaceNodeAdapterFactory adapterFactory) {
        super(adapterFactory);
        this.fAdapterFactory = adapterFactory;
    }

    private synchronized RefreshStructureJob getRefreshJob() {
        if (this.fRefreshJob == null) {
            this.fRefreshJob = new RefreshStructureJob();
        }
        return this.fRefreshJob;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (notifier instanceof Node) {
            Collection listeners = this.fAdapterFactory.getListeners();
            for (Object listener : listeners) {
                StructuredViewer structuredViewer;
                if (!(listener instanceof StructuredViewer) || eventType != 4 && eventType != 5 && eventType != 1 || (structuredViewer = (StructuredViewer)listener).getControl() == null) continue;
                this.getRefreshJob().refresh(structuredViewer, (Node)notifier);
            }
        }
    }

    public String getLabelText(Object node) {
        if (node instanceof ElementImplForTwig) {
            TwigScriptRegion twig;
            ITextRegion scriptRegion;
            IStructuredDocumentRegion flatNode;
            ElementImplForTwig element = (ElementImplForTwig)node;
            if ("statement".equals(element.getNodeName()) && (flatNode = element.getFirstStructuredDocumentRegion()).getNumberOfRegions() > 1 && (scriptRegion = flatNode.getRegions().get(1)) instanceof TwigScriptRegion && (twig = (TwigScriptRegion)scriptRegion).getTokenCount() > 0) {
                try {
                    ITextRegion nameRegion = null;
                    int i = 0;
                    while (i < twig.getTokenCount()) {
                        if ("TWIG_BLOCKNAME".equals(twig.getTwigTokenType(i))) {
                            nameRegion = twig.getTwigToken(i);
                        }
                        ++i;
                    }
                    if (nameRegion == null) {
                        return super.getLabelText(node);
                    }
                    return flatNode.getText(scriptRegion).substring(nameRegion.getStart(), nameRegion.getEnd()).trim();
                }
                catch (BadLocationException e) {
                    Logger.logException((Throwable)e);
                }
            }
            return element.getTagName();
        }
        return super.getLabelText(node);
    }

    public Image getLabelImage(Object node) {
        if (node instanceof ElementImplForTwig) {
            ElementImplForTwig element = (ElementImplForTwig)node;
            if ("statement".equals(element.getNodeName())) {
                return TwigPluginImages.get("com.dubture.twig.ui.statement.png");
            }
            if ("print".equals(element.getNodeName())) {
                return TwigPluginImages.get("com.dubture.twig.ui.print.png");
            }
        }
        return super.getLabelImage(node);
    }
}

