/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.editor.autoEdit;

import com.dubture.twig.core.TwigCorePlugin;
import com.dubture.twig.core.documentModel.parser.regions.ITwigScriptRegion;
import com.dubture.twig.core.format.FormatterUtils;
import com.dubture.twig.core.log.Logger;
import com.dubture.twig.ui.TwigUICorePlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.ui.text.PHPDocumentRegionEdgeMatcher;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.xml.core.internal.parser.regions.XMLContentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class CloseTagAutoEditStrategyTwig
implements IAutoEditStrategy {
    protected static final char CURLY_OPEN = '{';
    protected static final char CURLY_CLOSE = '}';
    protected static final char ROUND_OPEN = '(';
    protected static final char ROUND_CLOSE = ')';
    protected static final char SQUARE_OPEN = '[';
    protected static final char SQUARE_CLOSE = ']';
    protected static final char SINGLE_QOUTE = '\'';
    protected static final char DOUBLE_QOUTES = '\"';
    protected static final char BACK_QOUTE = '`';
    protected static final char BACK_SLASH = '\\';
    protected static PHPDocumentRegionEdgeMatcher matcher = new PHPDocumentRegionEdgeMatcher();
    protected static final int SEARCH_NOT_VALID = -1;
    protected static final int MATCHING_BRACKET_NEEDED = 0;
    protected static final int MATCHING_BRACKET_NOT_NEEDED = 1;
    private IDocument document;
    private DocumentCommand command;

    public void customizeDocumentCommand(IDocument doc, DocumentCommand comm) {
        this.document = doc;
        this.command = comm;
        IStructuredModel model = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
                if (model != null && this.command.text != null) {
                    char removedChar;
                    int length = this.command.text.length();
                    if (length == 0 && this.command.length == 1 && ((removedChar = this.document.getChar(this.command.offset)) == '(' || removedChar == '[' || removedChar == '{')) {
                        this.deletePairBreaket((IStructuredDocument)this.document, this.command, removedChar);
                    }
                    if (length == 1) {
                        IDOMNode node = (IDOMNode)model.getIndexedRegion(this.command.offset - 1);
                        if (this.command.text.equals("%")) {
                            if (this.prefixedWith(this.document, this.command.offset, "{")) {
                                this.autoCloseStatementTag(node);
                            } else if (this.prefixedWith(this.document, this.command.offset, " ")) {
                                this.autoCreateStatementTag(node);
                            }
                        } else if (this.command.text.equals("{")) {
                            this.autoClosePrintTag(node);
                        }
                    }
                }
            }
            catch (BadLocationException e) {
                TwigCorePlugin.log((Exception)((Object)e));
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private boolean autoCreateStatementTag(IDOMNode node) {
        IPreferenceStore store = TwigUICorePlugin.getDefault().getPreferenceStore();
        boolean autocreate = store.getBoolean("autocreate_statement_tags");
        if (!autocreate || node == null) {
            return true;
        }
        this.command.text = "{%  %}";
        this.command.shiftsCaret = false;
        this.command.caretOffset = this.command.offset + 3;
        this.command.doit = false;
        return true;
    }

    private boolean autoCloseStatementTag(IDOMNode node) {
        IPreferenceStore store = TwigUICorePlugin.getDefault().getPreferenceStore();
        boolean autoclose = store.getBoolean("autoclose_statement_tags");
        if (!autoclose || node == null) {
            return true;
        }
        this.command.text = String.valueOf(this.command.text) + "  %";
        this.command.shiftsCaret = false;
        this.command.caretOffset = this.command.offset + 2;
        this.command.doit = false;
        return true;
    }

    private void autoClosePrintTag(IDOMNode node) {
        IPreferenceStore store = TwigUICorePlugin.getDefault().getPreferenceStore();
        boolean autoclose = store.getBoolean("autoclose_print_tags");
        if (!autoclose) {
            return;
        }
        String append = "}";
        int caretOffset = 1;
        if (node != null) {
            if (this.prefixedWith(this.document, this.command.offset, "{")) {
                append = "  }";
                caretOffset = 2;
            }
            this.command.text = String.valueOf(this.command.text) + append;
            this.command.shiftsCaret = false;
            this.command.caretOffset = this.command.offset + caretOffset;
            this.command.doit = false;
        } else {
            this.command.text = String.valueOf(this.command.text) + append;
            this.command.shiftsCaret = false;
            this.command.caretOffset = this.command.offset + caretOffset;
            this.command.doit = false;
        }
    }

    private boolean prefixedWith(IDocument document, int offset, String string) {
        String prefix;
        boolean larger;
        block3: {
            try {
                larger = document.getLength() >= string.length();
                prefix = document.get(offset - string.length(), string.length());
                if (prefix.length() != 0 || !string.equals(" ")) break block3;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return larger && prefix.equals(string);
    }

    private void deletePairBreaket(IStructuredDocument document, DocumentCommand command, char deletedChar) {
        int offset = command.offset;
        IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
        if (sdRegion == null || sdRegion.getType() != "XML_CONTENT") {
            return;
        }
        try {
            ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
            if (tRegion instanceof XMLContentRegion) {
                char nextChar = document.getChar(offset + 1);
                char matchingChar = CloseTagAutoEditStrategyTwig.getMatchingChar(deletedChar);
                if (nextChar == '}' && nextChar == matchingChar) {
                    command.length = 2;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected static char getMatchingChar(char c) {
        switch (c) {
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '\"': 
            case '\'': 
            case '`': {
                return c;
            }
        }
        return '-';
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected int isMatchingCharNeeded(IStructuredDocument document, int offset, char bracketChar) {
        try {
            String postCharState = FormatterUtils.getPartitionType((IStructuredDocument)document, (int)(offset + 1));
            if (postCharState != "com.dubture.twig.TWIG_DEFAULT" && postCharState != "PHP_OPENTAG" && postCharState != "PHP_CLOSETAG" && CloseTagAutoEditStrategyTwig.isSpecialOpenCurlyInQuotes(document, offset)) {
                postCharState = FormatterUtils.getPartitionType((IStructuredDocument)document, (int)(offset + 2));
            }
            if (document.getLength() == offset + 1) {
                postCharState = FormatterUtils.getPartitionType((IStructuredDocument)document, (int)offset);
                if (postCharState == "com.dubture.twig.TWIG_DEFAULT" || postCharState == "PHP_OPENTAG" || postCharState == "PHP_CLOSETAG") {
                    if (document.getChar(offset) == CloseTagAutoEditStrategyTwig.getMatchingChar(bracketChar)) {
                        return 1;
                    }
                    return 0;
                }
                return 1;
            }
            if (postCharState != "com.dubture.twig.TWIG_DEFAULT" && postCharState != "PHP_OPENTAG" && postCharState != "PHP_CLOSETAG") {
                return -1;
            }
            int currOffset = offset + 1;
            IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(currOffset);
            while (currOffset >= 0 && sdRegion != null) {
                if (sdRegion.getType() != "TWIG_CONTENT") {
                    currOffset = sdRegion.getStartOffset() - 1;
                    sdRegion = document.getRegionAtCharacterOffset(currOffset);
                    continue;
                }
                ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(currOffset);
                if (tRegion.getType().equals("PHP_CLOSE")) {
                    tRegion = sdRegion.getRegionAtCharacterOffset(currOffset - 1);
                }
                int regionStart = sdRegion.getStartOffset(tRegion);
                if (tRegion instanceof ITextRegionContainer) {
                    ITextRegionContainer container = (ITextRegionContainer)tRegion;
                    tRegion = container.getRegionAtCharacterOffset(currOffset);
                    regionStart += tRegion.getStart();
                }
                if (tRegion instanceof ITwigScriptRegion) {
                    ITwigScriptRegion scriptRegion = (ITwigScriptRegion)tRegion;
                    tRegion = scriptRegion.getTwigToken(currOffset - regionStart);
                    while (tRegion != null) {
                        String regionType = tRegion.getType();
                        if (regionType == "TWIG_DELIMITER") {
                            char token = document.getChar(regionStart + tRegion.getStart());
                            if ((token == '(' || token == '[' || token == '{') && token == bracketChar && matcher.match((IDocument)document, regionStart + tRegion.getStart() + 1) == null) {
                                return 0;
                            }
                        } else {
                            if (regionType == "PHP_CURLY_OPEN" || regionType == "PHP_CURLY_CLOSE" || regionType == "TWIG_HASH_END") {
                                return 1;
                            }
                            if (regionType == "TWIG_HASH_START") {
                                return 0;
                            }
                        }
                        if (tRegion.getStart() > 0) {
                            tRegion = scriptRegion.getTwigToken(tRegion.getStart() - 1);
                            continue;
                        }
                        break;
                    }
                } else if (tRegion.getType() == "TWIG_CLOSE") {
                    return 0;
                }
                IStructuredDocumentRegion iStructuredDocumentRegion = sdRegion = (currOffset = sdRegion.getStartOffset() - 1) < 0 ? null : document.getRegionAtCharacterOffset(currOffset);
            }
        }
        catch (BadLocationException e) {
            Logger.logException((Throwable)e);
        }
        return 1;
    }

    protected static boolean isSpecialOpenCurlyInQuotes(IStructuredDocument document, int offset) throws BadLocationException {
        IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
        if (sdRegion == null) {
            return false;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
        if (tRegion.getType() != "PHP_ENCAPSED_AND_WHITESPACE") {
            return false;
        }
        char firstChar = document.getChar(sdRegion.getStartOffset() + tRegion.getStart());
        if (firstChar != '\"' && firstChar != '`') {
            return false;
        }
        char bracketChar = document.getChar(offset + 1);
        return bracketChar == '$';
    }
}

