/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.editor.autoEdit;

import com.dubture.twig.core.format.FormatterUtils;
import com.dubture.twig.ui.editor.autoEdit.CurlyCloseAutoEditStrategy;
import com.dubture.twig.ui.editor.autoEdit.CurlyOpenAutoEditStrategy;
import com.dubture.twig.ui.editor.autoEdit.IndentLineAutoEditStrategy;
import com.dubture.twig.ui.editor.autoEdit.MatchingBracketAutoEditStrategy;
import com.dubture.twig.ui.editor.autoEdit.QuotesAutoEditStrategy;
import com.dubture.twig.ui.editor.autoEdit.TabAutoEditStrategy;
import com.dubture.twig.ui.editor.autoEdit.TwigAutoIndentStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class MainAutoEditStrategy
implements IAutoEditStrategy {
    private static IAutoEditStrategy indentLineAutoEditStrategy = new IndentLineAutoEditStrategy();
    private static IAutoEditStrategy curlyOpenAutoEditStrategy = new CurlyOpenAutoEditStrategy();
    private static IAutoEditStrategy curlyCloseAutoEditStrategy = new CurlyCloseAutoEditStrategy();
    private static IAutoEditStrategy matchingBracketAutoEditStrategy = new MatchingBracketAutoEditStrategy();
    private static IAutoEditStrategy quotesAutoEditStrategy = new QuotesAutoEditStrategy();
    private static IAutoEditStrategy tabAutoEditStrategy = new TabAutoEditStrategy();
    private static IAutoEditStrategy autoIndentStrategy = new TwigAutoIndentStrategy();

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.text == null) {
            return;
        }
        String partitionType = FormatterUtils.getPartitionType((IStructuredDocument)((IStructuredDocument)document), (int)command.offset);
        if (!partitionType.equals("com.dubture.twig.TWIG_COMMENT_TEXT")) {
            if (partitionType.equals("com.dubture.twig.TWIG_QUOTED_STRING")) {
                indentLineAutoEditStrategy.customizeDocumentCommand(document, command);
                quotesAutoEditStrategy.customizeDocumentCommand(document, command);
            } else if (partitionType.equals("com.dubture.twig.TWIG_DEFAULT") || partitionType.equals("com.dubture.twig.TWIG_COMMENT_TEXT")) {
                matchingBracketAutoEditStrategy.customizeDocumentCommand(document, command);
                curlyOpenAutoEditStrategy.customizeDocumentCommand(document, command);
                curlyCloseAutoEditStrategy.customizeDocumentCommand(document, command);
                indentLineAutoEditStrategy.customizeDocumentCommand(document, command);
                tabAutoEditStrategy.customizeDocumentCommand(document, command);
                quotesAutoEditStrategy.customizeDocumentCommand(document, command);
                autoIndentStrategy.customizeDocumentCommand(document, command);
            }
        }
    }
}

