/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.editor.autoEdit;

import com.dubture.twig.core.documentModel.parser.regions.ITwigScriptRegion;
import com.dubture.twig.core.format.FormatterUtils;
import com.dubture.twig.core.log.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.ui.autoEdit.MatchingCharAutoEditStrategy;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class MatchingBracketAutoEditStrategy
extends MatchingCharAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.text != null) {
            int length = command.text.length();
            if (length == 0 && command.length == 1) {
                try {
                    char removedChar = document.getChar(command.offset);
                    if (removedChar == '(' || removedChar == '[' || removedChar == '{' || removedChar == '%') {
                        this.deletePairBreaket((IStructuredDocument)document, command, removedChar);
                    }
                }
                catch (BadLocationException e) {
                    Logger.logException((Throwable)e);
                }
            }
            if (length == 1) {
                char c = command.text.charAt(0);
                if (c == '(' || c == '[' || c == '{') {
                    this.autoAddPairBracket((IStructuredDocument)document, command);
                } else if (c == ')' || c == ']' || c == '}') {
                    this.insertClosingChar((IStructuredDocument)document, command);
                }
            }
        }
    }

    private void autoAddPairBracket(IStructuredDocument document, DocumentCommand command) {
        block6: {
            int currentPosition = command.offset;
            int commandLength = command.length;
            char c = command.text.charAt(0);
            boolean extraCharWasAdded = false;
            String removedText = "";
            try {
                if (currentPosition + commandLength < document.getLength() && !this.shouldAddClosingBracket(document, currentPosition + commandLength, false)) {
                    return;
                }
                removedText = document.get(currentPosition, commandLength);
                document.getUndoManager().disableUndoManagement();
                document.replace(currentPosition, commandLength, command.text);
                extraCharWasAdded = true;
                int result = this.isMatchingCharNeeded(document, currentPosition, c);
                document.replace(currentPosition, 1, removedText);
                document.getUndoManager().enableUndoManagement();
                if (result == 0) {
                    char match = MatchingBracketAutoEditStrategy.getMatchingChar((char)c);
                    command.text = String.valueOf(command.text) + match;
                    document.replace(currentPosition, commandLength, command.text);
                    document.getUndoManager().disableUndoManagement();
                    document.replace(currentPosition + 1, 0, "");
                    document.getUndoManager().enableUndoManagement();
                    this.adjustDocumentOffset(command);
                    command.length = 0;
                    command.text = "";
                }
            }
            catch (Exception exc) {
                Logger.logException((Throwable)exc);
                if (!extraCharWasAdded) break block6;
                try {
                    document.replace(currentPosition, 1, removedText);
                    document.getUndoManager().enableUndoManagement();
                }
                catch (BadLocationException e) {
                    Logger.logException((Throwable)e);
                }
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected int isMatchingCharNeeded(IStructuredDocument document, int offset, char bracketChar) {
        try {
            String postCharState = FormatterUtils.getPartitionType((IStructuredDocument)document, (int)(offset + 1));
            if (postCharState != "com.dubture.twig.TWIG_DEFAULT" && postCharState != "PHP_OPENTAG" && postCharState != "PHP_CLOSETAG" && MatchingBracketAutoEditStrategy.isSpecialOpenCurlyInQuotes((IStructuredDocument)document, (int)offset)) {
                postCharState = FormatterUtils.getPartitionType((IStructuredDocument)document, (int)(offset + 2));
            }
            if (document.getLength() == offset + 1) {
                postCharState = FormatterUtils.getPartitionType((IStructuredDocument)document, (int)offset);
                if (postCharState == "com.dubture.twig.TWIG_DEFAULT" || postCharState == "PHP_OPENTAG" || postCharState == "PHP_CLOSETAG") {
                    if (document.getChar(offset) == MatchingBracketAutoEditStrategy.getMatchingChar((char)bracketChar)) {
                        return 1;
                    }
                    return 0;
                }
                return 1;
            }
            if (postCharState != "com.dubture.twig.TWIG_DEFAULT" && postCharState != "PHP_OPENTAG" && postCharState != "PHP_CLOSETAG") {
                return -1;
            }
            int currOffset = offset + 1;
            IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(currOffset);
            while (currOffset >= 0 && sdRegion != null) {
                if (sdRegion.getType() != "TWIG_CONTENT") {
                    currOffset = sdRegion.getStartOffset() - 1;
                    sdRegion = document.getRegionAtCharacterOffset(currOffset);
                    continue;
                }
                ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(currOffset);
                if (tRegion.getType().equals("PHP_CLOSE")) {
                    tRegion = sdRegion.getRegionAtCharacterOffset(currOffset - 1);
                }
                int regionStart = sdRegion.getStartOffset(tRegion);
                if (tRegion instanceof ITextRegionContainer) {
                    ITextRegionContainer container = (ITextRegionContainer)tRegion;
                    tRegion = container.getRegionAtCharacterOffset(currOffset);
                    regionStart += tRegion.getStart();
                }
                if (tRegion instanceof ITwigScriptRegion) {
                    ITwigScriptRegion scriptRegion = (ITwigScriptRegion)tRegion;
                    tRegion = scriptRegion.getTwigToken(currOffset - regionStart);
                    while (tRegion != null) {
                        String regionType = tRegion.getType();
                        if (regionType == "TWIG_DELIMITER") {
                            char token = document.getChar(regionStart + tRegion.getStart());
                            if ((token == '(' || token == '[' || token == '{') && token == bracketChar && matcher.match((IDocument)document, regionStart + tRegion.getStart() + 1) == null) {
                                return 0;
                            }
                        } else {
                            if (regionType == "PHP_CURLY_OPEN" || regionType == "PHP_CURLY_CLOSE" || regionType == "TWIG_HASH_END") {
                                return 1;
                            }
                            if (regionType == "TWIG_HASH_START") {
                                return 0;
                            }
                        }
                        if (tRegion.getStart() > 0) {
                            tRegion = scriptRegion.getTwigToken(tRegion.getStart() - 1);
                            continue;
                        }
                        break;
                    }
                } else if (tRegion.getType() == "TWIG_CLOSE") {
                    return 0;
                }
                IStructuredDocumentRegion iStructuredDocumentRegion = sdRegion = (currOffset = sdRegion.getStartOffset() - 1) < 0 ? null : document.getRegionAtCharacterOffset(currOffset);
            }
        }
        catch (BadLocationException e) {
            Logger.logException((Throwable)e);
        }
        return 1;
    }

    private void insertClosingChar(IStructuredDocument document, DocumentCommand command) {
        int endSelection = command.offset + command.length;
        char addedChar = command.text.charAt(0);
        if (endSelection == document.getLength()) {
            return;
        }
        try {
            int result;
            char nextChar = document.getChar(endSelection);
            if (nextChar == addedChar && (result = this.isMatchingCharNeeded(document, endSelection, MatchingBracketAutoEditStrategy.getMatchingChar((char)addedChar))) == 1 && (matcher.match((IDocument)document, endSelection + 1) != null || document.getLength() == endSelection + 1)) {
                if (command.length == 0) {
                    this.adjustDocumentOffset(command);
                    command.text = "";
                } else {
                    ++command.length;
                }
            }
        }
        catch (BadLocationException e) {
            Logger.logException((Throwable)e);
        }
    }

    private void deletePairBreaket(IStructuredDocument document, DocumentCommand command, char deletedChar) {
        int offset = command.offset;
        IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
        if (sdRegion == null || sdRegion.getType() != "TWIG_CONTENT" && sdRegion.getType() != "TWIG_CLOSE" && sdRegion.getType() != "TWIG_STMT_CLOSE") {
            return;
        }
        try {
            ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
            if (tRegion instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)tRegion;
                tRegion = container.getRegionAtCharacterOffset(offset);
            }
            if (tRegion instanceof ITwigScriptRegion) {
                boolean removeBoth;
                ITwigScriptRegion scriptRegion = (ITwigScriptRegion)tRegion;
                if ((tRegion = scriptRegion.getTwigToken(offset - sdRegion.getStartOffset((ITextRegion)scriptRegion))) == null || tRegion.getType() != "TWIG_DELIMITER" && tRegion.getType() != "TWIG_HASH_START") {
                    return;
                }
                char nextChar = document.getChar(offset + 1);
                char matchingChar = MatchingBracketAutoEditStrategy.getMatchingChar((char)deletedChar);
                if (matchingChar == '-' || nextChar != matchingChar) {
                    return;
                }
                boolean bl = removeBoth = this.isMatchingCharNeeded(document, offset, deletedChar) == 1;
                if (removeBoth) {
                    command.length = 2;
                }
            } else if (tRegion instanceof ContextRegion && (sdRegion.getType() == "TWIG_CLOSE" || sdRegion.getType() == "TWIG_STMT_CLOSE")) {
                char nextChar = document.getChar(offset + 1);
                char matchingChar = MatchingBracketAutoEditStrategy.getMatchingChar((char)deletedChar);
                if ((nextChar == '}' || nextChar == '%') && nextChar == matchingChar) {
                    command.length = 2;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

