/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.editor.configuration;

import com.dubture.twig.core.documentModel.parser.partitioner.TwigPartitionTypes;
import com.dubture.twig.core.format.FormatPreferencesSupport;
import com.dubture.twig.core.parser.ast.node.TwigModuleDeclaration;
import com.dubture.twig.core.search.CallFinder;
import com.dubture.twig.core.search.IOccurrencesFinder;
import com.dubture.twig.core.search.NodeFinder;
import com.dubture.twig.core.search.StringFinder;
import com.dubture.twig.core.search.VariableFinder;
import com.dubture.twig.ui.editor.LineStyleProviderForTwig;
import com.dubture.twig.ui.editor.TwigStructuredTextViewer;
import com.dubture.twig.ui.editor.autoEdit.CloseTagAutoEditStrategyTwig;
import com.dubture.twig.ui.editor.autoEdit.MainAutoEditStrategy;
import com.dubture.twig.ui.editor.configuration.TwigStructuredPresentationReconciler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.autoEdit.IndentLineAutoEditStrategy;
import org.eclipse.php.internal.ui.doubleclick.PHPDoubleClickStrategy;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.internal.ui.editor.configuration.StructuredDocumentDamagerRepairer;
import org.eclipse.php.internal.ui.editor.hover.PHPTextHoverProxy;
import org.eclipse.php.internal.ui.text.hover.PHPEditorTextHoverDescriptor;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.html.ui.StructuredTextViewerConfigurationHTML;
import org.eclipse.wst.html.ui.internal.autoedit.AutoEditStrategyForTabs;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.internal.provisional.style.ReconcilerHighlighter;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;

public class TwigStructuredTextViewerConfiguration
extends StructuredTextViewerConfigurationHTML {
    private LineStyleProvider fLineStyleProvider;
    private static final IAutoEditStrategy indentLineAutoEditStrategy = new com.dubture.twig.ui.editor.autoEdit.IndentLineAutoEditStrategy();
    private static final IAutoEditStrategy mainAutoEditStrategy = new MainAutoEditStrategy();
    private static final IAutoEditStrategy closeTagAutoEditStrategy = new CloseTagAutoEditStrategyTwig();
    private ReconcilerHighlighter fHighlighter = null;
    private OccurrencesFinderJob fOccurrencesFinderJob;
    private Annotation[] fOccurrenceAnnotations = null;
    private long fMarkOccurrenceModificationStamp = -1L;
    private IRegion fMarkOccurrenceTargetRegion;
    private boolean fMarkOccurrenceAnnotations = true;
    private ISelection fForcedMarkOccurrencesSelection;
    private ISourceViewer sourceViewer;

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        String[] original = super.getConfiguredContentTypes(sourceViewer);
        String[] configuredPartitions = TwigPartitionTypes.configuredPartitions;
        String[] result = new String[original.length + configuredPartitions.length];
        System.arraycopy(original, 0, result, 0, original.length);
        System.arraycopy(configuredPartitions, 0, result, original.length, configuredPartitions.length);
        return result;
    }

    public LineStyleProvider getLineStyleProvider() {
        if (this.fLineStyleProvider == null) {
            this.fLineStyleProvider = new LineStyleProviderForTwig();
        }
        return this.fLineStyleProvider;
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
        if (TwigPartitionTypes.isTwigPartition((String)partitionType)) {
            return new LineStyleProvider[]{this.getLineStyleProvider()};
        }
        return super.getLineStyleProviders(sourceViewer, partitionType);
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"//", "#", ""};
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        PHPEditorTextHoverDescriptor[] hoverDescs = PHPUiPlugin.getDefault().getPHPEditorTextHoverDescriptors();
        int[] stateMasks = new int[hoverDescs.length];
        int stateMasksLength = 0;
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled()) {
                int j = 0;
                int stateMask = hoverDescs[i].getStateMask();
                while (j < stateMasksLength) {
                    if (stateMasks[j] == stateMask) break;
                    ++j;
                }
                if (j == stateMasksLength) {
                    stateMasks[stateMasksLength++] = stateMask;
                }
            }
            ++i;
        }
        if (stateMasksLength == hoverDescs.length) {
            return stateMasks;
        }
        int[] shortenedStateMasks = new int[stateMasksLength];
        System.arraycopy(stateMasks, 0, shortenedStateMasks, 0, stateMasksLength);
        return shortenedStateMasks;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 255);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        if (!TwigPartitionTypes.isTwigPartition((String)contentType)) {
            return super.getTextHover(sourceViewer, contentType, stateMask);
        }
        if (sourceViewer instanceof PHPStructuredTextViewer) {
            PHPEditorTextHoverDescriptor[] hoverDescs = PHPUiPlugin.getDefault().getPHPEditorTextHoverDescriptors();
            int i = 0;
            while (i < hoverDescs.length) {
                if (hoverDescs[i].isEnabled() && hoverDescs[i].getStateMask() == stateMask) {
                    return new PHPTextHoverProxy(hoverDescs[i], (IEditorPart)((PHPStructuredTextViewer)sourceViewer).getTextEditor(), this.fPreferenceStore);
                }
                ++i;
            }
        }
        return null;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (contentType.equals("com.dubture.twig.TWIG_DEFAULT")) {
            IAutoEditStrategy[] autoEditStrategies = super.getAutoEditStrategies(sourceViewer, contentType);
            LinkedList<IAutoEditStrategy> strategies = new LinkedList<IAutoEditStrategy>();
            strategies.add(mainAutoEditStrategy);
            IAutoEditStrategy[] iAutoEditStrategyArray = autoEditStrategies;
            int n = autoEditStrategies.length;
            int n2 = 0;
            while (n2 < n) {
                IAutoEditStrategy strategy = iAutoEditStrategyArray[n2];
                if (!(strategy instanceof AutoEditStrategyForTabs) && strategy instanceof IAutoEditStrategy) {
                    strategies.add(strategy);
                }
                ++n2;
            }
            return strategies.toArray(new IAutoEditStrategy[strategies.size()]);
        }
        return this.getTwigAutoEditStrategy(sourceViewer, contentType);
    }

    private final IAutoEditStrategy[] getTwigAutoEditStrategy(ISourceViewer sourceViewer, String contentType) {
        IAutoEditStrategy[] autoEditStrategies = super.getAutoEditStrategies(sourceViewer, contentType);
        int i = 0;
        while (i < autoEditStrategies.length) {
            if (autoEditStrategies[i] instanceof IndentLineAutoEditStrategy) {
                autoEditStrategies[i] = indentLineAutoEditStrategy;
            }
            ++i;
        }
        int length = autoEditStrategies.length;
        IAutoEditStrategy[] newAutoEditStrategies = new IAutoEditStrategy[length + 1];
        System.arraycopy(autoEditStrategies, 0, newAutoEditStrategies, 0, length);
        newAutoEditStrategies[length] = closeTagAutoEditStrategy;
        return newAutoEditStrategies;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (contentType == "com.dubture.twig.TWIG_DEFAULT") {
            return new PHPDoubleClickStrategy();
        }
        return super.getDoubleClickStrategy(sourceViewer, contentType);
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        Vector<String> vector = new Vector<String>();
        char indentCharPref = FormatPreferencesSupport.getInstance().getIndentationChar(sourceViewer.getDocument());
        int indentationSize = FormatPreferencesSupport.getInstance().getIndentationSize(sourceViewer.getDocument());
        int i = 0;
        while (i <= indentationSize) {
            StringBuffer prefix = new StringBuffer();
            boolean appendTab = false;
            int j = 0;
            while (j + i < indentationSize) {
                prefix.append(indentCharPref);
                ++j;
            }
            if (i != 0) {
                appendTab = true;
            }
            if (appendTab) {
                prefix.append('\t');
                vector.add(prefix.toString());
                prefix.deleteCharAt(prefix.length() - 1);
            }
            vector.add(prefix.toString());
            ++i;
        }
        vector.add("");
        return vector.toArray(new String[vector.size()]);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
        TwigStructuredPresentationReconciler reconciler = new TwigStructuredPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        String[] contentTypes = this.getConfiguredContentTypes(sourceViewer);
        if (contentTypes != null) {
            StructuredDocumentDamagerRepairer dr = null;
            int i = 0;
            while (i < contentTypes.length) {
                LineStyleProvider provider;
                if (this.fHighlighter != null && (provider = this.fHighlighter.getProvider(contentTypes[i])) != null) {
                    dr = new StructuredDocumentDamagerRepairer(provider);
                    dr.setDocument(sourceViewer.getDocument());
                    reconciler.setDamager((IPresentationDamager)dr, contentTypes[i]);
                    reconciler.setRepairer((IPresentationRepairer)dr, contentTypes[i]);
                }
                ++i;
            }
        }
        return reconciler;
    }

    public void setHighlighter(ReconcilerHighlighter highlighter) {
        this.fHighlighter = highlighter;
        super.setHighlighter(highlighter);
    }

    public StructuredTextViewer getTextViewer() {
        return (TwigStructuredTextViewer)this.sourceViewer;
    }

    protected void updateOccurrenceAnnotations(ITextSelection selection, TwigModuleDeclaration astRoot) {
        VariableFinder finder;
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
        }
        if (!this.fMarkOccurrenceAnnotations) {
            return;
        }
        if (astRoot == null || selection == null || this.sourceViewer == null) {
            return;
        }
        IDocument document = this.sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        if (document.getLength() != astRoot.sourceEnd()) {
            return;
        }
        boolean hasChanged = false;
        if (document instanceof IDocumentExtension4) {
            int offset = selection.getOffset();
            long currentModificationStamp = ((IDocumentExtension4)document).getModificationStamp();
            IRegion markOccurrenceTargetRegion = this.fMarkOccurrenceTargetRegion;
            boolean bl = hasChanged = currentModificationStamp != this.fMarkOccurrenceModificationStamp;
            if (markOccurrenceTargetRegion != null && !hasChanged && markOccurrenceTargetRegion.getOffset() <= offset && offset <= markOccurrenceTargetRegion.getOffset() + markOccurrenceTargetRegion.getLength()) {
                return;
            }
            this.fMarkOccurrenceTargetRegion = ScriptWordFinder.findWord((IDocument)document, (int)offset);
            this.fMarkOccurrenceModificationStamp = currentModificationStamp;
        }
        IOccurrencesFinder.OccurrenceLocation[] locations = null;
        ASTNode selectedNode = NodeFinder.perform((TwigModuleDeclaration)astRoot, (int)selection.getOffset(), (int)selection.getLength());
        if (locations == null && (finder = new VariableFinder()).initialize(astRoot, selectedNode) == null) {
            locations = finder.getOccurrences();
        }
        if ((locations == null || locations.length == 0) && (finder = new CallFinder()).initialize(astRoot, selectedNode) == null) {
            locations = finder.getOccurrences();
        }
        if ((locations == null || locations.length == 0) && (finder = new StringFinder()).initialize(astRoot, selectedNode) == null) {
            locations = finder.getOccurrences();
        }
        if (locations == null) {
            return;
        }
        this.fOccurrencesFinderJob = new OccurrencesFinderJob(document, locations, (ISelection)selection);
        this.fOccurrencesFinderJob.run((IProgressMonitor)new NullProgressMonitor());
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOccurrenceAnnotations() {
        this.fMarkOccurrenceModificationStamp = -1L;
        this.fMarkOccurrenceTargetRegion = null;
        IAnnotationModel annotationModel = this.getTextViewer().getAnnotationModel();
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOccurrenceAnnotations.length;
                while (i < length) {
                    annotationModel.removeAnnotation(this.fOccurrenceAnnotations[i]);
                    ++i;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    class OccurrencesFinderJob
    extends Job {
        private final IDocument fDocument;
        private final ISelection fSelection;
        private final ISelectionValidator fPostSelectionValidator;
        private boolean fCanceled;
        private final IOccurrencesFinder.OccurrenceLocation[] fLocations;

        public OccurrencesFinderJob(IDocument document, IOccurrencesFinder.OccurrenceLocation[] locations, ISelection selection) {
            super("mark occrrences job name");
            this.fCanceled = false;
            this.fDocument = document;
            this.fSelection = selection;
            this.fLocations = locations;
            this.fPostSelectionValidator = null;
        }

        void doCancel() {
            this.fCanceled = true;
            this.cancel();
        }

        private boolean isCanceled(IProgressMonitor progressMonitor) {
            return this.fCanceled || progressMonitor.isCanceled() || this.fPostSelectionValidator != null && !this.fPostSelectionValidator.isValid(this.fSelection) && TwigStructuredTextViewerConfiguration.this.fForcedMarkOccurrencesSelection != this.fSelection || LinkedModeModel.hasInstalledModel((IDocument)this.fDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            StructuredTextViewer textViewer = TwigStructuredTextViewerConfiguration.this.getTextViewer();
            if (textViewer == null) {
                return Status.CANCEL_STATUS;
            }
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return Status.CANCEL_STATUS;
            }
            IAnnotationModel annotationModel = TwigStructuredTextViewerConfiguration.this.getTextViewer().getAnnotationModel();
            if (annotationModel == null) {
                return Status.CANCEL_STATUS;
            }
            if (this.fLocations == null) {
                return Status.CANCEL_STATUS;
            }
            int length = this.fLocations.length;
            HashMap<1, Position> annotationMap = new HashMap<1, Position>(length);
            int i = 0;
            while (i < length) {
                if (this.isCanceled(progressMonitor)) {
                    return Status.CANCEL_STATUS;
                }
                IOccurrencesFinder.OccurrenceLocation location = this.fLocations[i];
                Position position = new Position(location.getOffset(), location.getLength());
                String description = location.getDescription();
                String annotationType = location.getFlags() == 1 ? "org.eclipse.php.ui.occurrences.write" : "org.eclipse.php.ui.occurrences";
                ReconcileAnnotationKey reconcileAnnotationKey = new ReconcileAnnotationKey(null, "org.eclipse.php.PHP_DEFAULT", 0);
                TemporaryAnnotation annotation = new TemporaryAnnotation(position, annotationType, description, reconcileAnnotationKey){

                    public void paint(GC gc, Canvas canvas, Rectangle r) {
                        ImageUtilities.drawImage((Image)PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_OBJS_OCCURRENCES), (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
                    }
                };
                annotationMap.put(annotation, position);
                ++i;
            }
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            Object object = TwigStructuredTextViewerConfiguration.this.getLockObject(annotationModel);
            synchronized (object) {
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(TwigStructuredTextViewerConfiguration.this.fOccurrenceAnnotations, annotationMap);
                } else {
                    TwigStructuredTextViewerConfiguration.this.removeOccurrenceAnnotations();
                    for (Map.Entry entry : annotationMap.entrySet()) {
                        annotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
                    }
                }
                TwigStructuredTextViewerConfiguration.this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
            }
            return Status.OK_STATUS;
        }
    }
}

