/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.editor.contentassist;

import com.dubture.twig.core.codeassist.CompletionProposal;
import com.dubture.twig.core.codeassist.CompletionRequestor;
import com.dubture.twig.ui.editor.contentassist.ICompletionProposalProvider;
import com.dubture.twig.ui.extension.ExtensionManager;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class TwigCompletionProposalCollector
extends CompletionRequestor {
    private ICompletionProposalProvider[] completionPropoviders;
    private List<CompletionProposal> unprocessedProposals = new LinkedList<CompletionProposal>();

    public void beginSession() {
        super.beginSession();
        if (this.completionPropoviders == null) {
            this.completionPropoviders = this.getProviders();
        }
    }

    protected ICompletionProposalProvider[] getProviders() {
        return ExtensionManager.getInstance().getProposalExtensions();
    }

    public void acceptProposal(CompletionProposal proposal) {
        this.unprocessedProposals.add(proposal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSession() {
        super.endSession();
        List<CompletionProposal> list = this.unprocessedProposals;
        synchronized (list) {
            this.unprocessedProposals.clear();
        }
    }

    public ICompletionProposal[] getProposals() {
        LinkedList<ICompletionProposal> result = new LinkedList<ICompletionProposal>();
        for (CompletionProposal pr : this.unprocessedProposals) {
            ICompletionProposal proposal = this.getProposal(pr);
            if (proposal == null) continue;
            result.add(proposal);
        }
        this.unprocessedProposals.clear();
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    protected ICompletionProposal getProposal(CompletionProposal proposal) {
        ICompletionProposalProvider[] iCompletionProposalProviderArray = this.completionPropoviders;
        int n = this.completionPropoviders.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposalProvider provider = iCompletionProposalProviderArray[n2];
            ICompletionProposal twigProposal = provider.createCompletionProposal(proposal);
            if (twigProposal != null) {
                return twigProposal;
            }
            ++n2;
        }
        return null;
    }
}

