/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.editor.contentassist;

import com.dubture.twig.core.codeassist.CompletionRequestor;
import com.dubture.twig.core.codeassist.TwigCompletionEngine;
import com.dubture.twig.ui.editor.contentassist.TwigCompletionProposalCollector;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.contentassist.ICompletionProposalComputer;

public class TwigCompletionProposalComputer
implements ICompletionProposalComputer {
    private TwigCompletionProposalCollector collector = new TwigCompletionProposalCollector();

    public void sessionStarted() {
        this.collector.beginSession();
    }

    public List computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        IFile file;
        TwigCompletionEngine twigCompletionEngine = new TwigCompletionEngine();
        twigCompletionEngine.setMonitor(monitor);
        twigCompletionEngine.setRequestor((CompletionRequestor)this.collector);
        twigCompletionEngine.setSourceRange((ISourceRange)new SourceRange(context.getInvocationOffset(), 0));
        ITextFileBuffer fileBuffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(context.getDocument());
        if (fileBuffer != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(fileBuffer.getLocation())) != null && file.exists()) {
            twigCompletionEngine.setProject(file.getProject());
        }
        twigCompletionEngine.complete(context.getDocument());
        return Arrays.asList(this.collector.getProposals());
    }

    public List computeContextInformation(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        return Collections.EMPTY_LIST;
    }

    public String getErrorMessage() {
        return this.collector.getErrorMessage();
    }

    public void sessionEnded() {
        this.collector.endSession();
    }
}

