/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.editor.contentassist;

import com.dubture.twig.ui.TwigUICorePlugin;
import com.dubture.twig.ui.editor.templates.TwigTemplateAccess;
import java.util.ArrayList;
import org.eclipse.dltk.ui.templates.ScriptTemplateAccess;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.php.internal.ui.editor.templates.PHPTemplateCompletionProcessor;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;

public class TwigTemplateCompletionProcessor
extends PHPTemplateCompletionProcessor {
    public TwigTemplateCompletionProcessor(ScriptContentAssistInvocationContext context, boolean explicit) {
        super(context, explicit);
        this.setContextTypeId("twig");
    }

    protected ScriptTemplateAccess getTemplateAccess() {
        return TwigTemplateAccess.getInstance();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String prefix;
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (selection.getOffset() == offset) {
            offset = selection.getOffset() + selection.getLength();
        }
        if (!this.isValidPrefix(prefix = this.extractPrefix(viewer, offset))) {
            return new ICompletionProposal[0];
        }
        Region region = new Region(offset - prefix.length(), prefix.length());
        TemplateContext context = this.createContext(viewer, (IRegion)region);
        if (context == null) {
            return new ICompletionProposal[0];
        }
        ArrayList<TemplateProposal> matches = new ArrayList<TemplateProposal>();
        Template[] templates = this.getTemplates(context.getContextType().getId());
        int i = 0;
        while (i < templates.length) {
            block8: {
                Template template = templates[i];
                try {
                    context.getContextType().validate(template.getPattern());
                }
                catch (TemplateException e) {
                    break block8;
                }
                if (this.isMatchingTemplate(template, prefix, context)) {
                    matches.add((TemplateProposal)this.createProposal(template, context, (IRegion)region, this.getRelevance(template, prefix)));
                }
            }
            ++i;
        }
        IInformationControlCreator controlCreator = this.getInformationControlCreator();
        for (TemplateProposal proposal : matches) {
            proposal.setInformationControlCreator(controlCreator);
        }
        return matches.toArray(new ICompletionProposal[matches.size()]);
    }

    protected String getContextTypeId() {
        return "twig";
    }

    protected Image getImage(Template template) {
        return TwigUICorePlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_TEMPLATE);
    }

    protected ContextTypeRegistry getTemplateContextRegistry() {
        return TwigUICorePlugin.getDefault().getTemplateContextRegistry();
    }

    protected TemplateStore getTemplateStore() {
        return TwigUICorePlugin.getDefault().getTemplateStore();
    }
}

