/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.editor.contentassist.proposals;

import com.dubture.twig.core.log.Logger;
import com.dubture.twig.ui.editor.contentassist.ICompletionProposalInfo;
import com.dubture.twig.ui.editor.contentassist.ITwigCompletionProposal;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.completion.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.osgi.framework.Bundle;

public class AbstractTwigCompletionProposal
implements ITwigCompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension5,
ICompletionProposalExtension6 {
    private int replacementOffset;
    private int replacementLength;
    private int cursorPosition;
    private String replacementString;
    private int relevance;
    private StyledString displayString;
    private Image image;
    private ICompletionProposalInfo proposalInfo;
    private IContextInformation contextInformation;
    private static String fgCSSStyles;

    public int getReplacementOffset() {
        return this.replacementOffset;
    }

    public void setReplacementOffset(int replacementOffset) {
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        this.replacementOffset = replacementOffset;
    }

    public int getReplacementLength() {
        return this.replacementLength;
    }

    public void setReplacementLength(int replacementLength) {
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.replacementLength = replacementLength;
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public void setReplacementString(String replacementString) {
        Assert.isNotNull((Object)replacementString);
        this.replacementString = replacementString;
    }

    public final void apply(IDocument document) {
        this.apply(document, '\u0000', this.getReplacementOffset() + this.getReplacementLength());
    }

    public Point getSelection(IDocument document) {
        return new Point(this.getReplacementOffset() + this.getCursorPosition(), 0);
    }

    public void setCursorPosition(int cursorPosition) {
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.cursorPosition = cursorPosition;
    }

    protected int getCursorPosition() {
        return this.cursorPosition;
    }

    public String getAdditionalProposalInfo() {
        Object info = this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        return info != null ? info.toString() : null;
    }

    public String getDisplayString() {
        if (this.displayString != null) {
            return this.displayString.toString();
        }
        return null;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public IContextInformation getContextInformation() {
        return this.contextInformation;
    }

    public void setContextInformation(IContextInformation contextInformation) {
        this.contextInformation = contextInformation;
    }

    public StyledString getStyledDisplayString() {
        return this.displayString;
    }

    public void setStyledDisplayString(StyledString text) {
        this.displayString = text;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        if (this.getProposalInfo() != null) {
            String info = this.getProposalInfo().getInfo(monitor);
            if (info != null && info.length() > 0) {
                StringBuffer buffer = new StringBuffer();
                HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)this.getCSSStyles());
                buffer.append(info);
                HTMLPrinter.addPageEpilog((StringBuffer)buffer);
                info = buffer.toString();
            }
            return info;
        }
        return null;
    }

    protected String getCSSStyles() {
        String css;
        Bundle bundle;
        URL url;
        if (fgCSSStyles == null && (url = (bundle = Platform.getBundle((String)DLTKUIPlugin.getPluginId())).getEntry("/DocumentationHoverStyleSheet.css")) != null) {
            try {
                url = FileLocator.toFileURL((URL)url);
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                StringBuffer buffer = new StringBuffer(200);
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    buffer.append('\n');
                    line = reader.readLine();
                }
                fgCSSStyles = buffer.toString();
            }
            catch (IOException ex) {
                DLTKUIPlugin.log((Throwable)ex);
            }
        }
        if ((css = fgCSSStyles) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.dltk.ui.documentationFont")[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    public ICompletionProposalInfo getProposalInfo() {
        return this.proposalInfo;
    }

    public void setProposalInfo(ICompletionProposalInfo proposalInfo) {
        this.proposalInfo = proposalInfo;
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            int delta = offset - (this.getReplacementOffset() + this.getReplacementLength());
            if (delta > 0) {
                this.setReplacementLength(this.getReplacementLength() + delta);
            }
            if (trigger != '\u0000') {
                this.ensureTriggerAtCursorLocation(trigger);
            }
            String replacement = this.getReplacementString();
            this.replace(document, this.getReplacementOffset(), this.getReplacementLength(), replacement);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected final void replace(IDocument document, int offset, int length, String string) throws BadLocationException {
        if (!document.get(offset, length).equals(string)) {
            document.replace(offset, length, string);
        }
    }

    protected void ensureTriggerAtCursorLocation(char trigger) {
        String replacement = this.getReplacementString();
        if (this.getCursorPosition() > 0 && this.getCursorPosition() <= replacement.length() && replacement.charAt(this.getCursorPosition() - 1) != trigger) {
            StringBuilder buffer = new StringBuilder(replacement);
            buffer.insert(this.getCursorPosition(), trigger);
            this.setReplacementString(buffer.toString());
            this.setCursorPosition(this.getCursorPosition() + 1);
        }
    }

    public boolean isValidFor(IDocument document, int offset) {
        if (offset < this.getReplacementOffset()) {
            return false;
        }
        return this.validate(document, offset);
    }

    public boolean validate(IDocument document, int offset) {
        if (offset < this.getReplacementOffset()) {
            return false;
        }
        if (offset > this.getReplacementOffset()) {
            try {
                String prefix = document.get(this.getReplacementOffset(), offset - this.getReplacementOffset());
                if (!this.isValidPrefix(prefix, offset)) {
                    return false;
                }
            }
            catch (BadLocationException e) {
                Logger.logException((Throwable)e);
            }
        }
        return true;
    }

    public String getStringToCompute() {
        return this.getDisplayString();
    }

    public boolean isValidPrefix(String prefix, int offset) {
        return this.getStringToCompute().toLowerCase().startsWith(prefix.toLowerCase());
    }

    public char[] getTriggerCharacters() {
        return null;
    }

    public int getContextInformationPosition() {
        if (this.getContextInformation() == null) {
            return this.getReplacementOffset() - 1;
        }
        return this.getReplacementOffset() + this.getCursorPosition();
    }

    @Override
    public int getRelevance() {
        return this.relevance;
    }

    public void setRelevance(int relevance) {
        this.relevance = relevance;
    }
}

