/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.editor.folding;

import com.dubture.twig.core.documentModel.parser.regions.ITwigScriptRegion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.corext.SourceRange;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.internal.ui.editor.configuration.PHPStructuredTextViewerConfiguration;
import org.eclipse.php.internal.ui.folding.IStructuredTextFoldingProvider;
import org.eclipse.php.internal.ui.folding.StructuredTextFoldingProviderPHP;
import org.eclipse.php.internal.ui.folding.html.ProjectionModelNodeAdapterFactoryHTML;
import org.eclipse.php.internal.ui.folding.html.ProjectionModelNodeAdapterHTML;
import org.eclipse.php.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.PropagatingAdapter;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

public class StructuredTextFoldingProviderTwig
implements IProjectionListener,
IStructuredTextFoldingProvider {
    private StructuredTextFoldingProviderPHP phpFoldingProvider;
    private ProjectionListener fProjectionListener;
    private PHPStructuredTextViewer viewer;
    private PHPStructuredEditor fEditor;
    private IElementChangedListener fElementListener;
    private volatile int fUpdatingCount = 0;
    private IModelElement fInput;
    private boolean fCollapsePhpdoc = true;
    private boolean fCollapseImportContainer = true;
    private boolean fCollapseTypes = true;
    private boolean fCollapseMembers = false;
    private boolean fCollapseHeaderComments = true;
    private static final int MAX_CHILDREN = 10;
    private static final int MAX_SIBLINGS = 1000;
    private IDocument fDocument;

    public void install(ProjectionViewer viewer) {
        this.internalUninstall();
        PHPStructuredTextViewer viewer1 = (PHPStructuredTextViewer)viewer;
        ITextEditor editor = viewer1.getTextEditor();
        this.viewer = viewer1;
        if (editor instanceof PHPStructuredEditor) {
            PHPStructuredEditor phpEditor = (PHPStructuredEditor)editor;
            if (phpEditor.getSourceViwerConfiguration().getClass() == PHPStructuredTextViewerConfiguration.class) {
                this.phpFoldingProvider = new StructuredTextFoldingProviderPHP();
                this.phpFoldingProvider.install(viewer);
            } else {
                this.fProjectionListener = new ProjectionListener(viewer);
                this.fEditor = (PHPStructuredEditor)editor;
            }
        }
    }

    private void internalUninstall() {
        if (this.isInstalled()) {
            this.handleProjectionDisabled();
            this.fProjectionListener.dispose();
            this.fProjectionListener = null;
            this.fEditor = null;
        }
    }

    public void uninstall() {
        if (this.phpFoldingProvider != null) {
            this.phpFoldingProvider.uninstall();
            return;
        }
        this.internalUninstall();
    }

    public void initialize() {
        if (this.phpFoldingProvider != null) {
            this.phpFoldingProvider.initialize();
            return;
        }
        if (this.viewer != null) {
            this.fDocument = this.viewer.getDocument();
            if (this.viewer.getProjectionAnnotationModel() != null) {
                ProjectionModelNodeAdapterFactoryHTML factory2 = this.getAdapterFactoryHTML(true);
                if (factory2 != null) {
                    factory2.addProjectionViewer((ProjectionViewer)this.viewer);
                }
                this.addAllAdapters();
            }
        }
        ++this.fUpdatingCount;
        try {
            this.update(this.createInitialContext());
        }
        finally {
            --this.fUpdatingCount;
        }
    }

    private void update(FoldingStructureComputationContext ctx) {
        HashMap<TwigProjectionAnnotation, Position> additions = new HashMap<TwigProjectionAnnotation, Position>();
        ArrayList<TwigProjectionAnnotation> deletions = new ArrayList<TwigProjectionAnnotation>();
        ArrayList<TwigProjectionAnnotation> updates = new ArrayList<TwigProjectionAnnotation>();
        this.computeFoldingStructure(ctx);
        LinkedHashMap<Object, Position> newStructure = ctx.fMap;
        Map<IModelElement, Object> oldStructure = this.computeCurrentStructure(ctx);
        for (TwigProjectionAnnotation twigProjectionAnnotation : newStructure.keySet()) {
            Position newPosition = (Position)newStructure.get((Object)twigProjectionAnnotation);
            IModelElement element = twigProjectionAnnotation.getElement();
            boolean isMalformedAnonymousType = newPosition.getOffset() == 0 && element.getElementType() == 7;
            List annotations = (List)oldStructure.get(element);
            if (annotations == null) {
                if (isMalformedAnonymousType) continue;
                additions.put(twigProjectionAnnotation, newPosition);
                continue;
            }
            Iterator x = annotations.iterator();
            boolean matched = false;
            while (x.hasNext()) {
                boolean updateCollapsedState;
                Tuple tuple = (Tuple)x.next();
                TwigProjectionAnnotation existingAnnotation = tuple.annotation;
                Position existingPosition = tuple.position;
                if (twigProjectionAnnotation.isComment() != existingAnnotation.isComment()) continue;
                boolean bl = updateCollapsedState = ctx.allowCollapsing() && existingAnnotation.isCollapsed() != twigProjectionAnnotation.isCollapsed();
                if (!(isMalformedAnonymousType || existingPosition == null || newPosition.equals((Object)existingPosition) && !updateCollapsedState)) {
                    existingPosition.setOffset(newPosition.getOffset());
                    existingPosition.setLength(newPosition.getLength());
                    if (updateCollapsedState) {
                        if (twigProjectionAnnotation.isCollapsed()) {
                            existingAnnotation.markCollapsed();
                        } else {
                            existingAnnotation.markExpanded();
                        }
                    }
                    updates.add(existingAnnotation);
                }
                matched = true;
                x.remove();
                break;
            }
            if (!matched) {
                additions.put(twigProjectionAnnotation, newPosition);
            }
            if (!annotations.isEmpty()) continue;
            oldStructure.remove(element);
        }
        for (List list : oldStructure.values()) {
            int size = list.size();
            int i = 0;
            while (i < size) {
                deletions.add(((Tuple)list.get((int)i)).annotation);
                ++i;
            }
        }
        this.match(deletions, additions, updates, ctx);
        Annotation[] annotationArray = deletions.toArray(new Annotation[deletions.size()]);
        Annotation[] changedArray = updates.toArray(new Annotation[updates.size()]);
        ctx.getModel().modifyAnnotations(annotationArray, additions, changedArray);
    }

    private void computeFoldingStructure(FoldingStructureComputationContext ctx) {
        IParent parent = (IParent)this.fInput;
        try {
            if (!(this.fInput instanceof ISourceReference)) {
                return;
            }
            this.computeFoldingStructure(parent.getChildren(), ctx);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    private void computeFoldingStructure(IModelElement[] elements, FoldingStructureComputationContext ctx) throws ModelException {
        int i = 0;
        while (i < elements.length) {
            IModelElement element = elements[i];
            this.computeFoldingStructure(element, ctx);
            if (element instanceof IParent) {
                IParent parent = (IParent)element;
                this.computeFoldingStructure(parent.getChildren(), ctx);
            }
            ++i;
        }
    }

    protected void computeFoldingStructure(IModelElement element, FoldingStructureComputationContext ctx) {
        boolean collapse = false;
        boolean collapseCode = true;
        switch (element.getElementType()) {
            case 11: {
                collapse = ctx.collapseImportContainer();
                break;
            }
            case 7: {
                collapse = ctx.collapseTypes();
                break;
            }
            case 9: {
                collapse = ctx.collapseMembers();
                break;
            }
            case 8: {
                IModelElement parent = element.getParent();
                if (parent != null && parent.getElementType() != 7) {
                    return;
                }
                collapse = ctx.collapseMembers();
                break;
            }
            default: {
                return;
            }
        }
        IRegion[] regions = this.computeProjectionRanges((ISourceReference)element, ctx);
        if (regions.length > 0) {
            IRegion normalized;
            HashSet<IRegion> regionSet = new HashSet<IRegion>();
            int i = 0;
            while (i < regions.length - 1) {
                Position position;
                IRegion normalized2 = this.alignRegion(regions[i], ctx);
                if (normalized2 != null && regionSet.add(normalized2) && (position = this.createCommentPosition(normalized2)) != null) {
                    boolean commentCollapse = i == 0 && (regions.length > 2 || ctx.hasHeaderComment()) && element == ctx.getFirstElement() ? ctx.collapseHeaderComments() : ctx.collapseJavadoc();
                    ctx.addProjectionRange(new TwigProjectionAnnotation(commentCollapse, element, true), position);
                }
                ++i;
            }
            if (collapseCode && (normalized = this.alignRegion(regions[regions.length - 1], ctx)) != null) {
                Position position;
                Position position2 = position = element instanceof IMember ? this.createMemberPosition(normalized, (IMember)element) : this.createCommentPosition(normalized);
                if (position != null) {
                    ctx.addProjectionRange(new TwigProjectionAnnotation(collapse, element, false), position);
                }
            }
        }
    }

    protected final Position createCommentPosition(IRegion aligned) {
        return new CommentPosition(aligned.getOffset(), aligned.getLength());
    }

    protected final Position createMemberPosition(IRegion aligned, IMember member) {
        return new TwigElementPosition(aligned.getOffset(), aligned.getLength(), member);
    }

    protected final IRegion[] computeProjectionRanges(ISourceReference reference, FoldingStructureComputationContext ctx) {
        try {
            ISourceRange range = reference.getSourceRange();
            if (!SourceRange.isAvailable((ISourceRange)range)) {
                return new IRegion[0];
            }
            ArrayList<Object> regions = new ArrayList<Object>();
            if (!ctx.isHeaderChecked() && reference instanceof IModelElement) {
                ctx.setFirstElement((IModelElement)reference);
                ctx.setHeaderChecked();
                IRegion headerComment = this.computeHeaderComment(ctx);
                if (headerComment != null) {
                    regions.add(headerComment);
                    ctx.setHasHeaderComment();
                }
            }
            int shift = range.getOffset();
            ICommentScanner scanner = ctx.getScanner();
            scanner.resetTo(shift);
            int start = shift;
            start = scanner.computePreviousComment();
            if (start != shift) {
                start = scanner.getCurrentCommentStartPosition();
                int end = scanner.getCurrentCommentEndPosition();
                regions.add(new Region(start, end - start));
            }
            regions.add(new Region(shift, range.getLength()));
            IRegion[] result = new IRegion[regions.size()];
            regions.toArray(result);
            return result;
        }
        catch (ModelException modelException) {
            return new IRegion[0];
        }
    }

    protected final IRegion alignRegion(IRegion region, FoldingStructureComputationContext ctx) {
        int end;
        int start;
        IDocument document;
        block4: {
            if (region == null) {
                return null;
            }
            document = ctx.getDocument();
            try {
                start = document.getLineOfOffset(region.getOffset());
                end = document.getLineOfOffset(Math.min(region.getOffset() + region.getLength() - 1, document.getLength()));
                if (start < end) break block4;
                return null;
            }
            catch (BadLocationException x) {
                return null;
            }
        }
        int offset = document.getLineOffset(start);
        int endOffset = document.getNumberOfLines() > end + 1 ? document.getLineOffset(end + 1) : document.getLineOffset(end) + document.getLineLength(end);
        return new Region(offset, endOffset - offset);
    }

    private void match(List<TwigProjectionAnnotation> deletions, Map<TwigProjectionAnnotation, Position> additions, List<TwigProjectionAnnotation> changes, FoldingStructureComputationContext ctx) {
        if (deletions.isEmpty() || additions.isEmpty() && changes.isEmpty()) {
            return;
        }
        ArrayList<TwigProjectionAnnotation> newDeletions = new ArrayList<TwigProjectionAnnotation>();
        ArrayList<TwigProjectionAnnotation> newChanges = new ArrayList<TwigProjectionAnnotation>();
        Iterator<TwigProjectionAnnotation> deletionIterator = deletions.iterator();
        while (deletionIterator.hasNext()) {
            TwigProjectionAnnotation deleted = deletionIterator.next();
            Position deletedPosition = ctx.getModel().getPosition((Annotation)deleted);
            if (deletedPosition == null) continue;
            Tuple deletedTuple = new Tuple(deleted, deletedPosition);
            Tuple match = this.findMatch(deletedTuple, changes, null, ctx);
            boolean addToDeletions = true;
            if (match == null) {
                match = this.findMatch(deletedTuple, additions.keySet(), additions, ctx);
                addToDeletions = false;
            }
            if (match == null) continue;
            IModelElement element = match.annotation.getElement();
            deleted.setElement(element);
            deletedPosition.setLength(match.position.getLength());
            if (deletedPosition instanceof TwigElementPosition && element instanceof IMember) {
                TwigElementPosition jep = (TwigElementPosition)deletedPosition;
                jep.setMember((IMember)element);
            }
            deletionIterator.remove();
            newChanges.add(deleted);
            if (!addToDeletions) continue;
            newDeletions.add(match.annotation);
        }
        deletions.addAll(newDeletions);
        changes.addAll(newChanges);
    }

    private Tuple findMatch(Tuple tuple, Collection<TwigProjectionAnnotation> annotations, Map<TwigProjectionAnnotation, Position> positionMap, FoldingStructureComputationContext ctx) {
        Iterator<TwigProjectionAnnotation> it = annotations.iterator();
        while (it.hasNext()) {
            Position position;
            TwigProjectionAnnotation annotation = it.next();
            if (tuple.annotation.isComment() != annotation.isComment()) continue;
            Position position2 = position = positionMap == null ? ctx.getModel().getPosition((Annotation)annotation) : positionMap.get((Object)annotation);
            if (position == null || tuple.position.getOffset() != position.getOffset()) continue;
            it.remove();
            return new Tuple(annotation, position);
        }
        return null;
    }

    private Map<IModelElement, Object> computeCurrentStructure(FoldingStructureComputationContext ctx) {
        HashMap<IModelElement, Object> map = new HashMap<IModelElement, Object>();
        ProjectionAnnotationModel model = ctx.getModel();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Object annotation = e.next();
            if (!(annotation instanceof TwigProjectionAnnotation)) continue;
            TwigProjectionAnnotation java = (TwigProjectionAnnotation)((Object)annotation);
            Position position = model.getPosition((Annotation)java);
            Assert.isNotNull((Object)position);
            ArrayList<Tuple> list = (ArrayList<Tuple>)map.get(java.getElement());
            if (list == null) {
                list = new ArrayList<Tuple>(2);
                map.put(java.getElement(), list);
            }
            list.add(new Tuple(java, position));
        }
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Tuple)o1).position.getOffset() - ((Tuple)o2).position.getOffset();
            }
        };
        for (List list : map.values()) {
            Collections.sort(list, comparator);
        }
        return map;
    }

    private IRegion computeHeaderComment(FoldingStructureComputationContext ctx) throws ModelException {
        ITextRegion phpToken;
        ITwigScriptRegion textRegion;
        IStructuredDocumentRegion sdRegion;
        block9: {
            if (!(ctx.getDocument() instanceof IStructuredDocument)) {
                return null;
            }
            IStructuredDocument document = (IStructuredDocument)ctx.getDocument();
            sdRegion = document.getFirstStructuredDocumentRegion();
            int i = 0;
            while (sdRegion != null && sdRegion.getType() != "TWIG_CONTENT" && i++ < 40) {
                sdRegion = sdRegion.getNext();
            }
            if (sdRegion == null || sdRegion.getType() != "TWIG_CONTENT" || sdRegion.getRegions().size() < 2) {
                return null;
            }
            textRegion = (ITwigScriptRegion)sdRegion.getRegions().get(1);
            phpToken = textRegion.getTwigToken(0);
            i = 0;
            while (phpToken != null && phpToken.getType() != "TWIG_COMMENT_TEXT" && i++ < 3) {
                phpToken = textRegion.getTwigToken(phpToken.getEnd() + 1);
            }
            if (phpToken != null && phpToken.getType() == "TWIG_COMMENT_TEXT") break block9;
            return null;
        }
        try {
            int start = phpToken.getStart();
            Object lastToken = null;
            while (lastToken != phpToken && phpToken != null && phpToken.getType() != "TWIG_COMMENT_TEXT") {
                phpToken = textRegion.getTwigToken(phpToken.getEnd() + 1);
            }
            if (phpToken != null && phpToken.getType() == "TWIG_COMMENT_TEXT") {
                int end = phpToken.getEnd();
                return new Region(sdRegion.getStartOffset() + textRegion.getStart() + start, end - start);
            }
            return null;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private ProjectionAnnotationModel getModel() {
        return this.viewer.getProjectionAnnotationModel();
    }

    protected final boolean isInstalled() {
        return this.fEditor != null;
    }

    private FoldingStructureComputationContext createInitialContext() {
        this.initializePreferences();
        this.fInput = this.getInputElement();
        if (this.fInput == null) {
            return null;
        }
        return this.createContext(true);
    }

    private FoldingStructureComputationContext createContext(boolean allowCollapse) {
        if (!this.isInstalled()) {
            return null;
        }
        ProjectionAnnotationModel model = this.getModel();
        if (model == null) {
            return null;
        }
        IDocument doc = this.getDocument();
        if (doc == null) {
            return null;
        }
        return new FoldingStructureComputationContext(doc, model, allowCollapse);
    }

    private IDocument getDocument() {
        PHPStructuredEditor editor = this.fEditor;
        if (editor == null) {
            return null;
        }
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider == null) {
            return null;
        }
        return provider.getDocument((Object)editor.getEditorInput());
    }

    private void initializePreferences() {
        IPreferenceStore store = PHPUiPlugin.getDefault().getPreferenceStore();
        this.fCollapseTypes = store.getBoolean("foldClasses");
        this.fCollapsePhpdoc = store.getBoolean("foldPHPDoc");
        this.fCollapseMembers = store.getBoolean("foldFunctions");
        this.fCollapseHeaderComments = store.getBoolean("foldHeaderComment");
    }

    private IModelElement getInputElement() {
        if (this.fEditor == null) {
            return null;
        }
        return EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, (boolean)false);
    }

    public int getUpdatingCount() {
        return this.fUpdatingCount;
    }

    public void projectionEnabled() {
        if (this.phpFoldingProvider != null) {
            this.phpFoldingProvider.projectionEnabled();
            return;
        }
        this.handleProjectionEnabled();
    }

    public void projectionDisabled() {
        if (this.phpFoldingProvider != null) {
            this.phpFoldingProvider.projectionDisabled();
            return;
        }
        this.handleProjectionDisabled();
    }

    protected void handleProjectionEnabled() {
        this.handleProjectionDisabled();
        if (this.isInstalled()) {
            this.initialize();
            this.fElementListener = new ElementChangedListener();
            DLTKCore.addElementChangedListener((IElementChangedListener)this.fElementListener);
        }
    }

    protected void handleProjectionDisabled() {
        ProjectionModelNodeAdapterFactoryHTML factory2;
        if (this.fElementListener != null) {
            DLTKCore.removeElementChangedListener((IElementChangedListener)this.fElementListener);
            this.fElementListener = null;
        }
        if ((factory2 = this.getAdapterFactoryHTML(false)) != null) {
            factory2.removeProjectionViewer((ProjectionViewer)this.viewer);
        }
        if (this.viewer.getProjectionAnnotationModel() != null) {
            this.viewer.getProjectionAnnotationModel().removeAllAnnotations();
        }
        this.removeAllAdapters();
        this.fDocument = null;
    }

    private ProjectionModelNodeAdapterFactoryHTML getAdapterFactoryHTML(boolean createIfNeeded) {
        ProjectionModelNodeAdapterFactoryHTML factory = null;
        if (this.fDocument != null) {
            IStructuredModel sModel = null;
            try {
                sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                if (sModel != null && sModel instanceof IDOMModel) {
                    FactoryRegistry factoryRegistry = sModel.getFactoryRegistry();
                    if (!factoryRegistry.contains(ProjectionModelNodeAdapterHTML.class) && createIfNeeded) {
                        ProjectionModelNodeAdapterFactoryHTML newFactory = new ProjectionModelNodeAdapterFactoryHTML();
                        factoryRegistry.addFactory((INodeAdapterFactory)newFactory);
                        IDOMModel domModel = (IDOMModel)sModel;
                        IDOMDocument document = domModel.getDocument();
                        PropagatingAdapter propagatingAdapter = (PropagatingAdapter)document.getAdapterFor(PropagatingAdapter.class);
                        if (propagatingAdapter != null) {
                            propagatingAdapter.addAdaptOnCreateFactory((INodeAdapterFactory)newFactory);
                        }
                    }
                    factory = (ProjectionModelNodeAdapterFactoryHTML)factoryRegistry.getFactoryFor(ProjectionModelNodeAdapterHTML.class);
                }
            }
            finally {
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
            }
        }
        return factory;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addAllAdapters() {
        if (this.fDocument == null) return;
        IStructuredModel sModel = null;
        try {
            block9: {
                Node nextSibling;
                int siblingLevel;
                block8: {
                    sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                    if (sModel == null) return;
                    IndexedRegion startNode = sModel.getIndexedRegion(0);
                    if (startNode == null) {
                        assert (sModel instanceof IDOMModel);
                        startNode = ((IDOMModel)sModel).getDocument();
                    }
                    if (!(startNode instanceof Node)) return;
                    siblingLevel = 0;
                    nextSibling = (Node)startNode;
                    if (!true) break block8;
                    if (nextSibling == null) return;
                    if (siblingLevel >= 1000) break block9;
                }
                do {
                    Node currentNode = nextSibling;
                    nextSibling = currentNode.getNextSibling();
                    this.addAdapterToNodeAndChildrenHTML(currentNode, 0);
                    ++siblingLevel;
                    if (nextSibling == null) return;
                } while (siblingLevel < 1000);
            }
            return;
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
    }

    private void addAdapterToNodeAndChildrenHTML(Node node, int childLevel) {
        if (node instanceof INodeNotifier && childLevel < 10) {
            INodeNotifier notifier = (INodeNotifier)node;
            ProjectionModelNodeAdapterHTML adapter2 = (ProjectionModelNodeAdapterHTML)notifier.getExistingAdapter(ProjectionModelNodeAdapterHTML.class);
            if (adapter2 != null) {
                adapter2.updateAdapter(node);
            } else {
                notifier.getAdapterFor(ProjectionModelNodeAdapterHTML.class);
            }
            int siblingLevel = 0;
            Node nextChild = node.getFirstChild();
            while (nextChild != null && siblingLevel < 1000) {
                Node childNode = nextChild;
                nextChild = childNode.getNextSibling();
                this.addAdapterToNodeAndChildrenHTML(childNode, childLevel + 1);
                ++siblingLevel;
            }
        }
    }

    private void removeAllAdapters() {
        if (this.fDocument != null) {
            IStructuredModel sModel = null;
            try {
                sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                if (sModel != null) {
                    boolean startOffset = false;
                    IndexedRegion startNode = sModel.getIndexedRegion(0);
                    if (startNode instanceof Node) {
                        Node nextSibling = (Node)startNode;
                        while (nextSibling != null) {
                            Node currentNode = nextSibling;
                            nextSibling = currentNode.getNextSibling();
                            this.removeAdapterFromNodeAndChildren(currentNode, 0);
                        }
                    }
                }
            }
            finally {
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
            }
        }
    }

    private void removeAdapterFromNodeAndChildren(Node node, int level) {
        if (node instanceof INodeNotifier) {
            INodeNotifier notifier = (INodeNotifier)node;
            INodeAdapter adapter2 = notifier.getExistingAdapter(ProjectionModelNodeAdapterHTML.class);
            if (adapter2 != null) {
                notifier.removeAdapter(adapter2);
            }
            Node nextChild = node.getFirstChild();
            while (nextChild != null) {
                Node childNode = nextChild;
                nextChild = childNode.getNextSibling();
                this.removeAdapterFromNodeAndChildren(childNode, level + 1);
            }
        }
    }

    private static final class CommentPosition
    extends Position
    implements IProjectionPosition {
        CommentPosition(int offset, int length) {
            super(offset, length);
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
            int prefixEnd = 0;
            int contentStart = this.findFirstContent((CharSequence)sequence, prefixEnd);
            int firstLine = document.getLineOfOffset(this.offset + prefixEnd);
            int captionLine = document.getLineOfOffset(this.offset + contentStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            Assert.isTrue((firstLine <= captionLine ? 1 : 0) != 0, (String)"first folded line is greater than the caption line");
            Assert.isTrue((captionLine <= lastLine ? 1 : 0) != 0, (String)"caption line is greater than the last folded line");
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        private int findFirstContent(CharSequence content, int prefixEnd) {
            int lenght = content.length();
            int i = prefixEnd;
            while (i < lenght) {
                if (Character.isUnicodeIdentifierPart(content.charAt(i))) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        public int computeCaptionOffset(IDocument document) {
            DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
            return this.findFirstContent((CharSequence)sequence, 0);
        }
    }

    public class CommentScanner
    implements ICommentScanner {
        private final IDocument document;
        private int startElement;
        private int start;
        private int end;

        public CommentScanner(IDocument document) {
            if (document == null) {
                throw new IllegalArgumentException();
            }
            this.document = document;
        }

        @Override
        public void resetTo(int start) {
            this.startElement = start;
        }

        @Override
        public int getCurrentCommentStartPosition() {
            return this.start;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int computePreviousComment() {
            this.start = this.startElement - 1;
            try {
                while (true) {
                    if (this.start <= 0 || !Character.isWhitespace(this.document.getChar(this.start))) {
                        if (this.start <= 0 || this.document.getChar(this.start--) == '{') break;
                        return this.startElement;
                    }
                    --this.start;
                }
                int end = this.start;
                if (this.start > 0 && this.document.getChar(this.start--) != '#') {
                    return this.startElement;
                }
                while (true) {
                    if (this.start <= 0 || this.document.getChar(this.start) == '#' && this.document.getChar(this.start - 1) == '}') {
                        if (this.start != 0) break;
                        return this.startElement;
                    }
                    --this.start;
                }
                this.end = end;
                return this.start;
            }
            catch (BadLocationException e) {
                return this.startElement;
            }
        }

        @Override
        public int getCurrentCommentEndPosition() {
            return this.end;
        }
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        private ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent e) {
            IModelElementDelta delta = this.findElement(StructuredTextFoldingProviderTwig.this.fInput, e.getDelta());
            if (delta != null && (delta.getFlags() & 9) != 0) {
                if (this.shouldIgnoreDelta(e.getDelta().getElement(), delta)) {
                    return;
                }
                ++StructuredTextFoldingProviderTwig.this.fUpdatingCount;
                try {
                    StructuredTextFoldingProviderTwig.this.update(StructuredTextFoldingProviderTwig.this.createContext(false));
                }
                finally {
                    --StructuredTextFoldingProviderTwig.this.fUpdatingCount;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean shouldIgnoreDelta(IModelElement ast, IModelElementDelta delta) {
            if (ast == null) {
                return false;
            }
            if (!(ast.getResource() instanceof IFile)) {
                return false;
            }
            IFile resource = (IFile)ast.getResource();
            IDocument document = StructuredTextFoldingProviderTwig.this.getDocument();
            if (document == null) {
                return false;
            }
            PHPStructuredEditor editor = StructuredTextFoldingProviderTwig.this.fEditor;
            if (editor == null) return false;
            if (editor.getCachedSelectedRange() == null) {
                return false;
            }
            int caretLine = 0;
            try {
                caretLine = document.getLineOfOffset(editor.getCachedSelectedRange().x) + 1;
            }
            catch (BadLocationException x) {
                return false;
            }
            if (caretLine <= 0) return false;
            try {
                IMarker[] problems = resource.findMarkers("org.eclipse.dltk.core.problem", false, 2);
                int i = 0;
                while (true) {
                    if (i >= problems.length) {
                        return false;
                    }
                    IMarker marker = problems[i];
                    boolean isInCaret = this.isCaretLine(caretLine, "lineNumber", marker);
                    boolean isSyntaxError = this.isCaretLine(2, "severity", marker);
                    if (isSyntaxError && isInCaret) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                return false;
            }
        }

        private final boolean isCaretLine(int expected, String attribute, IMarker marker) throws CoreException {
            Object res = marker.getAttribute(attribute);
            return res != null && res instanceof Integer && (Integer)res == expected;
        }

        private IModelElementDelta findElement(IModelElement target, IModelElementDelta delta) {
            if (delta == null || target == null) {
                return null;
            }
            IModelElement element = delta.getElement();
            if (element.getElementType() > 6) {
                return null;
            }
            if (target.equals(element)) {
                return delta;
            }
            IModelElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                IModelElementDelta d = this.findElement(target, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }
    }

    protected final class FoldingStructureComputationContext {
        private final ProjectionAnnotationModel fModel;
        private final IDocument fDocument;
        private final boolean fAllowCollapsing;
        private IModelElement fFirstElement;
        private ICommentScanner fScanner;
        private boolean fHasHeaderComment;
        private LinkedHashMap<Object, Position> fMap = new LinkedHashMap();
        private boolean headerChecked = false;

        private FoldingStructureComputationContext(IDocument document, ProjectionAnnotationModel model, boolean allowCollapsing) {
            Assert.isNotNull((Object)document);
            Assert.isNotNull((Object)model);
            this.fDocument = document;
            this.fModel = model;
            this.fAllowCollapsing = allowCollapsing;
        }

        private void setFirstElement(IModelElement element) {
            if (this.hasFirstElement()) {
                throw new IllegalStateException();
            }
            this.fFirstElement = element;
        }

        boolean hasFirstElement() {
            return this.fFirstElement != null;
        }

        private IModelElement getFirstElement() {
            return this.fFirstElement;
        }

        private boolean hasHeaderComment() {
            return this.fHasHeaderComment;
        }

        private ICommentScanner getScanner() {
            if (this.fScanner == null) {
                this.fScanner = new CommentScanner(this.fDocument);
            }
            return this.fScanner;
        }

        private void setHasHeaderComment() {
            this.fHasHeaderComment = true;
        }

        public boolean allowCollapsing() {
            return this.fAllowCollapsing;
        }

        private IDocument getDocument() {
            return this.fDocument;
        }

        private ProjectionAnnotationModel getModel() {
            return this.fModel;
        }

        public void addProjectionRange(TwigProjectionAnnotation annotation, Position position) {
            this.fMap.put((Object)annotation, position);
        }

        public boolean collapseHeaderComments() {
            return this.fAllowCollapsing && StructuredTextFoldingProviderTwig.this.fCollapseHeaderComments;
        }

        public boolean collapseImportContainer() {
            return this.fAllowCollapsing && StructuredTextFoldingProviderTwig.this.fCollapseImportContainer;
        }

        public boolean collapseTypes() {
            return this.fAllowCollapsing && StructuredTextFoldingProviderTwig.this.fCollapseTypes;
        }

        public boolean collapseJavadoc() {
            return this.fAllowCollapsing && StructuredTextFoldingProviderTwig.this.fCollapsePhpdoc;
        }

        public boolean collapseMembers() {
            return this.fAllowCollapsing && StructuredTextFoldingProviderTwig.this.fCollapseMembers;
        }

        public boolean isHeaderChecked() {
            return this.headerChecked;
        }

        public void setHeaderChecked() {
            this.headerChecked = true;
        }
    }

    private static interface ICommentScanner {
        public void resetTo(int var1);

        public int computePreviousComment();

        public int getCurrentCommentStartPosition();

        public int getCurrentCommentEndPosition();
    }

    private final class ProjectionListener
    implements IProjectionListener {
        private ProjectionViewer fViewer;

        public ProjectionListener(ProjectionViewer viewer) {
            Assert.isLegal((viewer != null ? 1 : 0) != 0);
            this.fViewer = viewer;
            this.fViewer.addProjectionListener((IProjectionListener)this);
        }

        public void dispose() {
            if (this.fViewer != null) {
                this.fViewer.removeProjectionListener((IProjectionListener)this);
                this.fViewer = null;
            }
        }

        public void projectionEnabled() {
            StructuredTextFoldingProviderTwig.this.handleProjectionEnabled();
        }

        public void projectionDisabled() {
            StructuredTextFoldingProviderTwig.this.handleProjectionDisabled();
        }
    }

    private static final class Tuple {
        TwigProjectionAnnotation annotation;
        Position position;

        Tuple(TwigProjectionAnnotation annotation, Position position) {
            this.annotation = annotation;
            this.position = position;
        }
    }

    private static final class TwigElementPosition
    extends Position
    implements IProjectionPosition {
        private IMember fMember;

        public TwigElementPosition(int offset, int length, IMember member) {
            super(offset, length);
            Assert.isNotNull((Object)member);
            this.fMember = member;
        }

        public void setMember(IMember member) {
            Assert.isNotNull((Object)member);
            this.fMember = member;
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            int nameStart = this.offset;
            try {
                ISourceRange nameRange = this.fMember.getNameRange();
                if (nameRange != null) {
                    nameStart = nameRange.getOffset();
                }
            }
            catch (ModelException nameRange) {
                // empty catch block
            }
            int firstLine = document.getLineOfOffset(this.offset);
            int captionLine = document.getLineOfOffset(nameStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            if (captionLine < firstLine) {
                captionLine = firstLine;
            }
            if (captionLine > lastLine) {
                captionLine = lastLine;
            }
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        public int computeCaptionOffset(IDocument document) throws BadLocationException {
            int nameStart = this.offset;
            try {
                ISourceRange nameRange = this.fMember.getNameRange();
                if (nameRange != null) {
                    nameStart = nameRange.getOffset();
                }
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            return nameStart - this.offset;
        }
    }

    protected static final class TwigProjectionAnnotation
    extends ProjectionAnnotation {
        private IModelElement fJavaElement;
        private boolean fIsComment;

        public TwigProjectionAnnotation(boolean isCollapsed, IModelElement element, boolean isComment) {
            super(isCollapsed);
            this.fJavaElement = element;
            this.fIsComment = isComment;
        }

        IModelElement getElement() {
            return this.fJavaElement;
        }

        void setElement(IModelElement element) {
            this.fJavaElement = element;
        }

        boolean isComment() {
            return this.fIsComment;
        }

        void setIsComment(boolean isComment) {
            this.fIsComment = isComment;
        }

        public String toString() {
            return "TwigProjectionAnnotation:\n\telement: \t" + this.fJavaElement.toString() + "\n" + "\tcollapsed: \t" + this.isCollapsed() + "\n" + "\tcomment: \t" + this.isComment() + "\n";
        }
    }
}

