/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.editor.highlighter;

import com.dubture.twig.core.log.Logger;
import com.dubture.twig.core.parser.SourceParserUtil;
import com.dubture.twig.ui.editor.SemanticHighlightingStyle;
import com.dubture.twig.ui.editor.highlighter.AbstractSemanticApply;
import com.dubture.twig.ui.preferences.PreferenceConstants;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.internal.core.BufferManager;
import org.eclipse.dltk.internal.ui.editor.DocumentAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Position;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.ISemanticHighlighting;
import org.eclipse.wst.sse.ui.ISemanticHighlightingExtension2;

public abstract class AbstractSemanticHighlighting
implements ISemanticHighlighting,
ISemanticHighlightingExtension2,
Comparable<AbstractSemanticHighlighting> {
    private ISourceModule sourceModule = null;
    private SemanticHighlightingStyle style = new SemanticHighlightingStyle(this.getPreferenceKey());
    private List<Position> list;
    private final String preferenceKey = this.getClass().getName();

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public SemanticHighlightingStyle getStyle() {
        return this.style;
    }

    public ISourceModule getSourceModule() {
        if (this.sourceModule == null) {
            throw new IllegalStateException("Source module cannot be null");
        }
        return this.sourceModule;
    }

    protected AbstractSemanticHighlighting highlight(ISourceRange range) {
        if (range == null) {
            throw new IllegalArgumentException("Range cannot be null");
        }
        return this.highlight(range.getOffset(), range.getLength());
    }

    protected AbstractSemanticHighlighting highlight(ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Node cannot be null");
        }
        return this.highlight(node.sourceStart(), node.sourceEnd() - node.sourceStart());
    }

    protected AbstractSemanticHighlighting highlight(int start, int length) {
        if (this.list == null) {
            throw new IllegalStateException();
        }
        this.list.add(new Position(start, length));
        return this;
    }

    public Position[] consumes(ModuleDeclaration program) {
        if (program != null) {
            this.list = new ArrayList<Position>();
            try {
                AbstractSemanticApply apply = this.getSemanticApply();
                program.traverse((ASTVisitor)apply);
            }
            catch (Exception e) {
                Logger.logException((Throwable)e);
            }
            return this.list.toArray(new Position[this.list.size()]);
        }
        return new Position[0];
    }

    public Position[] consumes(IStructuredDocumentRegion region) {
        if (region.getStart() == 0) {
            ModuleDeclaration program = this.getProgram(region);
            return this.consumes(program);
        }
        return new Position[0];
    }

    protected ModuleDeclaration getProgram(IStructuredDocumentRegion region) {
        this.sourceModule = null;
        Enumeration openBuffers = BufferManager.getDefaultBufferManager().getOpenBuffers();
        while (openBuffers.hasMoreElements()) {
            DocumentAdapter adapt;
            Object nextElement = openBuffers.nextElement();
            if (!(nextElement instanceof DocumentAdapter) || !(adapt = (DocumentAdapter)nextElement).getDocument().equals(region.getParentDocument()) || !(adapt.getOwner() instanceof ISourceModule)) continue;
            this.sourceModule = (ISourceModule)adapt.getOwner();
            break;
        }
        ModuleDeclaration module = null;
        try {
            if (this.sourceModule != null) {
                module = SourceParserUtil.parseSourceModule((String)this.sourceModule.getSource());
            }
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
        return module;
    }

    public String getBoldPreferenceKey() {
        return "semanticHighlighting." + this.preferenceKey + ".bold";
    }

    public String getColorPreferenceKey() {
        return "semanticHighlighting." + this.preferenceKey + ".color";
    }

    public String getBackgroundColorPreferenceKey() {
        return "semanticHighlighting." + this.preferenceKey + ".bgcolor";
    }

    public String getEnabledPreferenceKey() {
        return "semanticHighlighting." + this.preferenceKey + ".enabled";
    }

    public String getItalicPreferenceKey() {
        return "semanticHighlighting." + this.preferenceKey + ".italic";
    }

    public IPreferenceStore getPreferenceStore() {
        return PreferenceConstants.getPreferenceStore();
    }

    public String getStrikethroughPreferenceKey() {
        return "semanticHighlighting." + this.preferenceKey + ".strikethrough";
    }

    public String getUnderlinePreferenceKey() {
        return "semanticHighlighting." + this.preferenceKey + ".underline";
    }

    public abstract AbstractSemanticApply getSemanticApply();

    public abstract void initDefaultPreferences();

    @Override
    public int compareTo(AbstractSemanticHighlighting highlighter) {
        return this.getPriority() - highlighter.getPriority();
    }

    public int getPriority() {
        return 100;
    }

    public abstract String getDisplayName();
}

