/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.extension;

import com.dubture.twig.core.log.Logger;
import com.dubture.twig.ui.editor.contentassist.DefaultCompletionProposalProvider;
import com.dubture.twig.ui.editor.contentassist.ICompletionProposalProvider;
import com.dubture.twig.ui.wizards.ITemplateProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ExtensionManager {
    public static final String PROPOSAL_PROVIDER_ID = "com.dubture.twig.ui.completionProposalProvider";
    public static final String TEMPLATE_PROVIDER_ID = "com.dubture.twig.ui.templateProvider";
    private Map<String, Object[]> extensions = new HashMap<String, Object[]>();
    private static ExtensionManager instance = null;

    private ExtensionManager() {
        this.initProposals();
    }

    private void initProposals() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(PROPOSAL_PROVIDER_ID);
        ArrayList<ICompletionProposalProvider> proposals = new ArrayList<ICompletionProposalProvider>();
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object object = e.createExecutableExtension("class");
                if (object instanceof ICompletionProposalProvider) {
                    ICompletionProposalProvider provider = (ICompletionProposalProvider)object;
                    proposals.add(provider);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
        proposals.add(new DefaultCompletionProposalProvider());
        this.extensions.put(PROPOSAL_PROVIDER_ID, proposals.toArray(new ICompletionProposalProvider[proposals.size()]));
    }

    public static ExtensionManager getInstance() {
        if (instance == null) {
            instance = new ExtensionManager();
        }
        return instance;
    }

    public ICompletionProposalProvider[] getProposalExtensions() {
        return (ICompletionProposalProvider[])this.extensions.get(PROPOSAL_PROVIDER_ID);
    }

    public ITemplateProvider[] getTemplateProviders() {
        if (!this.extensions.containsKey(TEMPLATE_PROVIDER_ID)) {
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(TEMPLATE_PROVIDER_ID);
            ArrayList<ITemplateProvider> providers = new ArrayList<ITemplateProvider>();
            try {
                IConfigurationElement[] iConfigurationElementArray = config;
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    Object object = e.createExecutableExtension("class");
                    if (object instanceof ITemplateProvider) {
                        ITemplateProvider provider = (ITemplateProvider)object;
                        providers.add(provider);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                Logger.logException((Throwable)e);
            }
            this.extensions.put(TEMPLATE_PROVIDER_ID, providers.toArray(new ITemplateProvider[providers.size()]));
        }
        return (ITemplateProvider[])this.extensions.get(TEMPLATE_PROVIDER_ID);
    }
}

