/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.popup.actions;

import com.dubture.twig.core.log.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class AddRemoveTwigNatureAction
implements IObjectActionDelegate {
    private ISelection selection;
    private Object[] fTarget;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)this.selection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                this.toggleNature(project);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fTarget = ((IStructuredSelection)selection).toArray();
            boolean enabled = true;
            Object[] objectArray = this.fTarget;
            int n = this.fTarget.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (!(obj instanceof IProject) && !(obj instanceof IScriptProject)) {
                    enabled = false;
                    break;
                }
                IProject project = null;
                project = obj instanceof IProject ? (IProject)obj : ((IScriptProject)obj).getProject();
                try {
                    if (!project.isAccessible() || project.hasNature("com.dubture.twig.core.TwigNature")) {
                        enabled = false;
                        break;
                    }
                }
                catch (CoreException e) {
                    enabled = false;
                    Logger.logException((Throwable)e);
                }
                ++n2;
            }
            action.setEnabled(enabled);
        } else {
            this.fTarget = null;
            action.setEnabled(false);
        }
        this.selection = selection;
    }

    private void toggleNature(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if ("com.dubture.twig.core.TwigNature".equals(natures[i])) {
                    String[] newNatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newNatures, 0, i);
                    System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                    description.setNatureIds(newNatures);
                    project.setDescription(description, null);
                    return;
                }
                ++i;
            }
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = "com.dubture.twig.core.TwigNature";
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
    }
}

