/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.preferences;

import com.dubture.twig.ui.TwigUICorePlugin;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.internal.ui.preferences.AbstractPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class TwigCodeassistPreferencePage
extends AbstractPreferencePage {
    private Button autoclosePrintTags;
    private Button autocloseStatementTags;
    private Button autocreateStatementTags;
    private Button markOccurrences;

    public TwigCodeassistPreferencePage() {
        this.setPreferenceStore(TwigUICorePlugin.getDefault().getPreferenceStore());
        this.setDescription("Twig codeassist preferences");
    }

    protected void initializeValues() {
        super.initializeValues();
        IPreferenceStore store = TwigUICorePlugin.getDefault().getPreferenceStore();
        this.autoclosePrintTags.setSelection(store.getBoolean("autoclose_print_tags"));
        this.autocloseStatementTags.setSelection(store.getBoolean("autoclose_statement_tags"));
        this.autocreateStatementTags.setSelection(store.getBoolean("autocreate_statement_tags"));
        this.markOccurrences.setSelection(store.getBoolean("mark_occurrences"));
    }

    protected Control createContents(Composite parent) {
        this.createMainBlock(parent);
        this.initializeValues();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.appearance_preferences");
        return null;
    }

    protected void performDefaults() {
        IPreferenceStore store = DLTKUIPlugin.getDefault().getPreferenceStore();
        store.setValue("autoclose_print_tags", true);
        store.setValue("autoclose_statement_tags", true);
        store.setValue("autocreate_statement_tags", true);
        store.setValue("mark_occurrences", true);
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = TwigUICorePlugin.getDefault().getPreferenceStore();
        store.setValue("autoclose_print_tags", this.autoclosePrintTags.getSelection());
        store.setValue("autoclose_statement_tags", this.autocloseStatementTags.getSelection());
        store.setValue("autocreate_statement_tags", this.autocreateStatementTags.getSelection());
        store.setValue("mark_occurrences", this.markOccurrences.getSelection());
        return super.performOk();
    }

    private void createMainBlock(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        result.setLayout((Layout)layout);
        Group doubleClickGroup = new Group(result, 0);
        doubleClickGroup.setLayout((Layout)new GridLayout());
        doubleClickGroup.setLayoutData((Object)new GridData(768));
        doubleClickGroup.setText("Auto-close twig tags");
        GridData gd = new GridData(256);
        this.autoclosePrintTags = new Button((Composite)doubleClickGroup, 32);
        this.autoclosePrintTags.setText("Print tags {{ }}");
        this.autoclosePrintTags.setLayoutData((Object)gd);
        this.autocloseStatementTags = new Button((Composite)doubleClickGroup, 32);
        this.autocloseStatementTags.setText("Statement tags {% %}");
        this.autocloseStatementTags.setLayoutData((Object)gd);
        this.autocreateStatementTags = new Button((Composite)doubleClickGroup, 32);
        this.autocreateStatementTags.setText("Autocreate Statements (%)");
        this.autocreateStatementTags.setLayoutData((Object)gd);
        Group higlightGroup = new Group(result, 0);
        higlightGroup.setLayout((Layout)new GridLayout());
        higlightGroup.setLayoutData((Object)new GridData(768));
        higlightGroup.setText("Highlighting");
        this.markOccurrences = new Button((Composite)higlightGroup, 32);
        this.markOccurrences.setText("Mark occurrences");
        this.markOccurrences.setLayoutData((Object)gd);
    }
}

