/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.preferences;

import com.dubture.twig.core.documentModel.parser.regions.ITwigScriptRegion;
import com.dubture.twig.core.documentModel.provisional.contenttype.ContentTypeIdForTwig;
import com.dubture.twig.core.log.Logger;
import com.dubture.twig.core.parser.SourceParserUtil;
import com.dubture.twig.ui.TwigUICorePlugin;
import com.dubture.twig.ui.TwigUIMessages;
import com.dubture.twig.ui.editor.LineStyleProviderForTwig;
import com.dubture.twig.ui.editor.SemanticHighlightingManager;
import com.dubture.twig.ui.editor.highlighter.AbstractSemanticHighlighting;
import com.dubture.twig.ui.preferences.PreferenceConstants;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.ISemanticHighlighting;
import org.eclipse.wst.sse.ui.ISemanticHighlightingExtension2;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

public class TwigSyntaxColoringPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private OverlayPreferenceStore fOverlayStore;
    private ColorSelector fForegroundColorEditor;
    private ColorSelector fBackgroundColorEditor;
    private final LineStyleProviderForTwig fStyleProvider;
    private Collection<String> fStylePreferenceKeys;
    private HashMap<String, String> fStyleToDescriptionMap;
    private Map<String, String> fContextToStyleMap;
    private Color fDefaultForeground;
    private Color fDefaultBackground;
    private StructuredViewer fStylesViewer;
    private Button fEnabler;
    private Label fForegroundLabel;
    private Label fBackgroundLabel;
    private Button fBold;
    private Button fItalic;
    private Button fStrike;
    private Button fUnderline;
    private Button fClearStyle;
    private StyledText fText;
    private IStructuredDocument fDocument;
    private static Map<String, Position[]> highlightingPositionMap;
    private static Map<String, HighlightingStyle> highlightingStyleMap;
    private IPropertyChangeListener fHighlightingChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            TwigSyntaxColoringPage.this.handleHighlightingPropertyChange(event);
        }
    };

    public TwigSyntaxColoringPage() {
        this.fStyleProvider = new LineStyleProviderForTwig();
    }

    public void init(IWorkbench workbench) {
        this.setDescription("Syntax Colors");
        this.fStyleToDescriptionMap = new HashMap();
        this.fContextToStyleMap = new HashMap<String, String>();
        this.initStyleToDescriptionMap();
        this.initRegionContextToStyleMap();
        IPreferenceStore store = this.getPreferenceStore();
        OverlayPreferenceStore.OverlayKey[] keys = this.createOverlayStoreKeys();
        this.fOverlayStore = new OverlayPreferenceStore(store, keys);
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        this.fStyleProvider.setColorPreferences((IPreferenceStore)this.fOverlayStore);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return PreferenceConstants.getPreferenceStore();
    }

    public boolean performOk() {
        this.getOverlayStore().propagate();
        TwigUICorePlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.getOverlayStore().loadDefaults();
        this.applyStyles();
        this.fStylesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this.activate(null);
        this.fText.redraw();
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        for (String key : this.getStylePreferenceKeys()) {
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, key));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, PreferenceConstants.getEnabledPreferenceKey(key)));
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    private Collection<String> getStylePreferenceKeys() {
        if (this.fStylePreferenceKeys == null) {
            ArrayList<String> styles = new ArrayList<String>();
            styles.add("codeStyleNormal");
            styles.add("editorColorBoundarymaker");
            styles.add("editorStmtColorBoundarymaker");
            styles.add("editorBlocknameColor");
            styles.add("editorColorString");
            styles.add("editorColorNumber");
            styles.add("editorColorComment");
            styles.add("editorColorKeyword");
            styles.add("editorColorJson");
            styles.add("editorColorInterpolation");
            this.fStylePreferenceKeys = styles;
        }
        return this.fStylePreferenceKeys;
    }

    private void initStyleToDescriptionMap() {
        this.fStyleToDescriptionMap.put("codeStyleNormal", "Normal");
        this.fStyleToDescriptionMap.put("editorColorBoundarymaker", "Print tags");
        this.fStyleToDescriptionMap.put("editorStmtColorBoundarymaker", "Block tags");
        this.fStyleToDescriptionMap.put("editorBlocknameColor", "Block name");
        this.fStyleToDescriptionMap.put("editorColorKeyword", "Label");
        this.fStyleToDescriptionMap.put("editorColorJson", "Hash Braces");
        this.fStyleToDescriptionMap.put("editorColorKeyword", "Keyword");
        this.fStyleToDescriptionMap.put("editorColorString", "String");
        this.fStyleToDescriptionMap.put("editorColorNumber", "Number");
        this.fStyleToDescriptionMap.put("editorColorComment", "Comment");
        this.fStyleToDescriptionMap.put("editorColorInterpolation", "String Interpolation");
    }

    private void initRegionContextToStyleMap() {
        this.fContextToStyleMap = this.fStyleProvider.getTwigColorTypesMap();
    }

    protected Control createContents(final Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fDefaultForeground = parent.getDisplay().getSystemColor(24);
        this.fDefaultBackground = parent.getDisplay().getSystemColor(25);
        Composite pageComponent = this.createComposite(parent, 2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageComponent, "org.eclipse.php.help.syntax_coloring_preferences");
        Link link = new Link(pageComponent, 64);
        String linkText = "Default colors and font can be configured on the <a href=\"org.eclipse.ui.preferencePages.GeneralTextEditor\">Text Editors</a> and on the <a href=\"org.eclipse.ui.preferencePages.ColorsAndFonts\">Colors and Fonts</a> preference pages.";
        link.setText(linkText);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)e.text, null, null);
            }
        });
        GridData linkData = new GridData(4, 1, true, false, 2, 1);
        linkData.widthHint = 150;
        link.setLayoutData((Object)linkData);
        new Label(pageComponent, 0).setLayoutData((Object)new GridData());
        new Label(pageComponent, 0).setLayoutData((Object)new GridData());
        SashForm editor = new SashForm(pageComponent, 512);
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.horizontalSpan = 2;
        editor.setLayoutData((Object)gridData2);
        SashForm top = new SashForm((Composite)editor, 256);
        Composite styleEditor = this.createComposite((Composite)top, 1);
        ((GridLayout)styleEditor.getLayout()).marginRight = 5;
        ((GridLayout)styleEditor.getLayout()).marginLeft = 0;
        this.createLabel(styleEditor, XMLUIMessages.SyntaxColoringPage_0);
        this.fStylesViewer = this.createStylesViewer(styleEditor);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalIndent = 0;
        Iterator<String> iterator = this.fStyleToDescriptionMap.values().iterator();
        while (iterator.hasNext()) {
            gridData.widthHint = Math.max(gridData.widthHint, this.convertWidthInCharsToPixels(iterator.next().toString().length()));
        }
        gridData.heightHint = this.convertHeightInCharsToPixels(5);
        this.fStylesViewer.getControl().setLayoutData((Object)gridData);
        Composite editingComposite = this.createComposite((Composite)top, 1);
        ((GridLayout)styleEditor.getLayout()).marginLeft = 5;
        this.createLabel(editingComposite, "");
        this.fEnabler = this.createCheckbox(editingComposite, XMLUIMessages.SyntaxColoringPage_2);
        this.fEnabler.setEnabled(false);
        Composite editControls = this.createComposite(editingComposite, 2);
        ((GridLayout)editControls.getLayout()).marginLeft = 20;
        this.fForegroundLabel = this.createLabel(editControls, SSEUIMessages.Foreground_UI_);
        ((GridData)this.fForegroundLabel.getLayoutData()).verticalAlignment = 0x1000000;
        this.fForegroundLabel.setEnabled(false);
        this.fForegroundColorEditor = new ColorSelector(editControls);
        Button fForegroundColor = this.fForegroundColorEditor.getButton();
        GridData gd = new GridData(1, 4, false, false);
        fForegroundColor.setLayoutData((Object)gd);
        this.fForegroundColorEditor.setEnabled(false);
        this.fBackgroundLabel = this.createLabel(editControls, SSEUIMessages.Background_UI_);
        ((GridData)this.fBackgroundLabel.getLayoutData()).verticalAlignment = 0x1000000;
        this.fBackgroundLabel.setEnabled(false);
        this.fBackgroundColorEditor = new ColorSelector(editControls);
        Button fBackgroundColor = this.fBackgroundColorEditor.getButton();
        gd = new GridData(1, 4, false, false);
        fBackgroundColor.setLayoutData((Object)gd);
        this.fBackgroundColorEditor.setEnabled(false);
        this.fBold = this.createCheckbox(editControls, XMLUIMessages.SyntaxColoringPage_3);
        this.fBold.setEnabled(false);
        ((GridData)this.fBold.getLayoutData()).horizontalSpan = 2;
        this.fItalic = this.createCheckbox(editControls, XMLUIMessages.SyntaxColoringPage_4);
        this.fItalic.setEnabled(false);
        ((GridData)this.fItalic.getLayoutData()).horizontalSpan = 2;
        this.fStrike = this.createCheckbox(editControls, XMLUIMessages.SyntaxColoringPage_5);
        this.fStrike.setEnabled(false);
        ((GridData)this.fStrike.getLayoutData()).horizontalSpan = 2;
        this.fUnderline = this.createCheckbox(editControls, XMLUIMessages.SyntaxColoringPage_6);
        this.fUnderline.setEnabled(false);
        ((GridData)this.fUnderline.getLayoutData()).horizontalSpan = 2;
        this.fClearStyle = new Button(editingComposite, 8);
        this.fClearStyle.setText(SSEUIMessages.Restore_Default_UI_);
        this.fClearStyle.setLayoutData((Object)new GridData(1));
        ((GridData)this.fClearStyle.getLayoutData()).horizontalIndent = 20;
        this.fClearStyle.setEnabled(false);
        Composite sampleArea = this.createComposite((Composite)editor, 1);
        ((GridLayout)sampleArea.getLayout()).marginLeft = 5;
        ((GridLayout)sampleArea.getLayout()).marginTop = 5;
        this.createLabel(sampleArea, SSEUIMessages.Sample_text__UI_);
        SourceViewer viewer = new SourceViewer(sampleArea, null, 33557258);
        this.fText = viewer.getTextWidget();
        GridData gridData3 = new GridData(4, 4, true, true);
        gridData3.widthHint = this.convertWidthInCharsToPixels(20);
        gridData3.heightHint = this.convertHeightInCharsToPixels(18);
        gridData3.horizontalSpan = 2;
        this.fText.setLayoutData((Object)gridData3);
        this.fText.setEditable(false);
        this.fText.setFont(JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont"));
        this.fText.addKeyListener(this.getTextKeyListener());
        this.fText.addSelectionListener(this.getTextSelectionListener());
        this.fText.addMouseListener(this.getTextMouseListener());
        this.fText.addTraverseListener(this.getTraverseListener());
        this.setAccessible((Control)this.fText, SSEUIMessages.Sample_text__UI_);
        this.fDocument = StructuredModelManager.getModelManager().createStructuredDocumentFor(ContentTypeIdForTwig.CONTENT_TYPE_ID_TWIG);
        this.fDocument.set(this.getExampleText());
        viewer.setDocument((IDocument)this.fDocument);
        top.setWeights(new int[]{2, 1});
        editor.setWeights(new int[]{1, 1});
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageComponent, "org.eclipse.php.help.syntax_coloring_preferences");
        this.fStylesViewer.setInput(this.getStylePreferenceKeys());
        this.fOverlayStore.addPropertyChangeListener(this.fHighlightingChangeListener);
        try {
            this.initHighlightingPositions();
            this.initHighlightingStyles();
            this.applyStyles();
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
        this.fStylesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    String namedStyle = o.toString();
                    TwigSyntaxColoringPage.this.activate(namedStyle);
                    if (namedStyle == null) {
                        return;
                    }
                }
            }
        });
        this.fForegroundColorEditor.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("colorValue")) {
                    Object o = ((IStructuredSelection)TwigSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                    String namedStyle = o.toString();
                    String prefString = TwigSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                    String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                    if (stylePrefs != null) {
                        String oldValue = stylePrefs[0];
                        String newValue = ColorHelper.toRGBString((RGB)TwigSyntaxColoringPage.this.fForegroundColorEditor.getColorValue());
                        if (!newValue.equals(oldValue)) {
                            stylePrefs[0] = newValue;
                            String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                            TwigSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                            TwigSyntaxColoringPage.this.applyStyles();
                            TwigSyntaxColoringPage.this.fText.redraw();
                        }
                    }
                }
            }
        });
        this.fBackgroundColorEditor.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("colorValue")) {
                    Object o = ((IStructuredSelection)TwigSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                    String namedStyle = o.toString();
                    String prefString = TwigSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                    String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                    if (stylePrefs != null) {
                        String oldValue = stylePrefs[1];
                        String newValue = ColorHelper.toRGBString((RGB)TwigSyntaxColoringPage.this.fBackgroundColorEditor.getColorValue());
                        if (!newValue.equals(oldValue)) {
                            stylePrefs[1] = newValue;
                            String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                            TwigSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                            TwigSyntaxColoringPage.this.applyStyles();
                            TwigSyntaxColoringPage.this.fText.redraw();
                            TwigSyntaxColoringPage.this.activate(namedStyle);
                        }
                    }
                }
            }
        });
        this.fBold.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Object o = ((IStructuredSelection)TwigSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                String namedStyle = o.toString();
                String prefString = TwigSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                if (stylePrefs != null) {
                    String oldValue = stylePrefs[2];
                    String newValue = String.valueOf(TwigSyntaxColoringPage.this.fBold.getSelection());
                    if (!newValue.equals(oldValue)) {
                        stylePrefs[2] = newValue;
                        String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                        TwigSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                        TwigSyntaxColoringPage.this.applyStyles();
                        TwigSyntaxColoringPage.this.fText.redraw();
                    }
                }
            }
        });
        this.fItalic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Object o = ((IStructuredSelection)TwigSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                String namedStyle = o.toString();
                String prefString = TwigSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                if (stylePrefs != null) {
                    String oldValue = stylePrefs[3];
                    String newValue = String.valueOf(TwigSyntaxColoringPage.this.fItalic.getSelection());
                    if (!newValue.equals(oldValue)) {
                        stylePrefs[3] = newValue;
                        String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                        TwigSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                        TwigSyntaxColoringPage.this.applyStyles();
                        TwigSyntaxColoringPage.this.fText.redraw();
                    }
                }
            }
        });
        this.fStrike.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Object o = ((IStructuredSelection)TwigSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                String namedStyle = o.toString();
                String prefString = TwigSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                if (stylePrefs != null) {
                    String oldValue = stylePrefs[4];
                    String newValue = String.valueOf(TwigSyntaxColoringPage.this.fStrike.getSelection());
                    if (!newValue.equals(oldValue)) {
                        stylePrefs[4] = newValue;
                        String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                        TwigSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                        TwigSyntaxColoringPage.this.applyStyles();
                        TwigSyntaxColoringPage.this.fText.redraw();
                    }
                }
            }
        });
        this.fUnderline.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Object o = ((IStructuredSelection)TwigSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                String namedStyle = o.toString();
                String prefString = TwigSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                if (stylePrefs != null) {
                    String oldValue = stylePrefs[5];
                    String newValue = String.valueOf(TwigSyntaxColoringPage.this.fUnderline.getSelection());
                    if (!newValue.equals(oldValue)) {
                        stylePrefs[5] = newValue;
                        String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                        TwigSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                        TwigSyntaxColoringPage.this.applyStyles();
                        TwigSyntaxColoringPage.this.fText.redraw();
                    }
                }
            }
        });
        this.fClearStyle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TwigSyntaxColoringPage.this.fStylesViewer.getSelection().isEmpty()) {
                    return;
                }
                String namedStyle = ((IStructuredSelection)TwigSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement().toString();
                TwigSyntaxColoringPage.this.getOverlayStore().setToDefault(namedStyle);
                TwigSyntaxColoringPage.this.applyStyles();
                TwigSyntaxColoringPage.this.fText.redraw();
                TwigSyntaxColoringPage.this.activate(namedStyle);
            }
        });
        this.fEnabler.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o = ((IStructuredSelection)TwigSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                String namedStyle = o.toString();
                if (TwigSyntaxColoringPage.this.getStylePreferenceKeys().contains(namedStyle)) {
                    boolean enablement = TwigSyntaxColoringPage.this.fEnabler.getSelection();
                    TwigSyntaxColoringPage.this.switchEnablement(enablement);
                    TwigSyntaxColoringPage.this.getOverlayStore().setValue(PreferenceConstants.getEnabledPreferenceKey(namedStyle), enablement);
                }
            }
        });
        this.switchEnablement(false);
        return pageComponent;
    }

    private void initHighlightingStyles() {
        highlightingStyleMap = new HashMap<String, HighlightingStyle>();
    }

    protected void initHighlightingPositions() {
        highlightingPositionMap = new HashMap<String, Position[]>();
        IPath stateLocation = TwigUICorePlugin.getDefault().getStateLocation();
        IPath path = stateLocation.append("/_TwigSyntax");
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(path);
        NonExistingPHPFileEditorInput input = new NonExistingPHPFileEditorInput(fileStore, "TwigSyntax");
        File realFile = input.getPath((Object)input).toFile();
        try {
            FileOutputStream fos = new FileOutputStream(realFile);
            fos.write(this.fDocument.get().getBytes());
            fos.close();
            DLTKUIPlugin.getDocumentProvider().connect((Object)input);
            ISourceModule sourceModule = DLTKUIPlugin.getDocumentProvider().getWorkingCopy((Object)input);
            ModuleDeclaration module = SourceParserUtil.parseSourceModule((String)sourceModule.getSource());
            if (sourceModule != null) {
                ArrayList highlightings = new ArrayList();
                Collections.sort(highlightings);
                for (AbstractSemanticHighlighting abstractSemanticHighlighting : highlightings) {
                    Position[] positions = abstractSemanticHighlighting.consumes(module);
                    if (positions == null || positions.length <= 0) continue;
                    highlightingPositionMap.put(abstractSemanticHighlighting.getPreferenceKey(), positions);
                }
            }
            DLTKUIPlugin.getDocumentProvider().disconnect((Object)input);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        realFile.delete();
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)data);
        return composite;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 64);
        label.setText(text);
        GridData data = new GridData(4, 4, false, false);
        label.setLayoutData((Object)data);
        label.setBackground(parent.getBackground());
        return label;
    }

    private StructuredViewer createStylesViewer(Composite parent) {
        ListViewer stylesViewer = new ListViewer(parent, 2820);
        stylesViewer.setComparator(new ViewerComparator((Comparator)Collator.getInstance()));
        stylesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String description = TwigSyntaxColoringPage.this.fStyleToDescriptionMap.get(element);
                if (description != null) {
                    return description.toString();
                }
                return super.getText(element);
            }
        });
        stylesViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                return TwigSyntaxColoringPage.this.getStylePreferenceKeys().toArray();
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object getParent(Object element) {
                return TwigSyntaxColoringPage.this.getStylePreferenceKeys();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        return stylesViewer;
    }

    Button createCheckbox(Composite parent, String label) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.setLayoutData((Object)new GridData(4, 4, true, false));
        return button;
    }

    private KeyListener getTextKeyListener() {
        return new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.widget instanceof StyledText) {
                    int x = ((StyledText)e.widget).getCaretOffset();
                    TwigSyntaxColoringPage.this.selectColorAtOffset(x);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.widget instanceof StyledText) {
                    int x = ((StyledText)e.widget).getCaretOffset();
                    TwigSyntaxColoringPage.this.selectColorAtOffset(x);
                }
            }
        };
    }

    private MouseListener getTextMouseListener() {
        return new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                if (e.widget instanceof StyledText) {
                    int x = ((StyledText)e.widget).getCaretOffset();
                    TwigSyntaxColoringPage.this.selectColorAtOffset(x);
                }
            }
        };
    }

    private SelectionListener getTextSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TwigSyntaxColoringPage.this.selectColorAtOffset(e.x);
                if (e.widget instanceof StyledText) {
                    ((StyledText)e.widget).setSelection(e.x);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                TwigSyntaxColoringPage.this.selectColorAtOffset(e.x);
                if (e.widget instanceof StyledText) {
                    ((StyledText)e.widget).setSelection(e.x);
                }
            }
        };
    }

    private TraverseListener getTraverseListener() {
        return new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.widget instanceof StyledText && (e.detail == 16 || e.detail == 8)) {
                    e.doit = true;
                }
            }
        };
    }

    private void selectColorAtOffset(int offset) {
        String namedStyle = this.getNamedStyleAtOffset(offset);
        if (namedStyle != null) {
            this.fStylesViewer.setSelection((ISelection)new StructuredSelection((Object)namedStyle));
            this.fStylesViewer.reveal((Object)namedStyle);
        } else {
            this.fStylesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        this.activate(namedStyle);
    }

    private String getNamedStyleAtOffset(int offset) {
        if (offset >= this.fDocument.getLength()) {
            return this.getNamedStyleAtOffset(this.fDocument.getLength() - 1);
        }
        if (offset < 0) {
            return this.getNamedStyleAtOffset(0);
        }
        if (highlightingPositionMap == null) {
            this.initHighlightingPositions();
        }
        for (String type : highlightingPositionMap.keySet()) {
            Position[] positions = highlightingPositionMap.get(type);
            int i = 0;
            while (i < positions.length) {
                if (offset >= positions[i].offset && offset < positions[i].offset + positions[i].length) {
                    return type;
                }
                ++i;
            }
        }
        IStructuredDocumentRegion documentRegion = this.fDocument.getFirstStructuredDocumentRegion();
        while (documentRegion != null && !documentRegion.containsOffset(offset)) {
            documentRegion = documentRegion.getNext();
        }
        if (documentRegion != null) {
            String regionContext;
            ITextRegion interest = documentRegion.getRegionAtCharacterOffset(offset);
            IStructuredDocumentRegion container = documentRegion;
            if (interest instanceof ITextRegionContainer) {
                container = (ITextRegionContainer)interest;
                interest = container.getRegionAtCharacterOffset(offset);
            }
            if (interest.getType() == "TWIG_CONTENT") {
                ITwigScriptRegion phpScript = (ITwigScriptRegion)interest;
                try {
                    regionContext = phpScript.getTwigTokenType(offset - container.getStartOffset() - phpScript.getStart());
                }
                catch (BadLocationException e) {
                    assert (false);
                    return null;
                }
            } else {
                regionContext = interest.getType() == "TWIG_STMT_OPEN" ? "TWIG_OPEN" : (interest.getType() == "TWIG_STMT_CLOSE" ? "TWIG_CLOSETAG" : interest.getType());
            }
            String namedStyle = this.fContextToStyleMap.get(regionContext);
            return namedStyle;
        }
        return null;
    }

    private void activate(String namedStyle) {
        Color foreground = this.fDefaultForeground;
        Color background = this.fDefaultBackground;
        if (namedStyle == null) {
            this.fEnabler.setEnabled(false);
            this.fClearStyle.setEnabled(false);
            this.fBold.setEnabled(false);
            this.fItalic.setEnabled(false);
            this.fStrike.setEnabled(false);
            this.fUnderline.setEnabled(false);
            this.fForegroundLabel.setEnabled(false);
            this.fBackgroundLabel.setEnabled(false);
            this.fForegroundColorEditor.setEnabled(false);
            this.fBackgroundColorEditor.setEnabled(false);
            this.fBold.setSelection(false);
            this.fItalic.setSelection(false);
            this.fStrike.setSelection(false);
            this.fUnderline.setSelection(false);
        } else {
            TextAttribute attribute = this.getAttributeFor(namedStyle);
            boolean enabled = true;
            enabled = this.getOverlayStore().getBoolean(PreferenceConstants.getEnabledPreferenceKey(namedStyle));
            this.fEnabler.setSelection(enabled);
            this.fEnabler.setEnabled(true);
            this.fClearStyle.setEnabled(true);
            this.fBold.setEnabled(enabled);
            this.fItalic.setEnabled(enabled);
            this.fStrike.setEnabled(enabled);
            this.fUnderline.setEnabled(enabled);
            this.fForegroundLabel.setEnabled(enabled);
            this.fBackgroundLabel.setEnabled(enabled);
            this.fForegroundColorEditor.setEnabled(enabled);
            this.fBackgroundColorEditor.setEnabled(enabled);
            this.fBold.setSelection((attribute.getStyle() & 1) != 0);
            this.fItalic.setSelection((attribute.getStyle() & 2) != 0);
            this.fStrike.setSelection((attribute.getStyle() & 0x20000000) != 0);
            this.fUnderline.setSelection((attribute.getStyle() & 0x40000000) != 0);
            if (attribute.getForeground() != null) {
                foreground = attribute.getForeground();
            }
            if (attribute.getBackground() != null) {
                background = attribute.getBackground();
            }
        }
        this.fForegroundColorEditor.setColorValue(foreground.getRGB());
        this.fBackgroundColorEditor.setColorValue(background.getRGB());
    }

    private OverlayPreferenceStore getOverlayStore() {
        return this.fOverlayStore;
    }

    private TextAttribute getAttributeFor(String namedStyle) {
        String prefString;
        String[] stylePrefs;
        TextAttribute ta = new TextAttribute(this.fDefaultForeground, this.fDefaultBackground, 0);
        if (namedStyle != null && this.fOverlayStore != null && (stylePrefs = ColorHelper.unpackStylePreferences((String)(prefString = this.getOverlayStore().getString(namedStyle)))) != null) {
            boolean on;
            RGB foreground = ColorHelper.toRGB((String)stylePrefs[0]);
            RGB background = ColorHelper.toRGB((String)stylePrefs[1]);
            int fontModifier = 0;
            if (stylePrefs.length > 2 && (on = Boolean.valueOf(stylePrefs[2]).booleanValue())) {
                fontModifier |= 1;
            }
            if (stylePrefs.length > 3 && (on = Boolean.valueOf(stylePrefs[3]).booleanValue())) {
                fontModifier |= 2;
            }
            if (stylePrefs.length > 4 && (on = Boolean.valueOf(stylePrefs[4]).booleanValue())) {
                fontModifier |= 0x20000000;
            }
            if (stylePrefs.length > 5 && (on = Boolean.valueOf(stylePrefs[5]).booleanValue())) {
                fontModifier |= 0x40000000;
            }
            ta = new TextAttribute(foreground != null ? EditorUtility.getColor((RGB)foreground) : null, background != null ? EditorUtility.getColor((RGB)background) : null, fontModifier);
        }
        return ta;
    }

    private void setAccessible(Control control, String name) {
        if (control == null) {
            return;
        }
        final String n = name;
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = n;
                }
            }
        });
    }

    private void switchEnablement(boolean b) {
        this.fBold.setEnabled(b);
        this.fItalic.setEnabled(b);
        this.fUnderline.setEnabled(b);
        this.fStrike.setEnabled(b);
        this.fBackgroundColorEditor.setEnabled(b);
        this.fForegroundColorEditor.setEnabled(b);
    }

    private String getExampleText() {
        return TwigUIMessages.ColorPage_CodeExample_0;
    }

    private void handleHighlightingPropertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property == null) {
            return;
        }
        for (String type : SemanticHighlightingManager.getInstance().getSemanticHighlightings().keySet()) {
            ISemanticHighlighting highlighting = SemanticHighlightingManager.getInstance().getSemanticHighlightings().get(type);
            HighlightingStyle style = highlightingStyleMap.get(type);
            if (property.equals(highlighting.getBoldPreferenceKey())) {
                this.adaptToTextStyleChange(style, event, 1);
                continue;
            }
            if (property.equals(highlighting.getColorPreferenceKey())) {
                this.adaptToTextForegroundChange(style, event);
                continue;
            }
            if (highlighting instanceof ISemanticHighlightingExtension2 && property.equals(((ISemanticHighlightingExtension2)highlighting).getBackgroundColorPreferenceKey())) {
                this.adaptToTextBackgroundChange(style, event);
                continue;
            }
            if (property.equals(highlighting.getEnabledPreferenceKey())) {
                this.adaptToEnablementChange(style, event);
                continue;
            }
            if (property.equals(highlighting.getItalicPreferenceKey())) {
                this.adaptToTextStyleChange(style, event, 2);
                continue;
            }
            if (property.equals(highlighting.getStrikethroughPreferenceKey())) {
                this.adaptToTextStyleChange(style, event, 0x20000000);
                continue;
            }
            if (!property.equals(highlighting.getUnderlinePreferenceKey())) continue;
            this.adaptToTextStyleChange(style, event, 0x40000000);
        }
    }

    void applyStyles() {
        if (this.fText == null || this.fText.isDisposed()) {
            return;
        }
        this.fStyleProvider.loadColors();
        IStructuredDocumentRegion documentRegion = this.fDocument.getFirstStructuredDocumentRegion();
        while (documentRegion != null) {
            ArrayList<StyleRange> holdResults = new ArrayList<StyleRange>();
            this.fStyleProvider.prepareTextRegions(documentRegion, 0, documentRegion.getEnd(), holdResults);
            for (StyleRange element : holdResults) {
                this.fText.setStyleRange(element);
            }
            documentRegion = documentRegion.getNext();
        }
    }

    private void adaptToEnablementChange(HighlightingStyle highlighting, PropertyChangeEvent event) {
        Object value = event.getNewValue();
        boolean eventValue = value instanceof Boolean ? (Boolean)value : "true".equals(value);
        highlighting.setEnabled(eventValue);
    }

    private void adaptToTextForegroundChange(HighlightingStyle highlighting, PropertyChangeEvent event) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = ColorHelper.toRGB((String)((String)value));
        }
        if (rgb != null) {
            Color color = EditorUtility.getColor((RGB)rgb);
            TextAttribute oldAttr = highlighting.getTextAttribute();
            highlighting.setTextAttribute(new TextAttribute(color, oldAttr.getBackground(), oldAttr.getStyle()));
        }
    }

    private void adaptToTextBackgroundChange(HighlightingStyle highlighting, PropertyChangeEvent event) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = ColorHelper.toRGB((String)((String)value));
        }
        if (rgb != null) {
            Color color = EditorUtility.getColor((RGB)rgb);
            TextAttribute oldAttr = highlighting.getTextAttribute();
            highlighting.setTextAttribute(new TextAttribute(oldAttr.getForeground(), color, oldAttr.getStyle()));
        }
    }

    private void adaptToTextStyleChange(HighlightingStyle highlighting, PropertyChangeEvent event, int styleAttribute) {
        boolean activeValue;
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        TextAttribute oldAttr = highlighting.getTextAttribute();
        boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
        if (activeValue != eventValue) {
            highlighting.setTextAttribute(new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
        }
    }

    static class HighlightingStyle {
        private TextAttribute fTextAttribute;
        private boolean fIsEnabled;

        public HighlightingStyle(TextAttribute textAttribute, boolean isEnabled) {
            this.setTextAttribute(textAttribute);
            this.setEnabled(isEnabled);
        }

        public TextAttribute getTextAttribute() {
            return this.fTextAttribute;
        }

        public void setTextAttribute(TextAttribute textAttribute) {
            this.fTextAttribute = textAttribute;
        }

        public boolean isEnabled() {
            return this.fIsEnabled;
        }

        public void setEnabled(boolean isEnabled) {
            this.fIsEnabled = isEnabled;
        }
    }
}

