/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.utils;

import com.dubture.twig.core.model.IFilter;
import com.dubture.twig.core.model.ITag;
import com.dubture.twig.core.model.ITest;
import com.dubture.twig.ui.TwigPluginImages;
import com.dubture.twig.ui.TwigUICorePlugin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.ui.documentation.PHPDocumentationContentAccess;
import org.eclipse.swt.graphics.FontData;
import org.osgi.framework.Bundle;

public class HTMLUtils {
    private static String fgStyleSheet;

    public static String tag2Html(ITag tag) {
        StringBuffer info = new StringBuffer();
        String styles = HTMLUtils.getStyleSheet();
        HTMLPrinter.insertPageProlog((StringBuffer)info, (int)0, (String)styles);
        URL imageUrl = TwigUICorePlugin.getDefault().getImagesOnFSRegistry().getImageURL(TwigPluginImages.DESC_OBJS_TAG);
        String body = null;
        if (imageUrl != null) {
            StringBuffer header = new StringBuffer();
            String imageName = imageUrl.toExternalForm();
            String name = String.valueOf(tag.getElementName()) + " (" + tag.getPhpClass() + ")";
            body = tag.getDescription();
            HTMLUtils.addImageAndLabel(header, imageName, 16, 16, 2, 2, name, 20, 2, true);
            HTMLPrinter.addSmallHeader((StringBuffer)info, (String)header.toString());
        }
        StringBuffer content = new StringBuffer();
        if (body != null) {
            content.append(body);
        }
        HTMLPrinter.addParagraph((StringBuffer)info, (Reader)new StringReader(content.toString()));
        HTMLPrinter.addPageEpilog((StringBuffer)info);
        return info.toString();
    }

    public static String test2Html(ITest test) {
        StringBuffer info = new StringBuffer();
        String styles = HTMLUtils.getStyleSheet();
        HTMLPrinter.insertPageProlog((StringBuffer)info, (int)0, (String)styles);
        URL imageUrl = TwigUICorePlugin.getDefault().getImagesOnFSRegistry().getImageURL(TwigPluginImages.DESC_OBJS_TEST);
        String body = null;
        if (imageUrl != null) {
            StringBuffer header = new StringBuffer();
            String imageName = imageUrl.toExternalForm();
            String name = String.valueOf(test.getElementName()) + " (" + test.getPhpClass() + ")";
            body = test.getDescription();
            HTMLUtils.addImageAndLabel(header, imageName, 16, 16, 2, 2, name, 20, 2, true);
            HTMLPrinter.addSmallHeader((StringBuffer)info, (String)header.toString());
        }
        StringBuffer content = new StringBuffer();
        if (body != null) {
            content.append(body);
        }
        HTMLPrinter.addParagraph((StringBuffer)info, (Reader)new StringReader(content.toString()));
        HTMLPrinter.addPageEpilog((StringBuffer)info);
        return info.toString();
    }

    public static String filter2Html(IFilter filter) {
        StringBuffer info = new StringBuffer();
        String styles = HTMLUtils.getStyleSheet();
        HTMLPrinter.insertPageProlog((StringBuffer)info, (int)0, (String)styles);
        URL imageUrl = TwigUICorePlugin.getDefault().getImagesOnFSRegistry().getImageURL(TwigPluginImages.DESC_OBJS_FILTER);
        String body = null;
        if (imageUrl != null) {
            StringBuffer header = new StringBuffer();
            String imageName = imageUrl.toExternalForm();
            IScriptProject project = filter.getScriptProject();
            String name = String.valueOf(filter.getElementName()) + " (" + filter.getPhpClass() + ")";
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project);
            IMethod[] methods = PHPModelAccess.getDefault().findMethods(filter.getInternalFunction(), ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
            if (methods.length > 0 && filter.getInternalFunction().length() > 0) {
                IMethod method = methods[0];
                try {
                    body = PHPDocumentationContentAccess.getHTMLContent((IMember)method);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            HTMLUtils.addImageAndLabel(header, imageName, 16, 16, 2, 2, name, 20, 2, true);
            HTMLPrinter.addSmallHeader((StringBuffer)info, (String)header.toString());
        }
        StringBuffer content = new StringBuffer();
        if (body != null) {
            content.append(body);
        }
        HTMLPrinter.addParagraph((StringBuffer)info, (Reader)new StringReader(content.toString()));
        HTMLPrinter.addPageEpilog((StringBuffer)info);
        return info.toString();
    }

    private static String getStyleSheet() {
        String css;
        if (fgStyleSheet == null) {
            fgStyleSheet = HTMLUtils.loadStylesheet();
        }
        if ((css = fgStyleSheet) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.dltk.ui.documentationFont")[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    private static String loadStylesheet() {
        Bundle bundle = Platform.getBundle((String)"com.dubture.twig.ui");
        URL styleSheetURL = bundle.getEntry("/TwigDocumentationStylesheet.css");
        if (styleSheetURL != null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
                StringBuffer buffer = new StringBuffer(1500);
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    buffer.append('\n');
                    line = reader.readLine();
                }
                String string = buffer.toString();
                return string;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return "";
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static void addImageAndLabel(StringBuffer buf, String imageName, int imageWidth, int imageHeight, int imageLeft, int imageTop, String label, int labelLeft, int labelTop, boolean isFirstElement) {
        label = String.valueOf(label) + "&nbsp";
        if (imageName != null) {
            StringBuffer imageStyle = new StringBuffer("position: absolute; ");
            imageStyle.append("width: ").append(imageWidth).append("px; ");
            imageStyle.append("height: ").append(imageHeight).append("px; ");
            if (isFirstElement) {
                imageStyle.append("top: ").append(imageTop).append("px; ");
                imageStyle.append("left: ").append(imageLeft).append("px; ");
            } else {
                imageStyle.append("margin-top: ").append(imageTop).append("px; ");
                imageStyle.append("margin-left: ").append(-imageLeft).append("px; ");
            }
            buf.append("<img style='").append(imageStyle).append("' src='").append(imageName).append("'/>\n");
        }
        buf.append("<div style='word-wrap:break-word;");
        if (imageName != null) {
            buf.append("margin-left: ").append(labelLeft).append("px; ");
            buf.append("margin-top: ").append(labelTop).append("px; ");
        }
        buf.append("'>");
        buf.append(label);
        buf.append("</div>");
    }
}

