/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.ui.wizards;

import com.dubture.twig.core.log.Logger;
import com.dubture.twig.ui.extension.ExtensionManager;
import com.dubture.twig.ui.wizards.ITemplateProvider;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.wizards.NewSourceModulePage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class TwigNewFileWizardPage
extends NewSourceModulePage {
    private Text containerText;
    private Text fileText;
    private ISelection selection;
    private String filename = "";
    private ITemplateProvider[] extensions;

    public TwigNewFileWizardPage(ISelection selection) {
        this.selection = selection;
    }

    protected void createContentControls(Composite container, int nColumns) {
        Label label = new Label(container, 0);
        label.setText("&Source folder:");
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TwigNewFileWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TwigNewFileWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("&File name:");
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TwigNewFileWizardPage.this.filename = TwigNewFileWizardPage.this.fileText.getText();
                TwigNewFileWizardPage.this.dialogChanged();
            }
        });
        Label label2 = new Label(container, 0);
        label2.setVisible(false);
        this.extensions = ExtensionManager.getInstance().getTemplateProviders();
        Logger.debugMSG((String)"Creating extension controls");
        ITemplateProvider[] iTemplateProviderArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            ITemplateProvider provider = iTemplateProviderArray[n2];
            provider.createContentControls(this.getScriptFolder(), container);
            ++n2;
        }
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        Logger.debugMSG((String)"Initializing twig file wizard");
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                Logger.debugMSG((String)"Selection container more than one elements.");
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IScriptFolder) {
                Logger.debugMSG((String)"Selection is scriptfolder");
                IScriptFolder folder = (IScriptFolder)obj;
                try {
                    String fullPath = folder.getUnderlyingResource().getFullPath().toString();
                    Logger.debugMSG((String)("Setting container text to " + fullPath));
                    this.containerText.setText(fullPath);
                }
                catch (ModelException e) {
                    Logger.logException((Throwable)e);
                }
            } else if (obj instanceof ProjectFragment) {
                IProjectFragment fragment = (IProjectFragment)obj;
                Logger.debugMSG((String)"Selection is projectfragment");
                try {
                    String fullPath = fragment.getUnderlyingResource().getFullPath().toString();
                    Logger.debugMSG((String)("Setting container text to " + fullPath));
                    this.containerText.setText(fullPath);
                }
                catch (ModelException e) {
                    Logger.logException((Throwable)e);
                }
            } else if (obj instanceof IScriptProject) {
                IScriptProject proj = (IScriptProject)obj;
                Logger.debugMSG((String)"Selection is scriptproject");
                this.containerText.setText(proj.getPath().toString());
            } else if (obj instanceof IFolder) {
                IFolder folder = (IFolder)obj;
                Logger.debugMSG((String)"Selection is folder");
                this.containerText.setText(folder.getFullPath().toString());
            } else {
                Logger.debugMSG((String)"Could not determine selection type");
                if (obj != null) {
                    Logger.debugMSG((String)("type was " + obj.getClass()));
                } else {
                    Logger.debugMSG((String)"type was null");
                }
            }
        } else {
            Logger.debugMSG((String)"File wizard couldn't retrieve selection");
        }
        Logger.debugMSG((String)("Final container text: " + this.containerText.getText()));
        this.fileText.setText("template.twig");
        this.fileText.forceFocus();
        this.fileText.setSelection(0, 8);
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new folder");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus("Folder must be specified");
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus("Folder must exist");
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("File name must be valid");
            return;
        }
        this.updateStatus(new IStatus[]{new StatusInfo()});
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.getScriptFolderText();
    }

    public String getFileName() {
        return this.filename;
    }

    protected String getPageTitle() {
        return "New Twig template";
    }

    protected String getPageDescription() {
        return "Create a new twig template.";
    }

    protected String getRequiredNature() {
        return "com.dubture.twig.core.TwigNature";
    }

    protected String getFileContent(ISourceModule module) throws CoreException {
        if (this.extensions == null || this.extensions.length == 0) {
            return "";
        }
        String content = "";
        ITemplateProvider[] iTemplateProviderArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            ITemplateProvider provider = iTemplateProviderArray[n2];
            content = String.valueOf(content) + provider.getContents();
            ++n2;
        }
        return content;
    }
}

