/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.builder;

import java.util.ArrayList;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;

public class BuilderUtil {
    private BuilderUtil() {
    }

    public static void triggerClean(IProject project, String builderName) throws CoreException {
        project.build(15, builderName, null, null);
    }

    public static void triggerBuild(IProject project, String builderName) throws CoreException {
        project.build(6, builderName, null, null);
    }

    public static boolean addBuilderToProject(IProject project, String builderId) throws CoreException {
        IProjectDescription description = project.getDescription();
        if (!BuilderUtil.containsBuildCommand(description, builderId)) {
            BuilderUtil.addBuildCommand(description, builderId);
            project.setDescription(description, null);
            return true;
        }
        return false;
    }

    public static boolean removeBuilderFromProject(IProject project, String builderId) throws CoreException {
        IProjectDescription description = project.getDescription();
        if (BuilderUtil.containsBuildCommand(description, builderId)) {
            BuilderUtil.removeBuildCommands(description, builderId);
            project.setDescription(description, null);
            return true;
        }
        return false;
    }

    private static boolean containsBuildCommand(IProjectDescription description, String builderId) {
        ICommand[] iCommandArray = description.getBuildSpec();
        int n = iCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (command.getBuilderName().equals(builderId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void addBuildCommand(IProjectDescription description, String builderId) {
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand[] newCommands = new ICommand[oldCommands.length + 1];
        System.arraycopy(oldCommands, 0, newCommands, 0, oldCommands.length);
        newCommands[newCommands.length - 1] = BuilderUtil.createBuildCommand(description, builderId);
        description.setBuildSpec(newCommands);
    }

    private static void removeBuildCommands(IProjectDescription description, String builderId) {
        ICommand[] oldCommands = description.getBuildSpec();
        ArrayList<ICommand> list = new ArrayList<ICommand>();
        ICommand[] iCommandArray = oldCommands;
        int n = oldCommands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (!command.getBuilderName().equals(builderId)) {
                list.add(command);
            }
            ++n2;
        }
        ICommand[] newCommands = new ICommand[list.size()];
        list.toArray(newCommands);
        description.setBuildSpec(newCommands);
    }

    private static ICommand createBuildCommand(IProjectDescription description, String builderId) {
        ICommand command = description.newCommand();
        command.setBuilderName(builderId);
        return command;
    }
}

