/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.builder;

import com.eclipsesource.jshint.ui.internal.Activator;
import com.eclipsesource.jshint.ui.internal.builder.CommentsFilter;
import com.eclipsesource.jshint.ui.internal.preferences.OptionsPreferences;
import com.eclipsesource.jshint.ui.internal.preferences.PreferencesFactory;
import com.eclipsesource.jshint.ui.internal.util.IOUtil;
import com.eclipsesource.json.JsonObject;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.osgi.service.prefs.Preferences;

public class ConfigLoader {
    private final IProject project;

    public ConfigLoader(IProject project) {
        this.project = project;
    }

    public JsonObject getConfiguration() {
        Preferences projectNode = PreferencesFactory.getProjectPreferences(this.project);
        OptionsPreferences projectPreferences = new OptionsPreferences(projectNode);
        if (projectPreferences.getProjectSpecific()) {
            return this.getProjectConfig(projectPreferences);
        }
        return ConfigLoader.getWorkspaceConfig();
    }

    private JsonObject getProjectConfig(OptionsPreferences projectPrefs) {
        try {
            String json = this.getProjectConfigJson(projectPrefs);
            return JsonObject.readFrom((String)CommentsFilter.filterComments(json));
        }
        catch (Exception exception) {
            String message = "Failed to read jshint configuration for project " + this.project.getName();
            Activator.logError(message, exception);
            return new JsonObject();
        }
    }

    private String getProjectConfigJson(OptionsPreferences projectPrefs) throws CoreException, IOException {
        IFile configFile = this.getProjectConfigFile();
        if (!configFile.exists()) {
            return projectPrefs.getConfig();
        }
        return IOUtil.readFileUtf8(configFile);
    }

    private IFile getProjectConfigFile() {
        return this.project.getFile(".jshintrc");
    }

    private static JsonObject getWorkspaceConfig() {
        try {
            String json = ConfigLoader.getWorkspaceConfigJson();
            return JsonObject.readFrom((String)CommentsFilter.filterComments(json));
        }
        catch (Exception exception) {
            String message = "Failed to read jshint configuration from workspace preferences";
            Activator.logError(message, exception);
            return new JsonObject();
        }
    }

    private static String getWorkspaceConfigJson() {
        Preferences workspaceNode = PreferencesFactory.getWorkspacePreferences();
        return new OptionsPreferences(workspaceNode).getConfig();
    }
}

