/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.builder;

import com.eclipsesource.jshint.JSHint;
import com.eclipsesource.jshint.ProblemHandler;
import com.eclipsesource.jshint.Text;
import com.eclipsesource.jshint.ui.internal.builder.ConfigLoader;
import com.eclipsesource.jshint.ui.internal.builder.JSHintBuilder;
import com.eclipsesource.jshint.ui.internal.builder.MarkerAdapter;
import com.eclipsesource.jshint.ui.internal.builder.MarkerHandler;
import com.eclipsesource.jshint.ui.internal.preferences.EnablementPreferences;
import com.eclipsesource.jshint.ui.internal.preferences.JSHintPreferences;
import com.eclipsesource.jshint.ui.internal.preferences.PreferencesFactory;
import com.eclipsesource.jshint.ui.internal.preferences.ResourceSelector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.prefs.Preferences;

class JSHintBuilderVisitor
implements IResourceVisitor,
IResourceDeltaVisitor {
    private final JSHint checker;
    private final ResourceSelector selector;
    private final IProgressMonitor monitor;

    public JSHintBuilderVisitor(IProject project, IProgressMonitor monitor) throws CoreException {
        Preferences node = PreferencesFactory.getProjectPreferences(project);
        new EnablementPreferences(node);
        this.selector = new ResourceSelector(project);
        this.checker = this.selector.allowVisitProject() ? this.createJSHint(project) : null;
        this.monitor = monitor;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        return this.visit(resource);
    }

    public boolean visit(IResource resource) throws CoreException {
        boolean descend = false;
        if (resource.exists() && this.selector.allowVisitProject() && !this.monitor.isCanceled()) {
            if (resource.getType() != 1) {
                descend = this.selector.allowVisitFolder(resource);
            } else {
                JSHintBuilderVisitor.clean(resource);
                if (this.selector.allowVisitFile(resource)) {
                    this.check((IFile)resource);
                }
                descend = true;
            }
        }
        return descend;
    }

    private JSHint createJSHint(IProject project) throws CoreException {
        JSHint jshint = new JSHint();
        try {
            InputStream inputStream = JSHintBuilderVisitor.getCustomLib();
            if (inputStream != null) {
                try {
                    jshint.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
            } else {
                jshint.load();
            }
            jshint.configure(new ConfigLoader(project).getConfiguration());
        }
        catch (IOException exception) {
            String message = "Failed to intialize JSHint";
            throw new CoreException((IStatus)new Status(4, "com.eclipsesource.jshint.ui", message, (Throwable)exception));
        }
        return jshint;
    }

    private void check(IFile file) throws CoreException {
        Text code = JSHintBuilderVisitor.readContent(file);
        MarkerHandler handler = new MarkerHandler(new MarkerAdapter((IResource)file), code);
        try {
            this.checker.check(code, (ProblemHandler)handler);
        }
        catch (JSHintBuilder.CoreExceptionWrapper wrapper) {
            throw (CoreException)wrapper.getCause();
        }
        catch (RuntimeException exception) {
            String message = "Failed checking file " + file.getFullPath().toPortableString();
            throw new RuntimeException(message, exception);
        }
    }

    private static void clean(IResource resource) throws CoreException {
        new MarkerAdapter(resource).removeMarkers();
    }

    private static InputStream getCustomLib() throws FileNotFoundException {
        JSHintPreferences globalPrefs = new JSHintPreferences();
        if (globalPrefs.getUseCustomLib()) {
            File file = new File(globalPrefs.getCustomLibPath());
            return new FileInputStream(file);
        }
        return null;
    }

    private static Text readContent(IFile file) throws CoreException {
        try {
            InputStream inputStream = file.getContents();
            String charset = file.getCharset();
            return JSHintBuilderVisitor.readContent(inputStream, charset);
        }
        catch (IOException exception) {
            String message = "Failed to read resource";
            throw new CoreException((IStatus)new Status(4, "com.eclipsesource.jshint.ui", message, (Throwable)exception));
        }
    }

    private static Text readContent(InputStream inputStream, String charset) throws UnsupportedEncodingException, IOException {
        Text result;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charset));
        try {
            result = new Text((Reader)reader);
        }
        finally {
            reader.close();
        }
        return result;
    }
}

