/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.builder;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class MarkerAdapter {
    private static final String TYPE_PROBLEM = "com.eclipsesource.jshint.ui.problemmarker";
    private static final String TYPE_PROBLEM_OLD = "com.eclipsesource.jshint.problemmarker";
    private final IResource resource;

    public MarkerAdapter(IResource resource) {
        this.resource = resource;
    }

    public void removeMarkers() throws CoreException {
        this.resource.deleteMarkers(TYPE_PROBLEM, true, 2);
        this.resource.deleteMarkers(TYPE_PROBLEM_OLD, true, 2);
    }

    public void createWarning(int line, int start, int end, String message) throws CoreException {
        this.createMarker(line, start, end, message, 1);
    }

    public void createError(int line, int start, int end, String message) throws CoreException {
        this.createMarker(line, start, end, message, 2);
    }

    private void createMarker(int line, int start, int end, String message, int severity) throws CoreException {
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        IMarker marker = this.resource.createMarker(TYPE_PROBLEM);
        marker.setAttribute("severity", severity);
        marker.setAttribute("message", (Object)message);
        if (line >= 1) {
            marker.setAttribute("lineNumber", line);
        }
        if (start >= 0) {
            marker.setAttribute("charStart", (Object)new Integer(start));
            marker.setAttribute("charEnd", (Object)new Integer(end >= start ? end : start));
        }
    }
}

