/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.builder;

import com.eclipsesource.jshint.Problem;
import com.eclipsesource.jshint.ProblemHandler;
import com.eclipsesource.jshint.Text;
import com.eclipsesource.jshint.ui.internal.builder.JSHintBuilder;
import com.eclipsesource.jshint.ui.internal.builder.MarkerAdapter;
import com.eclipsesource.jshint.ui.internal.preferences.JSHintPreferences;
import org.eclipse.core.runtime.CoreException;

final class MarkerHandler
implements ProblemHandler {
    private final MarkerAdapter markerAdapter;
    private final Text code;
    private final boolean enableErrorMarkers;

    MarkerHandler(MarkerAdapter markerAdapter, Text code) {
        this.markerAdapter = markerAdapter;
        this.code = code;
        this.enableErrorMarkers = new JSHintPreferences().getEnableErrorMarkers();
    }

    public void handleProblem(Problem problem) {
        int line = problem.getLine();
        int character = problem.getCharacter();
        if (this.isValidLine(line)) {
            int offset = -1;
            if (this.isValidCharacter(line, character)) {
                offset = this.code.getLineOffset(line - 1) + character;
            }
            this.createMarker(line, offset, problem.getMessage(), problem.isError());
        } else {
            this.createMarker(-1, -1, problem.getMessage(), problem.isError());
        }
    }

    private void createMarker(int line, int character, String message, boolean isError) throws JSHintBuilder.CoreExceptionWrapper {
        try {
            if (this.enableErrorMarkers && isError) {
                this.markerAdapter.createError(line, character, character, message);
            } else {
                this.markerAdapter.createWarning(line, character, character, message);
            }
        }
        catch (CoreException ce) {
            throw new JSHintBuilder.CoreExceptionWrapper(ce);
        }
    }

    private boolean isValidLine(int line) {
        return line >= 1 && line <= this.code.getLineCount();
    }

    private boolean isValidCharacter(int line, int character) {
        return character >= 0 && character < this.code.getLineLength(line - 1);
    }
}

