/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.preferences;

import com.eclipsesource.jshint.ui.internal.preferences.PathEncoder;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnablementPreferences {
    private static final String KEY_EXCLUDED = "excluded";
    private static final String KEY_INCLUDED = "included";
    private static final String DEF_EXCLUDED = "";
    private static final String DEF_INCLUDED = "";
    private final Preferences node;
    private boolean changed;

    public EnablementPreferences(Preferences node) {
        this.node = node;
        this.changed = false;
    }

    public void setIncludePatterns(List<String> patterns) {
        String value = PathEncoder.encodePaths(patterns);
        if (!value.equals(this.node.get(KEY_INCLUDED, ""))) {
            if ("".equals(value)) {
                this.node.remove(KEY_INCLUDED);
            } else {
                this.node.put(KEY_INCLUDED, value);
            }
            this.changed = true;
        }
    }

    public List<String> getIncludePatterns() {
        String value = this.node.get(KEY_INCLUDED, "");
        return PathEncoder.decodePaths(value);
    }

    public void setExcludePatterns(List<String> patterns) {
        String value = PathEncoder.encodePaths(patterns);
        if (!value.equals(this.node.get(KEY_EXCLUDED, ""))) {
            if ("".equals(value)) {
                this.node.remove(KEY_EXCLUDED);
            } else {
                this.node.put(KEY_EXCLUDED, value);
            }
            this.changed = true;
        }
    }

    public List<String> getExcludePatterns() {
        String value = this.node.get(KEY_EXCLUDED, "");
        return PathEncoder.decodePaths(value);
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void clearChanged() {
        this.changed = false;
    }

    public static String getResourcePath(IResource resource) {
        return resource.getProjectRelativePath().toPortableString();
    }
}

