/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.preferences;

import com.eclipsesource.jshint.ui.internal.preferences.PreferencesFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class JSHintPreferences {
    private static final String KEY_USE_CUSTOM_LIB = "useCustomJshint";
    private static final String KEY_CUSTOM_LIB_PATH = "customJshintPath";
    private static final String KEY_ENABLE_ERROR_MARKERS = "enableErrorMarkers";
    private static final boolean DEF_USE_CUSTOM_LIB = false;
    private static final String DEF_CUSTOM_LIB_PATH = "";
    private static final boolean DEF_ENABLE_ERROR_MARKERS = false;
    private final Lock readLock;
    private final Lock writeLock;
    private final Preferences node;
    private boolean useCustomLib;
    private String customLibPath;
    private boolean enableErrorMarkers;
    private boolean dirty;

    public JSHintPreferences() {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.node = PreferencesFactory.getWorkspacePreferences();
        this.useCustomLib = this.node.getBoolean(KEY_USE_CUSTOM_LIB, false);
        this.customLibPath = this.node.get(KEY_CUSTOM_LIB_PATH, DEF_CUSTOM_LIB_PATH);
        this.enableErrorMarkers = this.node.getBoolean(KEY_ENABLE_ERROR_MARKERS, false);
        this.dirty = false;
    }

    public void resetToDefaults() {
        this.setUseCustomLib(false);
        this.setCustomLibPath(DEF_CUSTOM_LIB_PATH);
        this.setEnableErrorMarkers(false);
    }

    public boolean getUseCustomLib() {
        try {
            this.readLock.lock();
            boolean bl = this.useCustomLib;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setUseCustomLib(boolean useCustomLib) {
        try {
            this.writeLock.lock();
            if (useCustomLib != this.useCustomLib) {
                this.useCustomLib = useCustomLib;
                this.dirty = true;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getCustomLibPath() {
        try {
            this.readLock.lock();
            String string = this.customLibPath;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setCustomLibPath(String customLibPath) {
        try {
            this.writeLock.lock();
            if (!customLibPath.equals(this.customLibPath)) {
                this.customLibPath = customLibPath;
                this.dirty = true;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean getEnableErrorMarkers() {
        try {
            this.readLock.lock();
            boolean bl = this.enableErrorMarkers;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setEnableErrorMarkers(boolean enableErrorMarkers) {
        try {
            this.writeLock.lock();
            if (enableErrorMarkers != this.enableErrorMarkers) {
                this.enableErrorMarkers = enableErrorMarkers;
                this.dirty = true;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean hasChanged() {
        try {
            this.readLock.lock();
            boolean bl = this.dirty;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void save() throws CoreException {
        this.putUseCustomLib();
        this.putCustomLibPath();
        this.putEnableErrorMarkers();
        this.flushNode();
        try {
            this.writeLock.lock();
            this.dirty = false;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void putUseCustomLib() {
        try {
            this.readLock.lock();
            if (!this.useCustomLib) {
                this.node.remove(KEY_USE_CUSTOM_LIB);
            } else {
                this.node.putBoolean(KEY_USE_CUSTOM_LIB, this.useCustomLib);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void putCustomLibPath() {
        try {
            this.readLock.lock();
            if (this.customLibPath.equals(DEF_CUSTOM_LIB_PATH)) {
                this.node.remove(KEY_CUSTOM_LIB_PATH);
            } else {
                this.node.put(KEY_CUSTOM_LIB_PATH, this.customLibPath);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void putEnableErrorMarkers() {
        try {
            this.readLock.lock();
            if (!this.enableErrorMarkers) {
                this.node.remove(KEY_ENABLE_ERROR_MARKERS);
            } else {
                this.node.putBoolean(KEY_ENABLE_ERROR_MARKERS, this.enableErrorMarkers);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void flushNode() throws CoreException {
        try {
            this.node.flush();
        }
        catch (BackingStoreException exception) {
            String message = "Failed to store preferences";
            Status status = new Status(4, "com.eclipsesource.jshint.ui", message, (Throwable)exception);
            throw new CoreException((IStatus)status);
        }
    }
}

