/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.preferences;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionParserUtil {
    private OptionParserUtil() {
    }

    public static JsonObject createConfiguration(String options, String globals) {
        JsonObject configuration = new JsonObject();
        for (Entry entry : OptionParserUtil.parseOptionString(options)) {
            configuration.add(entry.name, entry.value);
        }
        JsonObject globalsObject = new JsonObject();
        for (Entry entry : OptionParserUtil.parseOptionString(globals)) {
            globalsObject.add(entry.name, entry.value == JsonValue.TRUE);
        }
        if (!globalsObject.isEmpty()) {
            configuration.add("globals", (JsonValue)globalsObject);
        }
        return configuration;
    }

    static List<Entry> parseOptionString(String input) {
        String[] elements;
        ArrayList<Entry> result = new ArrayList<Entry>();
        String[] stringArray = elements = input.split(",");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String string = OptionParserUtil.parseOptionElement(result, element.trim());
            ++n2;
        }
        return result;
    }

    private static String parseOptionElement(List<Entry> result, String element) {
        String[] parts;
        String key;
        if (element.length() > 0 && (key = (parts = element.split(":", 2))[0].trim()).length() > 0 && parts.length == 2) {
            try {
                JsonValue value = JsonValue.readFrom((String)parts[1].trim());
                result.add(new Entry(key, value));
            }
            catch (ParseException parseException) {}
        }
        return element;
    }

    static class Entry {
        public final String name;
        public final JsonValue value;

        public Entry(String name, JsonValue value) {
            this.name = name;
            this.value = value;
        }
    }
}

