/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.preferences;

import com.eclipsesource.jshint.ui.internal.preferences.OptionParserUtil;
import com.eclipsesource.jshint.ui.internal.util.JsonUtil;
import org.osgi.service.prefs.Preferences;

public class OptionsPreferences {
    private static final String KEY_PROJ_SPECIFIC = "projectSpecificOptions";
    private static final String KEY_GLOBALS = "globals";
    private static final String KEY_OPTIONS = "options";
    private static final String KEY_CONFIG = "config";
    public static final boolean DEFAULT_PROJ_SPECIFIC = false;
    public static final String DEFAULT_CONFIG = "{\n  \n}";
    private final Preferences node;
    private boolean changed;

    public OptionsPreferences(Preferences node) {
        this.node = node;
    }

    public Preferences getNode() {
        return this.node;
    }

    public boolean getProjectSpecific() {
        return this.node.getBoolean(KEY_PROJ_SPECIFIC, false);
    }

    public void setProjectSpecific(boolean value) {
        if (value != this.node.getBoolean(KEY_PROJ_SPECIFIC, false)) {
            if (!value) {
                this.node.remove(KEY_PROJ_SPECIFIC);
            } else {
                this.node.putBoolean(KEY_PROJ_SPECIFIC, value);
            }
            this.changed = true;
        }
    }

    public String getConfig() {
        String config = this.node.get(KEY_CONFIG, null);
        return config != null ? config : this.getOldConfig();
    }

    private String getOldConfig() {
        String options = this.node.get(KEY_OPTIONS, "");
        String globals = this.node.get(KEY_GLOBALS, "");
        return JsonUtil.prettyPrint(OptionParserUtil.createConfiguration(options, globals));
    }

    public void setConfig(String value) {
        if (!value.equals(this.node.get(KEY_CONFIG, null))) {
            this.node.put(KEY_CONFIG, value);
            this.changed = true;
        }
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void clearChanged() {
        this.changed = false;
    }
}

