/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.preferences;

import com.eclipsesource.jshint.ui.internal.preferences.PathSegmentPattern;

public class PathPattern {
    private final boolean isAbsolute;
    private final PathSegmentPattern[] segmentPatterns;

    private PathPattern(String expression) {
        PathPattern.checkExpression(expression);
        this.isAbsolute = expression.startsWith("/") && !expression.startsWith("//");
        this.segmentPatterns = PathPattern.extractSegments(expression);
    }

    public static PathPattern create(String expression) {
        return new PathPattern(expression);
    }

    public boolean matchesFile(String fileName) {
        return this.getFileSegmentPattern().matches(fileName);
    }

    public boolean matchesFolder(String ... pathSegments) {
        if (this.segmentPatterns.length == 1) {
            return pathSegments.length == 0;
        }
        return this.match(0, 0, pathSegments);
    }

    public boolean matchesAllFiles() {
        return this.getFileSegmentPattern() == PathSegmentPattern.ALL;
    }

    public boolean matchesAllFolders() {
        return this.segmentPatterns.length == 2 && this.segmentPatterns[0] == PathSegmentPattern.ANY_NUMBER;
    }

    public String getFilePattern() {
        return this.getFileSegmentPattern().toString();
    }

    public String getPathPattern() {
        StringBuilder builder = new StringBuilder();
        if (this.isAbsolute) {
            builder.append('/');
        }
        int i = 0;
        while (i < this.segmentPatterns.length - 1) {
            PathSegmentPattern pattern = this.segmentPatterns[i];
            if (pattern != PathSegmentPattern.ANY_NUMBER) {
                builder.append(pattern.toString());
            } else if (i == 0) {
                builder.append('/');
            }
            builder.append('/');
            ++i;
        }
        return builder.toString();
    }

    private PathSegmentPattern getFileSegmentPattern() {
        return this.segmentPatterns[this.segmentPatterns.length - 1];
    }

    private boolean match(int patternPos, int inputPos, String[] segments) {
        if (patternPos == this.segmentPatterns.length - 1) {
            return inputPos == segments.length;
        }
        if (inputPos == segments.length) {
            if (this.segmentPatterns[patternPos] == PathSegmentPattern.ANY_NUMBER) {
                return this.match(patternPos + 1, inputPos, segments);
            }
            return false;
        }
        if (this.segmentPatterns[patternPos] == PathSegmentPattern.ANY_NUMBER) {
            int nextInputPos = inputPos;
            while (nextInputPos <= segments.length) {
                if (this.match(patternPos + 1, nextInputPos, segments)) {
                    return true;
                }
                ++nextInputPos;
            }
            return false;
        }
        if (this.segmentPatterns[patternPos].matches(segments[inputPos])) {
            return this.match(patternPos + 1, inputPos + 1, segments);
        }
        return false;
    }

    private static void checkExpression(String expression) {
        if (expression.contains("///")) {
            throw new IllegalArgumentException("Too many successive slashes in expression");
        }
    }

    private static PathSegmentPattern[] extractSegments(String expression) {
        String preparedExpression = PathPattern.prepareExpression(expression);
        return PathPattern.splitIntoSegmentPatterns(preparedExpression);
    }

    private static String prepareExpression(String expression) {
        String result = expression;
        if (expression.startsWith("/")) {
            result = expression.substring(1);
        }
        return result;
    }

    static PathSegmentPattern[] splitIntoSegmentPatterns(String expression) {
        PathSegmentPattern[] patterns = new PathSegmentPattern[8];
        int count = 0;
        int begin = 0;
        int next = expression.indexOf(47, begin);
        while (next != -1) {
            if (count == patterns.length - 1) {
                patterns = PathPattern.createCopy(patterns, count * 2);
            }
            patterns[count++] = PathPattern.createPathSegmentPattern(expression, begin, next);
            begin = next + 1;
            next = expression.indexOf(47, begin);
        }
        patterns[count++] = PathPattern.createFileSegmentPattern(expression, begin, expression.length());
        return PathPattern.createCopy(patterns, count);
    }

    private static PathSegmentPattern createPathSegmentPattern(String expression, int begin, int next) {
        if (begin == next) {
            return PathSegmentPattern.ANY_NUMBER;
        }
        return PathSegmentPattern.create(expression.substring(begin, next));
    }

    private static PathSegmentPattern createFileSegmentPattern(String expression, int begin, int next) {
        if (begin == next) {
            return PathSegmentPattern.ALL;
        }
        return PathSegmentPattern.create(expression.substring(begin, next));
    }

    private static PathSegmentPattern[] createCopy(PathSegmentPattern[] original, int newLength) {
        PathSegmentPattern[] copy = new PathSegmentPattern[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

