/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.preferences;

public class PathSegmentPattern {
    public static final PathSegmentPattern ALL = new PathSegmentPattern("*");
    public static final PathSegmentPattern NONE = new PathSegmentPattern("");
    public static final PathSegmentPattern ANY_NUMBER = new PathSegmentPattern("");
    private final String expression;
    private final Matcher matcher;

    private PathSegmentPattern(String expression) {
        this.expression = PathSegmentPattern.checkExpression(expression);
        this.matcher = new Matcher(expression);
    }

    public static PathSegmentPattern create(String expression) {
        if (expression == null) {
            throw new NullPointerException("parameter is null");
        }
        if ("".equals(expression)) {
            return NONE;
        }
        if ("*".equals(expression)) {
            return ALL;
        }
        return new PathSegmentPattern(expression);
    }

    public boolean matches(String string) {
        if (this == ALL || this == ANY_NUMBER) {
            return true;
        }
        if (this == NONE) {
            return false;
        }
        return this.matcher.match(string);
    }

    public String toString() {
        if (this == ANY_NUMBER) {
            return "//";
        }
        if (this == NONE) {
            return "NONE";
        }
        return this.expression;
    }

    private static String checkExpression(String expression) {
        int length = expression.length();
        int i = 0;
        while (i < length) {
            char ch = expression.charAt(i);
            if (PathSegmentPattern.isIllegalCharacter(ch)) {
                throw new IllegalArgumentException("Illegal character in expression: '" + ch + "'");
            }
            ++i;
        }
        return expression;
    }

    private static boolean isIllegalCharacter(char ch) {
        return ch == '!' || ch == '+' || ch == ':' || ch == '|' || ch == '(' || ch == ')' || ch == '[' || ch == ']' || ch == '}' || ch == '{' || ch == '/' || ch == '\\';
    }

    private static class Matcher {
        private final char[] pattern;

        public Matcher(String pattern) {
            this.pattern = pattern.toCharArray();
        }

        public boolean match(String input) {
            return this.match(0, 0, input.toCharArray());
        }

        private boolean match(int patternPos, int inputPos, char[] input) {
            if (patternPos == this.pattern.length) {
                return inputPos == input.length;
            }
            if (inputPos == input.length) {
                if (this.pattern[patternPos] == '*') {
                    return this.match(patternPos + 1, inputPos, input);
                }
                return false;
            }
            if (this.pattern[patternPos] == '*') {
                int nextInputPos = inputPos;
                while (nextInputPos <= input.length) {
                    if (this.match(patternPos + 1, nextInputPos, input)) {
                        return true;
                    }
                    ++nextInputPos;
                }
                return false;
            }
            if (this.pattern[patternPos] == '?') {
                return this.match(patternPos + 1, inputPos + 1, input);
            }
            if (this.pattern[patternPos] == input[inputPos]) {
                return this.match(patternPos + 1, inputPos + 1, input);
            }
            return false;
        }
    }
}

