/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.preferences;

import com.eclipsesource.jshint.ui.internal.preferences.EnablementPreferences;
import com.eclipsesource.jshint.ui.internal.preferences.PathPattern;
import com.eclipsesource.jshint.ui.internal.preferences.PreferencesFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSelector {
    private final List<PathPattern> includePatterns;
    private final List<PathPattern> excludePatterns;

    public ResourceSelector(IProject project) {
        Preferences preferenceNode = PreferencesFactory.getProjectPreferences(project);
        EnablementPreferences preferences = new EnablementPreferences(preferenceNode);
        this.includePatterns = ResourceSelector.createPatterns(preferences.getIncludePatterns());
        this.excludePatterns = ResourceSelector.createPatterns(preferences.getExcludePatterns());
    }

    public boolean allowVisitProject() {
        return !this.includePatterns.isEmpty();
    }

    public boolean allowVisitFolder(IResource resource) {
        return !this.includePatterns.isEmpty();
    }

    public boolean allowVisitFile(IResource resource) {
        String fileName;
        String[] pathSegments = resource.getParent().getProjectRelativePath().segments();
        return this.isFileIncluded(pathSegments, fileName = resource.getName()) && !this.isFileExcluded(pathSegments, fileName);
    }

    private boolean isFileIncluded(String[] parentSegments, String fileName) {
        for (PathPattern pattern : this.includePatterns) {
            if (!pattern.matchesFolder(parentSegments) || !pattern.matchesFile(fileName)) continue;
            return true;
        }
        return false;
    }

    private boolean isFileExcluded(String[] parentSegments, String fileName) {
        for (PathPattern pattern : this.excludePatterns) {
            if (!pattern.matchesFolder(parentSegments) || !pattern.matchesFile(fileName)) continue;
            return true;
        }
        return false;
    }

    private static List<PathPattern> createPatterns(List<String> expressions) {
        ArrayList<PathPattern> patterns = new ArrayList<PathPattern>(expressions.size());
        for (String expression : expressions) {
            patterns.add(PathPattern.create(expression));
        }
        return patterns;
    }
}

