/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.preferences.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.statushandlers.StatusManager;

public class BrowserSupport {
    private static final int BROWSER_STYLE = 46;
    public static final BrowserSupport INSTANCE = new BrowserSupport();
    private final Listener selectionListener = this.createSelectionListener();

    private BrowserSupport() {
    }

    public void openUrl(String url) {
        if (url == null) {
            throw new NullPointerException("url is null");
        }
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser browser = support.createBrowser(46, url, null, null);
            browser.openURL(new URL(url));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Invalid URL: " + url);
        }
        catch (PartInitException exception) {
            StatusManager.getManager().handle(exception.getStatus(), 1);
        }
    }

    public void enableHyperlinks(Link link) {
        link.addListener(13, this.selectionListener);
    }

    private Listener createSelectionListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (BrowserSupport.isSupportedUrl(event.text)) {
                    BrowserSupport.this.openUrl(event.text);
                }
            }
        };
    }

    private static boolean isSupportedUrl(String text) {
        return text.startsWith("http://") || text.startsWith("https://");
    }
}

