/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.preferences.ui;

import com.eclipsesource.jshint.ui.internal.Activator;
import com.eclipsesource.jshint.ui.internal.builder.CommentsFilter;
import com.eclipsesource.jshint.ui.internal.util.IOUtil;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.ParseException;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ConfigEditor {
    private final StyledText styledText;
    private final Color errorBorderColor;
    private int errorOffset;

    public ConfigEditor(Composite parent) {
        this.errorBorderColor = new Color((Device)parent.getDisplay(), 230, 0, 0);
        this.styledText = new StyledText(parent, 2816);
        this.styledText.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.styledText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ConfigEditor.this.validate();
            }
        });
        this.styledText.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                ConfigEditor.this.drawError(event.gc);
            }
        });
        this.styledText.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                ConfigEditor.this.dispose();
            }
        });
    }

    public StyledText getControl() {
        return this.styledText;
    }

    public void setText(String text) {
        this.styledText.setText(text);
    }

    public String getText() {
        return this.styledText.getText().trim();
    }

    public void setEnabled(boolean enabled) {
        this.styledText.setEditable(enabled);
        this.styledText.setForeground(enabled ? null : this.styledText.getDisplay().getSystemColor(15));
    }

    public void validate() {
        String config = new CommentsFilter(this.styledText.getText()).toString();
        try {
            JsonObject.readFrom((String)config);
            this.handleError(null);
            this.removeErrorMarker();
        }
        catch (ParseException exception) {
            int line = exception.getLine();
            int column = exception.getColumn();
            this.handleError("Syntax error in config at " + line + ":" + column);
            this.setErrorMarker(line, column);
        }
    }

    public void importConfig() {
        Shell shell = this.styledText.getShell();
        FileDialog dialog = new FileDialog(shell, 4096);
        String file = dialog.open();
        if (file != null) {
            try {
                this.setText(IOUtil.readFromFileUtf8(file));
            }
            catch (IOException exception) {
                String message = "Could not read from file " + file;
                MessageDialog.openError((Shell)shell, (String)"Import Failed", (String)(String.valueOf(message) + "\nSee log for details."));
                Activator.logError(message, exception);
            }
        }
    }

    public void exportConfig() {
        Shell shell = this.styledText.getShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setOverwrite(true);
        String file = dialog.open();
        if (file != null) {
            String text = this.getText();
            try {
                IOUtil.writeToFileUtf8(file, text);
            }
            catch (IOException exception) {
                String message = "Could not write to file " + file;
                MessageDialog.openError((Shell)shell, (String)"Export Failed", (String)(String.valueOf(message) + "\nSee log for details."));
                Activator.logError(message, exception);
            }
        }
    }

    protected void handleError(String message) {
    }

    private void drawError(GC gc) {
        if (this.errorOffset >= 0) {
            int offset = Math.min(this.styledText.getCharCount(), this.errorOffset);
            Point location = this.styledText.getLocationAtOffset(offset);
            Point extent = gc.stringExtent("x");
            gc.setBackground(this.errorBorderColor);
            gc.fillRectangle(location.x, location.y + extent.y, extent.x, 2);
        }
    }

    private void setErrorMarker(int line, int column) {
        int errorLine = Math.max(0, Math.min(this.styledText.getLineCount() - 1, line - 1));
        this.errorOffset = this.styledText.getOffsetAtLine(errorLine) + column;
        this.styledText.redraw();
    }

    private void removeErrorMarker() {
        this.errorOffset = -1;
        this.styledText.redraw();
    }

    private void dispose() {
        this.errorBorderColor.dispose();
    }
}

