/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.preferences.ui;

import com.eclipsesource.jshint.ui.internal.Activator;
import com.eclipsesource.jshint.ui.internal.builder.BuilderUtil;
import com.eclipsesource.jshint.ui.internal.preferences.OptionsPreferences;
import com.eclipsesource.jshint.ui.internal.preferences.PreferencesFactory;
import com.eclipsesource.jshint.ui.internal.preferences.ui.BrowserSupport;
import com.eclipsesource.jshint.ui.internal.preferences.ui.ButtonBar;
import com.eclipsesource.jshint.ui.internal.preferences.ui.ConfigEditor;
import com.eclipsesource.jshint.ui.internal.util.JsonUtil;
import com.eclipsesource.jshint.ui.internal.util.LayoutUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ConfigPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ConfigEditor configEditor;
    private String origConfig;

    public ConfigPreferencePage() {
        this.setDescription("Global JSHint configuration");
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Control labelPart = this.createLabelPart(composite);
        Control configTextPart = this.createConfigTextPart(composite);
        Control buttonsPart = this.createButtonsPart(composite);
        LayoutUtil.gridData((Control)composite).fillBoth();
        LayoutUtil.gridLayout(composite).columns(2).spacing(3);
        LayoutUtil.gridData(labelPart).span(2, 1).fillHorizontal().widthHint(360);
        LayoutUtil.gridData(configTextPart).fillBoth().sizeHint(360, 180);
        LayoutUtil.gridData(buttonsPart).align(1, 1);
        this.loadPreferences();
        return composite;
    }

    private Control createLabelPart(Composite parent) {
        Link link = new Link(parent, 64);
        link.setText("For syntax, see <a>http://www.jshint.com/docs/</a>.");
        BrowserSupport.INSTANCE.enableHyperlinks(link);
        return link;
    }

    private Control createConfigTextPart(Composite parent) {
        this.configEditor = new ConfigEditor(parent){

            public void handleError(String message) {
                ConfigPreferencePage.this.setErrorMessage(message);
                ConfigPreferencePage.this.setValid(message == null);
            }
        };
        return this.configEditor.getControl();
    }

    private Control createButtonsPart(Composite parent) {
        ButtonBar buttonBar = new ButtonBar(parent, 0);
        buttonBar.addButton("I&mport", new Listener(){

            public void handleEvent(Event event) {
                ConfigPreferencePage.this.configEditor.importConfig();
            }
        });
        buttonBar.addButton("E&xport", new Listener(){

            public void handleEvent(Event event) {
                ConfigPreferencePage.this.configEditor.exportConfig();
            }
        });
        return buttonBar;
    }

    private void loadPreferences() {
        OptionsPreferences optionsPreferences = new OptionsPreferences(this.getPreferences());
        this.origConfig = optionsPreferences.getConfig();
        this.configEditor.setText(this.origConfig);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.configEditor.setText("{\n  \n}");
    }

    public boolean performOk() {
        try {
            this.storePreferences();
            if (!JsonUtil.jsonEquals(this.configEditor.getText(), this.origConfig)) {
                this.triggerRebuild();
            }
        }
        catch (CoreException exception) {
            String message = "Failed to store settings";
            Activator.logError(message, (Exception)((Object)exception));
            return false;
        }
        return true;
    }

    private void storePreferences() throws CoreException {
        OptionsPreferences optionsPreferences = new OptionsPreferences(this.getPreferences());
        optionsPreferences.setConfig(this.configEditor.getText());
        if (optionsPreferences.hasChanged()) {
            this.savePreferences();
        }
    }

    private void savePreferences() throws CoreException {
        Preferences node = this.getPreferences();
        try {
            node.flush();
        }
        catch (BackingStoreException exception) {
            String message = "Failed to store preferences";
            Status status = new Status(4, "com.eclipsesource.jshint.ui", message, (Throwable)exception);
            throw new CoreException((IStatus)status);
        }
    }

    private void triggerRebuild() throws CoreException {
        IProject[] iProjectArray = this.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                BuilderUtil.triggerClean(project, "com.eclipsesource.jshint.ui.builder");
            }
            ++n2;
        }
    }

    IProject[] getProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    Preferences getPreferences() {
        return PreferencesFactory.getWorkspacePreferences();
    }
}

