/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.preferences.ui;

import com.eclipsesource.jshint.ui.internal.Activator;
import com.eclipsesource.jshint.ui.internal.builder.BuilderUtil;
import com.eclipsesource.jshint.ui.internal.preferences.OptionsPreferences;
import com.eclipsesource.jshint.ui.internal.preferences.ui.AbstractPropertyPage;
import com.eclipsesource.jshint.ui.internal.preferences.ui.BrowserSupport;
import com.eclipsesource.jshint.ui.internal.preferences.ui.ButtonBar;
import com.eclipsesource.jshint.ui.internal.preferences.ui.ConfigEditor;
import com.eclipsesource.jshint.ui.internal.util.IOUtil;
import com.eclipsesource.jshint.ui.internal.util.JsonUtil;
import com.eclipsesource.jshint.ui.internal.util.LayoutUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;

public class ConfigPropertyPage
extends AbstractPropertyPage {
    private Button projectSpecificCheckbox;
    private ConfigEditor configEditor;
    private String origConfig;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Control projectSpecificPart = this.createProjectSpecificPart(composite);
        Control labelPart = this.createLabelPart(composite);
        Control configTextPart = this.createConfigTextPart(composite);
        Control buttonsPart = this.createButtonsPart(composite);
        LayoutUtil.gridData((Control)composite).fillBoth();
        LayoutUtil.gridLayout(composite).columns(2).spacing(3);
        LayoutUtil.gridData(projectSpecificPart);
        LayoutUtil.gridData(labelPart).span(2, 1).fillHorizontal().widthHint(360);
        LayoutUtil.gridData(configTextPart).fillBoth().sizeHint(360, 180);
        LayoutUtil.gridData(buttonsPart).align(1, 1);
        this.loadPreferences();
        return composite;
    }

    private Control createProjectSpecificPart(Composite parent) {
        this.projectSpecificCheckbox = new Button(parent, 32);
        this.projectSpecificCheckbox.setText("Enable project specific configuration");
        this.projectSpecificCheckbox.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ConfigPropertyPage.this.prefsChanged();
            }
        });
        return this.projectSpecificCheckbox;
    }

    private Control createLabelPart(Composite parent) {
        Link link = new Link(parent, 64);
        link.setText("The project specific configuration will be read from a file named .jshintrc in the project root. For the syntax of this file, see <a>http://www.jshint.com/docs/</a>.");
        BrowserSupport.INSTANCE.enableHyperlinks(link);
        return link;
    }

    private Control createConfigTextPart(Composite parent) {
        this.configEditor = new ConfigEditor(parent){

            public void handleError(String message) {
                if (ConfigPropertyPage.this.projectSpecificCheckbox.getSelection()) {
                    ConfigPropertyPage.this.setErrorMessage(message);
                    ConfigPropertyPage.this.setValid(message == null);
                }
            }
        };
        return this.configEditor.getControl();
    }

    private Control createButtonsPart(Composite parent) {
        ButtonBar buttonBar = new ButtonBar(parent, 0);
        buttonBar.addButton("I&mport", new Listener(){

            public void handleEvent(Event event) {
                ConfigPropertyPage.this.configEditor.importConfig();
            }
        });
        buttonBar.addButton("E&xport", new Listener(){

            public void handleEvent(Event event) {
                ConfigPropertyPage.this.configEditor.exportConfig();
            }
        });
        return buttonBar;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.projectSpecificCheckbox.setSelection(false);
        this.configEditor.setText("{\n  \n}");
    }

    public boolean performOk() {
        try {
            boolean configChanged;
            boolean prefsChanged = this.storePrefs();
            boolean bl = configChanged = this.projectSpecificCheckbox.getSelection() && this.storeConfig();
            if (prefsChanged || configChanged) {
                this.triggerRebuild();
            }
        }
        catch (CoreException exception) {
            String message = "Failed to store preferences";
            Activator.logError(message, (Exception)((Object)exception));
            return false;
        }
        return true;
    }

    private void prefsChanged() {
        boolean projectSpecific = this.projectSpecificCheckbox.getSelection();
        this.configEditor.setEnabled(projectSpecific);
        if (projectSpecific) {
            this.configEditor.validate();
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    private void loadPreferences() {
        OptionsPreferences prefs = new OptionsPreferences(this.getPreferences());
        this.projectSpecificCheckbox.setSelection(prefs.getProjectSpecific());
        this.origConfig = this.readConfigFile();
        this.configEditor.setText(this.origConfig != null ? this.origConfig : this.getDefaultConfig());
        this.configEditor.setEnabled(prefs.getProjectSpecific());
    }

    private boolean storePrefs() throws CoreException {
        OptionsPreferences prefs = new OptionsPreferences(this.getPreferences());
        prefs.setProjectSpecific(this.projectSpecificCheckbox.getSelection());
        boolean changed = prefs.hasChanged();
        if (changed) {
            this.savePreferences();
        }
        return changed;
    }

    private boolean storeConfig() throws CoreException {
        String config = this.configEditor.getText();
        boolean jsonChanged = !JsonUtil.jsonEquals(config, this.origConfig);
        this.writeConfigFile(config);
        this.origConfig = config;
        return jsonChanged;
    }

    private String readConfigFile() {
        IFile configFile = this.getConfigFile();
        if (ConfigPropertyPage.checkExists(configFile)) {
            try {
                return IOUtil.readFileUtf8(configFile);
            }
            catch (Exception exception) {
                String message = "Failed to read config file";
                this.setErrorMessage(message);
                Activator.logError(message, exception);
            }
        }
        return null;
    }

    private void writeConfigFile(String content) throws CoreException {
        try {
            IOUtil.writeFileUtf8(this.getConfigFile(), content);
        }
        catch (CoreException coreException) {
            String message = "Could not write to config file";
            throw new CoreException((IStatus)new Status(4, "com.eclipsesource.jshint.ui", message));
        }
    }

    private IFile getConfigFile() {
        return this.getResource().getProject().getFile(".jshintrc");
    }

    private String getDefaultConfig() {
        return new OptionsPreferences(this.getPreferences()).getConfig();
    }

    private void triggerRebuild() throws CoreException {
        IProject project = this.getResource().getProject();
        BuilderUtil.triggerClean(project, "com.eclipsesource.jshint.ui.builder");
    }

    private static boolean checkExists(IFile file) {
        if (file.exists()) {
            return true;
        }
        try {
            file.refreshLocal(0, null);
        }
        catch (CoreException exception) {
            Activator.logError(exception.getLocalizedMessage(), (Exception)((Object)exception));
        }
        return file.exists();
    }
}

