/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.preferences.ui;

import com.eclipsesource.jshint.ui.internal.preferences.EnablementPreferences;
import com.eclipsesource.jshint.ui.internal.preferences.ui.ButtonBar;
import com.eclipsesource.jshint.ui.internal.preferences.ui.PathPatternDialog;
import com.eclipsesource.jshint.ui.internal.util.LayoutUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludesView
extends Composite {
    private Table includeTable;
    private Table excludeTable;
    private Image fileImage;

    public IncludesView(Composite parent, int style, IProject project) {
        super(parent, style);
        LayoutUtil.gridLayout(this).columns(2).spacing(5, 3);
        this.createImages();
        this.createIncludeControls();
        this.createExcludeControls();
    }

    public void loadDefaults() {
        this.setPatterns(this.includeTable, Collections.<String>emptyList());
        this.setPatterns(this.excludeTable, Collections.<String>emptyList());
    }

    public void loadPreferences(EnablementPreferences preferences) {
        List<String> includePatterns = preferences.getIncludePatterns();
        List<String> excludePatterns = preferences.getExcludePatterns();
        this.setPatterns(this.includeTable, includePatterns);
        this.setPatterns(this.excludeTable, excludePatterns);
    }

    public void storePreferences(EnablementPreferences preferences) {
        ArrayList<String> includePatterns = IncludesView.getPatterns(this.includeTable);
        preferences.setIncludePatterns(includePatterns);
        ArrayList<String> excludePatterns = IncludesView.getPatterns(this.excludeTable);
        preferences.setExcludePatterns(excludePatterns);
    }

    private void createImages() {
        Display display = this.getDisplay();
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.fileImage = images.getImageDescriptor("IMG_OBJ_FILE").createImage((Device)display);
    }

    private void createIncludeControls() {
        Label label = new Label((Composite)this, 0);
        label.setText("Enable JSHint for these files and folders:");
        LayoutUtil.gridData((Control)label).span(2, 1);
        this.includeTable = new Table((Composite)this, 2048);
        LayoutUtil.gridData((Control)this.includeTable).fillBoth();
        this.createButtonsBar(this.includeTable);
        this.addListeners(this.includeTable);
    }

    private void createExcludeControls() {
        Label label = new Label((Composite)this, 0);
        label.setText("But exclude these files and folders from validation:");
        LayoutUtil.gridData((Control)label).span(2, 1);
        this.excludeTable = new Table((Composite)this, 2048);
        LayoutUtil.gridData((Control)this.excludeTable).fillBoth();
        this.createButtonsBar(this.excludeTable);
        this.addListeners(this.excludeTable);
    }

    private void addListeners(final Table table) {
        table.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                IncludesView.this.editSelectedPattern(table);
            }
        });
        table.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    event.doit = false;
                }
            }
        });
    }

    private void createButtonsBar(Table table) {
        ButtonBar buttonBar = new ButtonBar(this, 0);
        this.createAddButton(table, buttonBar);
        this.createEditButton(table, buttonBar);
        this.createRemoveButton(table, buttonBar);
    }

    private void createAddButton(final Table table, ButtonBar buttonBar) {
        buttonBar.addButton("Add", new Listener(){

            public void handleEvent(Event event) {
                IncludesView.this.addPattern(table);
            }
        });
    }

    private void createEditButton(final Table table, ButtonBar buttonBar) {
        final Button button = buttonBar.addButton("Edit", new Listener(){

            public void handleEvent(Event event) {
                IncludesView.this.editSelectedPattern(table);
            }
        });
        button.setEnabled(false);
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                button.setEnabled(table.getSelectionCount() > 0);
            }
        });
    }

    private void createRemoveButton(final Table table, ButtonBar buttonBar) {
        final Button button = buttonBar.addButton("Remove", new Listener(){

            public void handleEvent(Event event) {
                IncludesView.this.removeSelectedPattern(table);
            }
        });
        button.setEnabled(false);
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                button.setEnabled(table.getSelectionCount() > 0);
            }
        });
    }

    private void addPattern(Table table) {
        String defaultPattern = table == this.includeTable ? "//*.js" : "//*.min.js";
        String pattern = this.showPatternDialogForTable(table, defaultPattern);
        if (pattern != null) {
            ArrayList<String> patterns = IncludesView.getPatterns(table);
            if (!patterns.contains(pattern)) {
                patterns.add(pattern);
            }
            this.setPatterns(table, patterns);
            IncludesView.select(table, pattern);
        }
    }

    private void editSelectedPattern(Table table) {
        String oldPattern;
        String newPattern;
        TableItem[] selection = table.getSelection();
        if (selection.length != 0 && (newPattern = this.showPatternDialogForTable(table, oldPattern = selection[0].getText())) != null) {
            ArrayList<String> patterns = IncludesView.getPatterns(table);
            patterns.remove(oldPattern);
            patterns.add(newPattern);
            this.setPatterns(table, patterns);
            IncludesView.select(table, newPattern);
        }
    }

    private void removeSelectedPattern(Table table) {
        int selection = table.getSelectionIndex();
        if (selection != -1) {
            String pattern = table.getItem(selection).getText();
            ArrayList<String> patterns = IncludesView.getPatterns(table);
            patterns.remove(pattern);
            this.setPatterns(table, patterns);
            IncludesView.select(table, selection);
        }
    }

    private String showPatternDialogForTable(Table table, String origPattern) {
        String pattern = null;
        PathPatternDialog dialog = new PathPatternDialog(table.getShell(), origPattern);
        this.configurePatternDialog(dialog, table);
        if (dialog.open() == 0) {
            pattern = dialog.getValue();
        }
        return pattern;
    }

    private void configurePatternDialog(PathPatternDialog dialog, Table table) {
        if (table == this.excludeTable) {
            dialog.setTitle("Select files to exclude");
        } else {
            dialog.setTitle("Select files to include");
        }
    }

    private static void select(Table table, String pattern) {
        TableItem[] items = table.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getText().equals(pattern)) {
                table.select(i);
            }
            ++i;
        }
    }

    private static void select(Table table, int selection) {
        int itemCount = table.getItemCount();
        if (selection < itemCount) {
            table.select(selection);
        } else if (itemCount > 0) {
            table.select(itemCount - 1);
        }
    }

    private void setPatterns(Table table, List<String> patterns) {
        Collections.sort(patterns);
        table.removeAll();
        for (String pattern : patterns) {
            TableItem item = new TableItem(table, 0);
            item.setText(pattern);
            item.setImage(this.fileImage);
        }
    }

    private static ArrayList<String> getPatterns(Table table) {
        TableItem[] items = table.getItems();
        ArrayList<String> result = new ArrayList<String>();
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            result.add(item.getText());
            ++n2;
        }
        return result;
    }
}

