/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.preferences.ui;

import com.eclipsesource.jshint.JSHint;
import com.eclipsesource.jshint.ui.internal.Activator;
import com.eclipsesource.jshint.ui.internal.builder.BuilderUtil;
import com.eclipsesource.jshint.ui.internal.preferences.JSHintPreferences;
import com.eclipsesource.jshint.ui.internal.util.LayoutUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JSHintPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final JSHintPreferences preferences;
    private Button defaultLibRadio;
    private Button customLibRadio;
    private Text customLibPathText;
    private Button customLibPathButton;
    private Button enableErrorsCheckbox;

    public JSHintPreferencePage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("General settings for JSHint");
        this.preferences = new JSHintPreferences();
    }

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return null;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        LayoutUtil.gridLayout(composite).columns(3).spacing(3).marginTop(10);
        this.createCustomJSHintArea(composite);
        this.createEnableErrorMarkersArea(composite);
        this.updateControlsFromPrefs();
        this.updateControlsEnabled();
        return composite;
    }

    public boolean performOk() {
        try {
            if (this.preferences.hasChanged()) {
                this.preferences.save();
                this.triggerRebuild();
            }
        }
        catch (CoreException exception) {
            Activator.logError("Failed to save preferences", (Exception)((Object)exception));
            return false;
        }
        return true;
    }

    protected void performDefaults() {
        this.preferences.resetToDefaults();
        this.updateControlsFromPrefs();
        this.updateControlsEnabled();
        super.performDefaults();
    }

    private void createCustomJSHintArea(Composite parent) {
        this.defaultLibRadio = new Button(parent, 16);
        String version = JSHint.getDefaultLibraryVersion();
        this.defaultLibRadio.setText("Use the &built-in JSHint library (version " + version + ")");
        LayoutUtil.gridData((Control)this.defaultLibRadio).fillHorizontal().span(3, 1);
        this.customLibRadio = new Button(parent, 16);
        this.customLibRadio.setText("Provide a &custom JSHint library file");
        LayoutUtil.gridData((Control)this.customLibRadio).fillHorizontal().span(3, 1);
        this.customLibRadio.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                JSHintPreferencePage.this.preferences.setUseCustomLib(JSHintPreferencePage.this.customLibRadio.getSelection());
                JSHintPreferencePage.this.validate();
                JSHintPreferencePage.this.updateControlsEnabled();
            }
        });
        this.customLibPathText = new Text(parent, 2048);
        LayoutUtil.gridData((Control)this.customLibPathText).fillHorizontal().span(2, 1).indent(25, 0);
        this.customLibPathText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                JSHintPreferencePage.this.preferences.setCustomLibPath(JSHintPreferencePage.this.customLibPathText.getText());
                JSHintPreferencePage.this.validate();
            }
        });
        this.customLibPathButton = new Button(parent, 8);
        this.customLibPathButton.setText("Select");
        this.customLibPathButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                JSHintPreferencePage.this.selectFile();
            }
        });
        Text customLibPathLabelText = new Text(parent, 72);
        customLibPathLabelText.setText("This file is usually named 'jshint.js'.");
        customLibPathLabelText.setBackground(parent.getBackground());
        LayoutUtil.gridData((Control)customLibPathLabelText).fillHorizontal().span(3, 1).indent(25, 1);
    }

    private void createEnableErrorMarkersArea(Composite parent) {
        this.enableErrorsCheckbox = new Button(parent, 32);
        this.enableErrorsCheckbox.setText("Enable JSHint errors");
        this.enableErrorsCheckbox.setToolTipText("If unchecked, errors will be shown as warnings");
        LayoutUtil.gridData((Control)this.enableErrorsCheckbox).fillHorizontal().span(3, 1);
        this.enableErrorsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSHintPreferencePage.this.preferences.setEnableErrorMarkers(JSHintPreferencePage.this.enableErrorsCheckbox.getSelection());
                JSHintPreferencePage.this.validate();
            }
        });
    }

    private void selectFile() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText("Select JSHint library file");
        File file = new File(this.preferences.getCustomLibPath());
        fileDialog.setFileName(file.getName());
        fileDialog.setFilterPath(file.getParent());
        fileDialog.setFilterNames(new String[]{"JavaScript files"});
        fileDialog.setFilterExtensions(new String[]{"*.js", ""});
        String selectedPath = fileDialog.open();
        if (selectedPath != null) {
            this.customLibPathText.setText(selectedPath);
        }
    }

    private void validate() {
        this.setErrorMessage(null);
        this.setValid(false);
        final Display display = this.getShell().getDisplay();
        Job validator = new Job("JSHint preferences validation"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        monitor.beginTask("checking preferences", 1);
                        JSHintPreferencePage.this.validatePrefs();
                        display.asyncExec(new Runnable(){

                            public void run() {
                                JSHintPreferencePage.this.setValid(true);
                            }
                        });
                    }
                    catch (IllegalArgumentException exception) {
                        display.asyncExec(new Runnable(){

                            public void run() {
                                JSHintPreferencePage.this.setErrorMessage(exception.getMessage());
                            }
                        });
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        validator.schedule();
    }

    private void validatePrefs() {
        if (this.preferences.getUseCustomLib()) {
            String path = this.preferences.getCustomLibPath();
            JSHintPreferencePage.validateFile(new File(path));
        }
    }

    private static void validateFile(File file) throws IllegalArgumentException {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File does not exist");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("File is not readable");
        }
        try {
            FileInputStream inputStream = new FileInputStream(file);
            try {
                JSHint jsHint = new JSHint();
                jsHint.load((InputStream)inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("File is not a valid JSHint library", exception);
        }
    }

    private void updateControlsFromPrefs() {
        this.customLibRadio.setSelection(this.preferences.getUseCustomLib());
        this.defaultLibRadio.setSelection(!this.customLibRadio.getSelection());
        this.customLibPathText.setText(this.preferences.getCustomLibPath());
        this.enableErrorsCheckbox.setSelection(this.preferences.getEnableErrorMarkers());
    }

    private void updateControlsEnabled() {
        boolean enabled = this.customLibRadio.getSelection();
        this.customLibPathText.setEnabled(enabled);
        this.customLibPathButton.setEnabled(enabled);
    }

    private void triggerRebuild() throws CoreException {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                BuilderUtil.triggerClean(project, "com.eclipsesource.jshint.ui.builder");
            }
            ++n2;
        }
    }
}

