/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.preferences.ui;

import com.eclipsesource.jshint.ui.internal.preferences.PathPattern;
import com.eclipsesource.jshint.ui.internal.preferences.PathSegmentPattern;
import com.eclipsesource.jshint.ui.internal.util.LayoutUtil;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PathPatternDialog
extends TitleAreaDialog {
    private Button allFilesRadiobox;
    private Button matchingFilesRadiobox;
    private Text filePatternText;
    private Button allFoldersRadiobox;
    private Button selectedFolderRadiobox;
    private Button includeSubFoldersCheckbox;
    private Text folderPatternText;
    private final PathPattern pattern;
    private String value;
    private String title;

    public PathPatternDialog(Shell parent, String pattern) {
        super(parent);
        this.pattern = pattern == null ? null : PathPattern.create(pattern);
    }

    public String getValue() {
        return this.value;
    }

    public void setTitle(String title) {
        this.title = title;
        super.setTitle(title);
    }

    public void setErrorMessage(String newErrorMessage) {
        super.setErrorMessage(newErrorMessage);
        this.setOkEnabled(newErrorMessage == null);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.pattern != null ? "Edit path pattern" : "New path pattern");
    }

    protected Control createDialogArea(Composite parent) {
        Control composite = super.createDialogArea(parent);
        Composite contentArea = new Composite(parent, 0);
        Control fileArea = this.createFileArea(contentArea);
        Control folderArea = this.createFolderArea(contentArea);
        LayoutUtil.gridData((Control)contentArea).fillBoth();
        LayoutUtil.gridLayout(contentArea).columns(2, true).margin(10).spacing(10);
        LayoutUtil.gridData(fileArea).fillBoth();
        LayoutUtil.gridData(folderArea).fillBoth();
        this.initializeUI();
        return composite;
    }

    protected void okPressed() {
        this.createPatternFromUI();
        super.okPressed();
    }

    String getTitle() {
        return this.title;
    }

    private Control createFileArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        LayoutUtil.gridLayout(area).spacing(3);
        this.createFileAreaControls(area);
        this.addFileRadioListeners();
        this.addFileTextListener();
        return area;
    }

    private void createFileAreaControls(Composite area) {
        this.allFilesRadiobox = new Button(area, 16);
        this.allFilesRadiobox.setText("All files");
        this.matchingFilesRadiobox = new Button(area, 16);
        this.matchingFilesRadiobox.setText("Files matching");
        this.filePatternText = new Text(area, 2048);
        LayoutUtil.gridData((Control)this.filePatternText).fillHorizontal().indent(20, 0);
        Label label = new Label(area, 0);
        label.setText("(* = any string, ? = any character)");
        LayoutUtil.gridData((Control)label).indent(20, 0);
    }

    private void addFileRadioListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                PathPatternDialog.this.updateFileDetailsEnablementFromSelection();
                PathPatternDialog.this.validate();
            }
        };
        this.allFilesRadiobox.addListener(13, listener);
        this.matchingFilesRadiobox.addListener(13, listener);
    }

    private void addFileTextListener() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                PathPatternDialog.this.validate();
            }
        };
        this.filePatternText.addListener(24, listener);
    }

    private Control createFolderArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        LayoutUtil.gridLayout(area).spacing(3);
        this.createFolderAreaControls(area);
        this.addFolderRadioListeners();
        this.addFolderTextListener();
        return area;
    }

    private void createFolderAreaControls(Composite area) {
        this.allFoldersRadiobox = new Button(area, 16);
        this.allFoldersRadiobox.setText("in all folders");
        this.selectedFolderRadiobox = new Button(area, 16);
        this.selectedFolderRadiobox.setText("in folder");
        this.folderPatternText = new Text(area, 2048);
        LayoutUtil.gridData((Control)this.folderPatternText).fillHorizontal().indent(20, 0);
        Label label = new Label(area, 0);
        label.setText("(empty for project root folder)");
        LayoutUtil.gridData((Control)label).indent(20, 0);
        this.includeSubFoldersCheckbox = new Button(area, 32);
        this.includeSubFoldersCheckbox.setText("including all subfolders");
        LayoutUtil.gridData((Control)this.includeSubFoldersCheckbox).indent(20, 0);
    }

    private void addFolderRadioListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                PathPatternDialog.this.updateFolderDetailsEnablementFromSelection();
                PathPatternDialog.this.validate();
            }
        };
        this.allFoldersRadiobox.addListener(13, listener);
        this.selectedFolderRadiobox.addListener(13, listener);
    }

    private void addFolderTextListener() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                PathPatternDialog.this.validate();
            }
        };
        this.folderPatternText.addListener(24, listener);
    }

    private void initializeUI() {
        if (this.pattern == null || this.pattern.matchesAllFiles()) {
            this.allFilesRadiobox.setSelection(true);
        } else {
            this.matchingFilesRadiobox.setSelection(true);
            this.filePatternText.setText(this.pattern.getFilePattern());
        }
        if (this.pattern == null || this.pattern.matchesAllFolders()) {
            this.allFoldersRadiobox.setSelection(true);
            this.includeSubFoldersCheckbox.setSelection(false);
        } else {
            this.selectedFolderRadiobox.setSelection(true);
            String folderPattern = this.pattern.getPathPattern();
            this.folderPatternText.setText(folderPattern.replace("//", "/"));
            this.includeSubFoldersCheckbox.setSelection(folderPattern.endsWith("//"));
        }
        this.updateFileDetailsEnablementFromSelection();
        this.updateFolderDetailsEnablementFromSelection();
        super.setTitle(this.title);
    }

    private void createPatternFromUI() {
        StringBuilder builder = new StringBuilder();
        if (this.allFoldersRadiobox.getSelection()) {
            builder.append("//");
        } else {
            String folderPattern = this.folderPatternText.getText().trim();
            builder.append(PathPatternDialog.trimSlashes(folderPattern));
            if (this.includeSubFoldersCheckbox.getSelection()) {
                builder.append("//");
            } else if (folderPattern.length() > 0) {
                builder.append("/");
            }
        }
        if (this.allFilesRadiobox.getSelection()) {
            builder.append("*");
        } else {
            builder.append(this.filePatternText.getText().trim());
        }
        this.value = builder.toString();
    }

    private void updateFileDetailsEnablementFromSelection() {
        this.filePatternText.setEnabled(this.matchingFilesRadiobox.getSelection());
    }

    private void updateFolderDetailsEnablementFromSelection() {
        this.folderPatternText.setEnabled(this.selectedFolderRadiobox.getSelection());
        this.includeSubFoldersCheckbox.setEnabled(this.selectedFolderRadiobox.getSelection());
    }

    private void validate() {
        String errorMessage = this.getCombinedErrorMessage();
        this.setErrorMessage(errorMessage);
    }

    private String getCombinedErrorMessage() {
        String fileErrorMessage = this.getFileErrorMessage();
        String folderErrorMessage = this.getFolderErrorMessage();
        if (fileErrorMessage != null && folderErrorMessage != null) {
            return String.valueOf(fileErrorMessage) + ", " + folderErrorMessage;
        }
        return fileErrorMessage != null ? fileErrorMessage : folderErrorMessage;
    }

    private String getFolderErrorMessage() {
        String errorMessage = null;
        if (this.selectedFolderRadiobox.getSelection()) {
            String text = this.folderPatternText.getText();
            errorMessage = PathPatternDialog.checkFolderPattern(text);
        }
        return errorMessage;
    }

    private String getFileErrorMessage() {
        String errorMessage = null;
        if (this.matchingFilesRadiobox.getSelection()) {
            String text = this.filePatternText.getText();
            errorMessage = PathPatternDialog.checkFilePattern(text);
        }
        return errorMessage;
    }

    private void setOkEnabled(boolean enabled) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(enabled);
        }
    }

    private static String trimSlashes(String string) {
        String result = string;
        while (result.startsWith("/")) {
            result = result.substring(1);
        }
        while (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static String checkFilePattern(String pattern) {
        String errorMessage = null;
        try {
            PathSegmentPattern.create(pattern);
        }
        catch (IllegalArgumentException exception) {
            errorMessage = exception.getMessage().replace("in expression", "in file pattern");
        }
        return errorMessage;
    }

    private static String checkFolderPattern(String pattern) {
        String errorMessage = null;
        if (pattern.contains("//")) {
            errorMessage = "Illegal '//' in folder path";
        } else {
            try {
                PathPattern.create(pattern);
            }
            catch (IllegalArgumentException exception) {
                errorMessage = exception.getMessage().replace("in expression", "in folder path");
            }
        }
        return errorMessage;
    }
}

