/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.ui.internal.preferences.ui;

import com.eclipsesource.jshint.ui.internal.Activator;
import com.eclipsesource.jshint.ui.internal.builder.BuilderUtil;
import com.eclipsesource.jshint.ui.internal.preferences.EnablementPreferences;
import com.eclipsesource.jshint.ui.internal.preferences.ResourceSelector;
import com.eclipsesource.jshint.ui.internal.preferences.ui.AbstractPropertyPage;
import com.eclipsesource.jshint.ui.internal.preferences.ui.IncludesView;
import com.eclipsesource.jshint.ui.internal.util.LayoutUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.prefs.Preferences;

public class ProjectPropertyPage
extends AbstractPropertyPage {
    private IncludesView includesView;

    public boolean performOk() {
        try {
            if (this.storePreferences()) {
                boolean enabled = new ResourceSelector(this.getResource().getProject()).allowVisitProject();
                this.setBuilderEnabled(enabled);
                this.triggerRebuild();
            }
        }
        catch (CoreException exception) {
            String message = "Failed to store settings";
            Activator.logError(message, (Exception)((Object)exception));
            return false;
        }
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.includesView.loadDefaults();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        LayoutUtil.gridLayout(composite).margin(0, 0).columns(1);
        LayoutUtil.gridData((Control)composite).fillBoth();
        this.includesView = new IncludesView(composite, 0, this.getResource().getProject());
        LayoutUtil.gridData((Control)this.includesView).fillBoth();
        this.loadPreferences();
        return composite;
    }

    private void loadPreferences() {
        Preferences node = this.getPreferences();
        EnablementPreferences enablePreferences = new EnablementPreferences(node);
        this.includesView.loadPreferences(enablePreferences);
    }

    private boolean storePreferences() throws CoreException {
        Preferences node = this.getPreferences();
        EnablementPreferences enablePreferences = new EnablementPreferences(node);
        this.includesView.storePreferences(enablePreferences);
        if (enablePreferences.hasChanged()) {
            this.savePreferences();
            return true;
        }
        return false;
    }

    private boolean setBuilderEnabled(boolean enabled) throws CoreException {
        IProject project = this.getResource().getProject();
        if (enabled) {
            return BuilderUtil.addBuilderToProject(project, "com.eclipsesource.jshint.ui.builder");
        }
        return BuilderUtil.removeBuilderFromProject(project, "com.eclipsesource.jshint.ui.builder");
    }

    private void triggerRebuild() throws CoreException {
        IProject project = this.getResource().getProject();
        BuilderUtil.triggerClean(project, "com.eclipsesource.jshint.ui.builder");
    }
}

