/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint;

import com.eclipsesource.jshint.ProblemHandler;
import com.eclipsesource.jshint.Text;
import com.eclipsesource.jshint.internal.JSHintRunner;
import com.eclipsesource.jshint.internal.ProblemImpl;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSHint {
    private static final String DEFAULT_JSHINT_VERSION = "2.9.1";
    private static final int DEFAULT_JSHINT_INDENT = 4;
    private ScriptableObject scope;
    private Function jshint;
    private Object options;
    private Object globals;
    private int indent = 4;

    public void load() throws IOException {
        BufferedReader reader = JSHint.getJsHintReader();
        try {
            this.load(reader);
        }
        finally {
            ((Reader)reader).close();
        }
    }

    public void load(InputStream inputStream) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream);
        try {
            this.load(reader);
        }
        finally {
            ((Reader)reader).close();
        }
    }

    public void configure(JsonObject configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is null");
        }
        Context context = Context.enter();
        try {
            ScriptableObject scope = context.initStandardObjects();
            JsonValue globalsValue = configuration.get("globals");
            if (globalsValue != null) {
                String globalsExpr = "globals = " + globalsValue.toString() + ";";
                this.globals = context.evaluateString((Scriptable)scope, globalsExpr, "[globals]", 1, null);
            }
            configuration.remove("globals");
            String optionsExpr = "options = " + configuration.toString() + ";";
            this.options = context.evaluateString((Scriptable)scope, optionsExpr, "[options]", 1, null);
            this.indent = this.determineIndent(configuration);
        }
        finally {
            Context.exit();
        }
    }

    private int determineIndent(JsonObject configuration) {
        JsonValue value = configuration.get("indent");
        if (value != null && value.isNumber()) {
            return value.asInt();
        }
        return 4;
    }

    public boolean check(String code, ProblemHandler handler) {
        if (code == null) {
            throw new NullPointerException("code is null");
        }
        return this.check(new Text(code), handler);
    }

    public boolean check(Text text, ProblemHandler handler) {
        if (text == null) {
            throw new NullPointerException("code is null");
        }
        if (this.jshint == null) {
            throw new IllegalStateException("JSHint is not loaded");
        }
        boolean result = true;
        String code = text.getContent();
        if (code.trim().length() != 0) {
            Context context = Context.enter();
            try {
                result = this.checkCode(context, code);
                if (!result && handler != null) {
                    this.handleProblems(handler, text);
                }
            }
            finally {
                Context.exit();
            }
        }
        return result;
    }

    public static String getDefaultLibraryVersion() {
        return DEFAULT_JSHINT_VERSION;
    }

    private void load(Reader reader) throws IOException {
        Context context = Context.enter();
        try {
            try {
                context.setOptimizationLevel(9);
                context.setLanguageVersion(150);
                this.scope = context.initStandardObjects();
                context.evaluateString((Scriptable)this.scope, JSHint.createShimCode(), "shim", 1, null);
                context.evaluateReader((Scriptable)this.scope, reader, "jshint library", 1, null);
                this.jshint = JSHint.findJSHintFunction(this.scope);
            }
            catch (RhinoException exception) {
                throw new IllegalArgumentException("Could not evaluate JavaScript input", exception);
            }
        }
        finally {
            Context.exit();
        }
    }

    private boolean checkCode(Context context, String code) {
        try {
            Object[] args = new Object[]{code, this.options, this.globals};
            return (Boolean)this.jshint.call(context, (Scriptable)this.scope, null, args);
        }
        catch (JavaScriptException exception) {
            String message = "JavaScript exception thrown by JSHint: " + exception.getMessage();
            throw new RuntimeException(message, exception);
        }
        catch (RhinoException exception) {
            String message = "JavaScript exception caused by JSHint: " + exception.getMessage();
            throw new RuntimeException(message, exception);
        }
    }

    private void handleProblems(ProblemHandler handler, Text text) {
        NativeArray errors = (NativeArray)this.jshint.get("errors", (Scriptable)this.jshint);
        long length = errors.getLength();
        int i = 0;
        while ((long)i < length) {
            Object object = errors.get(i, (Scriptable)errors);
            ScriptableObject error = (ScriptableObject)object;
            if (error != null) {
                ProblemImpl problem = this.createProblem(error, text);
                handler.handleProblem(problem);
            }
            ++i;
        }
    }

    ProblemImpl createProblem(ScriptableObject error, Text text) {
        String reason = JSHint.getPropertyAsString(error, "reason", "");
        int line = JSHint.getPropertyAsInt(error, "line", -1);
        int character = JSHint.getPropertyAsInt(error, "character", -1);
        String code = JSHint.getPropertyAsString(error, "code", "");
        if (line <= 0 || line > text.getLineCount()) {
            line = -1;
            character = -1;
        } else if (character > 0) {
            character = this.visualToCharIndex(text, line, character);
        }
        String message = reason.endsWith(".") ? reason.substring(0, reason.length() - 1) : reason;
        return new ProblemImpl(line, character, message, code);
    }

    int visualToCharIndex(Text text, int line, int character) {
        String string = text.getContent();
        int offset = text.getLineOffset(line - 1);
        int charIndex = 0;
        int visualIndex = 1;
        int maxCharIndex = string.length() - offset - 1;
        while (visualIndex != character && charIndex < maxCharIndex) {
            boolean isTab = string.charAt(offset + charIndex) == '\t';
            visualIndex += isTab ? this.indent : 1;
            ++charIndex;
        }
        return charIndex;
    }

    private static String createShimCode() {
        return "console = {log:function(){},error:function(){},trace:function(){}};window = {};global = this;";
    }

    private static Function findJSHintFunction(ScriptableObject scope) throws IllegalArgumentException {
        if (!ScriptableObject.hasProperty((Scriptable)scope, (String)"JSHINT")) {
            throw new IllegalArgumentException("Global JSHINT function missing in input");
        }
        Object object = scope.get("JSHINT", (Scriptable)scope);
        if (!(object instanceof Function)) {
            throw new IllegalArgumentException("Global JSHINT is not a function");
        }
        return (Function)object;
    }

    private static String getPropertyAsString(ScriptableObject object, String name, String defaultValue) {
        String result = defaultValue;
        Object property = ScriptableObject.getProperty((Scriptable)object, (String)name);
        if (property instanceof String) {
            result = (String)property;
        }
        return result;
    }

    private static int getPropertyAsInt(ScriptableObject object, String name, int defaultValue) {
        int result = defaultValue;
        Object property = ScriptableObject.getProperty((Scriptable)object, (String)name);
        if (property instanceof Number) {
            result = ((Number)property).intValue();
        }
        return result;
    }

    private static BufferedReader getJsHintReader() throws UnsupportedEncodingException {
        ClassLoader classLoader = JSHint.class.getClassLoader();
        String name = "com/jshint/jshint-2.9.1.js";
        InputStream inputStream = classLoader.getResourceAsStream(name);
        return new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
    }

    public static void main(String[] args) {
        JSHintRunner runner = new JSHintRunner();
        runner.run(args);
    }
}

