/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jshint.internal;

import com.eclipsesource.jshint.JSHint;
import com.eclipsesource.jshint.Problem;
import com.eclipsesource.jshint.ProblemHandler;
import com.eclipsesource.json.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class JSHintRunner {
    private static final String PARAM_CHARSET = "--charset";
    private static final String PARAM_CUSTOM_JSHINT = "--custom";
    private List<File> files;
    private Charset charset;
    private File library;
    private JSHint jshint;

    public void run(String ... args) {
        try {
            this.readArgs(args);
            this.ensureCharset();
            this.ensureInputFiles();
            this.loadJSHint();
            this.configureJSHint();
            this.processFiles();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println();
            System.out.println("Usage: JSHint [ <options> ] <input-file> [ <input-file> ... ]");
            System.out.println("Options: --custom <custom-jshint-file>");
            System.out.println("         --charset <charset>");
        }
    }

    private void readArgs(String[] args) {
        this.files = new ArrayList<File>();
        String lastArg = null;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (PARAM_CHARSET.equals(lastArg)) {
                this.setCharset(arg);
            } else if (PARAM_CUSTOM_JSHINT.equals(lastArg)) {
                this.setLibrary(arg);
            } else if (!PARAM_CHARSET.equals(arg) && !PARAM_CUSTOM_JSHINT.equals(arg)) {
                File file = new File(arg);
                this.checkFile(file);
                this.files.add(file);
            }
            lastArg = arg;
            ++n2;
        }
    }

    private void checkFile(File file) throws IllegalArgumentException {
        if (!file.isFile()) {
            throw new IllegalArgumentException("No such file: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("Cannot read file: " + file.getAbsolutePath());
        }
    }

    private void ensureCharset() {
        if (this.charset == null) {
            this.setCharset("UTF-8");
        }
    }

    private void setCharset(String name) {
        try {
            this.charset = Charset.forName(name);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unknown or unsupported charset: " + name);
        }
    }

    private void setLibrary(String name) {
        this.library = new File(name);
    }

    private void ensureInputFiles() {
        if (this.files.isEmpty()) {
            throw new IllegalArgumentException("No input files");
        }
    }

    private void loadJSHint() {
        block6: {
            this.jshint = new JSHint();
            try {
                if (this.library != null) {
                    FileInputStream inputStream = new FileInputStream(this.library);
                    try {
                        this.jshint.load(inputStream);
                        break block6;
                    }
                    finally {
                        inputStream.close();
                    }
                }
                this.jshint.load();
            }
            catch (Exception exception) {
                String message = "Failed to load JSHint library: " + exception.getMessage();
                throw new IllegalArgumentException(message);
            }
        }
    }

    private void processFiles() throws IOException {
        for (File file : this.files) {
            String code = this.readFileContents(file);
            SysoutProblemHandler handler = new SysoutProblemHandler(file.getAbsolutePath());
            this.jshint.check(code, (ProblemHandler)handler);
        }
    }

    private void configureJSHint() {
        JsonObject configuration = new JsonObject();
        configuration.add("undef", true);
        this.jshint.configure(configuration);
    }

    private String readFileContents(File file) throws FileNotFoundException, IOException {
        FileInputStream inputStream = new FileInputStream(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, this.charset));
        try {
            StringBuilder builder = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                builder.append(line);
                builder.append('\n');
                line = reader.readLine();
            }
            String string = builder.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    private static final class SysoutProblemHandler
    implements ProblemHandler {
        private final String fileName;

        public SysoutProblemHandler(String fileName) {
            this.fileName = fileName;
        }

        public void handleProblem(Problem problem) {
            int line = problem.getLine();
            String message = problem.getMessage();
            System.out.println("Problem in file " + this.fileName + " at line " + line + ": " + message);
        }
    }
}

