/*
 * Decompiled with CFR 0.152.
 */
package com.github.eclipsecolortheme;

public class Color {
    private Integer r = new Integer(0);
    private Integer g = new Integer(0);
    private Integer b = new Integer(0);

    public Color(String value) {
        if (value != null && value.startsWith("#")) {
            this.r = Integer.parseInt(value.substring(1, 3), 16);
            this.g = Integer.parseInt(value.substring(3, 5), 16);
            this.b = Integer.parseInt(value.substring(5, 7), 16);
        }
    }

    public Integer getR() {
        return this.r;
    }

    public Integer getG() {
        return this.g;
    }

    public Integer getB() {
        return this.b;
    }

    public String asHex() {
        String hexr = Integer.toHexString(this.r).toUpperCase();
        String hexg = Integer.toHexString(this.g).toUpperCase();
        String hexb = Integer.toHexString(this.b).toUpperCase();
        return "#" + (hexr.length() == 2 ? hexr : "0" + hexr) + (hexg.length() == 2 ? hexg : "0" + hexg) + (hexb.length() == 2 ? hexb : "0" + hexb);
    }

    public String asRGB() {
        return this.r + "," + this.g + "," + this.b;
    }

    public String toString() {
        return this.r + "," + this.g + "," + this.b;
    }
}

