/*
 * Decompiled with CFR 0.152.
 */
package com.github.eclipsecolortheme;

import com.github.eclipsecolortheme.Activator;
import com.github.eclipsecolortheme.ColorTheme;
import com.github.eclipsecolortheme.ColorThemeMapping;
import com.github.eclipsecolortheme.ColorThemeSetting;
import com.github.eclipsecolortheme.ParsedTheme;
import com.github.eclipsecolortheme.mapper.GenericMapper;
import com.github.eclipsecolortheme.mapper.ThemePreferenceMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorThemeManager {
    private Map<String, ColorTheme> themes;
    private Map<String, ThemePreferenceMapper> editors = new HashMap<String, ThemePreferenceMapper>();

    public ColorThemeManager() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.github.eclipsecolortheme.mapper");
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("class");
                if (o instanceof ThemePreferenceMapper) {
                    String pluginId = e.getAttribute("pluginId");
                    ThemePreferenceMapper mapper = (ThemePreferenceMapper)o;
                    mapper.setPluginId(pluginId);
                    if (o instanceof GenericMapper) {
                        String xml = e.getAttribute("xml");
                        String contributorPluginId = e.getContributor().getName();
                        Bundle bundle = Platform.getBundle((String)contributorPluginId);
                        InputStream input = (InputStream)bundle.getResource(xml).getContent();
                        ((GenericMapper)mapper).parseMappings(input);
                    }
                    this.editors.put(pluginId, mapper);
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.themes = new HashMap<String, ColorTheme>();
        this.readStockThemes(this.themes);
        this.readImportedThemes(this.themes);
    }

    private void readStockThemes(Map<String, ColorTheme> themes) {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.github.eclipsecolortheme.theme");
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                String xml = e.getAttribute("file");
                String contributorPluginId = e.getContributor().getName();
                Bundle bundle = Platform.getBundle((String)contributorPluginId);
                InputStream input = (InputStream)bundle.getResource(xml).getContent();
                ParsedTheme theme = this.parseTheme(input, false);
                ColorThemeManager.amendThemeEntries(theme.getTheme().getEntries());
                themes.put(theme.getTheme().getName(), theme.getTheme());
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readImportedThemes(Map<String, ColorTheme> themes) {
        String xml;
        IPreferenceStore store = ColorThemeManager.getPreferenceStore();
        int i = 1;
        while ((xml = store.getString("importedColorTheme" + i)) != null && xml.length() != 0) {
            try {
                ParsedTheme theme = this.parseTheme(new ByteArrayInputStream(xml.getBytes("UTF-8")), false);
                ColorThemeManager.amendThemeEntries(theme.getTheme().getEntries());
                themes.put(theme.getTheme().getName(), theme.getTheme());
            }
            catch (Exception e) {
                System.err.println("Error while parsing imported theme");
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void clearImportedThemes() {
        IPreferenceStore store = ColorThemeManager.getPreferenceStore();
        int i = 1;
        while (store.contains("importedColorTheme" + i)) {
            store.setToDefault("importedColorTheme" + i);
            ++i;
        }
        this.themes.clear();
        this.readStockThemes(this.themes);
    }

    private static IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public ParsedTheme parseTheme(InputStream input, boolean loadSource) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        ColorTheme theme = new ColorTheme();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(input);
        Element root = document.getDocumentElement();
        theme.setId(root.getAttribute("id"));
        theme.setName(root.getAttribute("name"));
        theme.setAuthor(root.getAttribute("author"));
        theme.setWebsite(root.getAttribute("website"));
        HashMap<String, ColorThemeSetting> entries = new HashMap<String, ColorThemeSetting>();
        NodeList entryNodes = root.getChildNodes();
        int i = 0;
        while (i < entryNodes.getLength()) {
            Node entryNode = entryNodes.item(i);
            if (entryNode.hasAttributes()) {
                String color = entryNode.getAttributes().getNamedItem("color").getNodeValue();
                Node nodeBold = entryNode.getAttributes().getNamedItem("bold");
                Node nodeItalic = entryNode.getAttributes().getNamedItem("italic");
                Node nodeUnderline = entryNode.getAttributes().getNamedItem("underline");
                Node nodeStrikethrough = entryNode.getAttributes().getNamedItem("strikethrough");
                ColorThemeSetting setting = new ColorThemeSetting(color);
                if (nodeBold != null) {
                    setting.setBoldEnabled(Boolean.parseBoolean(nodeBold.getNodeValue()));
                }
                if (nodeItalic != null) {
                    setting.setItalicEnabled(Boolean.parseBoolean(nodeItalic.getNodeValue()));
                }
                if (nodeStrikethrough != null) {
                    setting.setStrikethroughEnabled(Boolean.parseBoolean(nodeStrikethrough.getNodeValue()));
                }
                if (nodeUnderline != null) {
                    setting.setUnderlineEnabled(Boolean.parseBoolean(nodeUnderline.getNodeValue()));
                }
                entries.put(entryNode.getNodeName(), setting);
            }
            ++i;
        }
        theme.setEntries(entries);
        NodeList nodeListMappingOverrides = root.getElementsByTagName("mappingOverrides");
        if (nodeListMappingOverrides.getLength() > 0) {
            Element mappingOverridesRoot = (Element)nodeListMappingOverrides.item(0);
            HashMap<String, Map<String, ColorThemeMapping>> mappings = new HashMap<String, Map<String, ColorThemeMapping>>();
            NodeList nodeListEclipseColorThemeMapping = mappingOverridesRoot.getChildNodes();
            int i2 = 0;
            while (i2 < nodeListEclipseColorThemeMapping.getLength()) {
                Node eclipseColorThemeMapping = nodeListEclipseColorThemeMapping.item(i2);
                if (eclipseColorThemeMapping.hasAttributes()) {
                    String pluginId = eclipseColorThemeMapping.getAttributes().getNamedItem("plugin").getNodeValue();
                    HashMap<String, ColorThemeMapping> mapMappings = new HashMap<String, ColorThemeMapping>();
                    ((GenericMapper)this.editors.get(pluginId)).parseMappings((Element)eclipseColorThemeMapping, mapMappings);
                    mappings.put(pluginId, mapMappings);
                }
                ++i2;
            }
            theme.setMappings(mappings);
        }
        ParsedTheme parsedTheme = new ParsedTheme(theme);
        if (loadSource) {
            parsedTheme.setSource(ColorThemeManager.documentToString(document));
        }
        return parsedTheme;
    }

    private static void amendThemeEntries(Map<String, ColorThemeSetting> theme) {
        ColorThemeManager.applyDefault(theme, "method", "foreground");
        ColorThemeManager.applyDefault(theme, "field", "foreground");
        ColorThemeManager.applyDefault(theme, "localVariable", "foreground");
        ColorThemeManager.applyDefault(theme, "javadoc", "multiLineComment");
        ColorThemeManager.applyDefault(theme, "javadocLink", "javadoc");
        ColorThemeManager.applyDefault(theme, "javadocTag", "javadoc");
        ColorThemeManager.applyDefault(theme, "javadocKeyword", "javadoc");
        ColorThemeManager.applyDefault(theme, "occurrenceIndication", "background");
        ColorThemeManager.applyDefault(theme, "writeOccurrenceIndication", "occurrenceIndication");
        ColorThemeManager.applyDefault(theme, "debugCurrentInstructionPointer", "currentLine");
        ColorThemeManager.applyDefault(theme, "debugSecondaryInstructionPointer", "currentLine");
    }

    private static void applyDefault(Map<String, ColorThemeSetting> theme, String key, String defaultKey) {
        if (!theme.containsKey(key)) {
            theme.put(key, theme.get(defaultKey));
        }
    }

    public Set<ColorTheme> getThemes() {
        return new HashSet<ColorTheme>(this.themes.values());
    }

    public ColorTheme getTheme(String name) {
        return this.themes.get(name);
    }

    public void applyTheme(String theme) {
        for (ThemePreferenceMapper editor : this.editors.values()) {
            editor.clear();
            if (this.themes.get(theme) != null) {
                editor.map(this.themes.get(theme).getEntries(), this.themes.get(theme).getMappings() == null ? null : this.themes.get(theme).getMappings().get(editor.getPluginId()));
            }
            try {
                editor.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveTheme(InputStream input) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        ParsedTheme theme = this.parseTheme(input, true);
        this.themes.put(theme.getTheme().getName(), theme.getTheme());
        IPreferenceStore store = ColorThemeManager.getPreferenceStore();
        int i = 1;
        while (true) {
            if (!store.contains("importedColorTheme" + i)) break;
            ++i;
        }
        store.putValue("importedColorTheme" + i, theme.getSource());
    }

    protected static String documentToString(Document document) throws TransformerException {
        StringWriter writer = new StringWriter();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        return writer.toString();
    }
}

