/*
 * Decompiled with CFR 0.152.
 */
package com.github.eclipsecolortheme.mapper;

import com.github.eclipsecolortheme.ColorThemeMapping;
import com.github.eclipsecolortheme.ColorThemeSetting;
import com.github.eclipsecolortheme.mapper.GenericMapper;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.Preferences;

public class ErlangEditorMapper
extends GenericMapper {
    protected ColorThemeMapping createMapping(String pluginKey, String themeKey) {
        return new Mapping(pluginKey, themeKey);
    }

    private class Mapping
    extends ColorThemeMapping {
        public Mapping(String pluginKey, String themeKey) {
            super(pluginKey, themeKey);
        }

        public void putPreferences(IEclipsePreferences preferences, ColorThemeSetting setting) {
            Preferences pref = preferences.parent().node("org.erlide.ui/" + this.pluginKey);
            int styleVal = 0;
            if (setting.isBoldEnabled() != null && setting.isBoldEnabled().booleanValue()) {
                ++styleVal;
            }
            if (setting.isItalicEnabled() != null && setting.isItalicEnabled().booleanValue()) {
                styleVal += 2;
            }
            if (setting.isStrikethroughEnabled() != null && setting.isStrikethroughEnabled().booleanValue()) {
                styleVal += 0x20000000;
            }
            if (setting.isUnderlineEnabled() != null && setting.isUnderlineEnabled().booleanValue()) {
                styleVal += 0x40000000;
            }
            pref.put("color", setting.getColor().asRGB());
            pref.putInt("style", styleVal);
        }
    }
}

