/*
 * Decompiled with CFR 0.152.
 */
package com.github.eclipsecolortheme.mapper;

import com.github.eclipsecolortheme.ColorThemeMapping;
import com.github.eclipsecolortheme.ColorThemeSemanticHighlightingMapping;
import com.github.eclipsecolortheme.ColorThemeSetting;
import com.github.eclipsecolortheme.mapper.GenericMapper;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class FlashEditorMapper
extends GenericMapper {
    protected ColorThemeMapping createMapping(String pluginKey, String themeKey) {
        return new Mapping(pluginKey, themeKey);
    }

    protected ColorThemeSemanticHighlightingMapping createSemanticHighlightingMapping(String pluginKey, String themeKey) {
        return new SemanticMapping(pluginKey, themeKey);
    }

    private class Mapping
    extends ColorThemeMapping {
        public Mapping(String pluginKey, String themeKey) {
            super(pluginKey, themeKey);
        }

        public void putPreferences(IEclipsePreferences preferences, ColorThemeSetting setting) {
            preferences.put(this.pluginKey, setting.getColor().asRGB());
            if (setting.isBoldEnabled() != null) {
                preferences.putBoolean(String.valueOf(this.pluginKey) + "_bold", setting.isBoldEnabled().booleanValue());
            }
            if (setting.isItalicEnabled() != null) {
                preferences.putBoolean(String.valueOf(this.pluginKey) + "_italic", setting.isItalicEnabled().booleanValue());
            }
            if (setting.isStrikethroughEnabled() != null) {
                preferences.putBoolean(String.valueOf(this.pluginKey) + "_strikethrough", setting.isStrikethroughEnabled().booleanValue());
            }
            if (setting.isUnderlineEnabled() != null) {
                preferences.putBoolean(String.valueOf(this.pluginKey) + "_underline", setting.isUnderlineEnabled().booleanValue());
            }
        }
    }

    private class SemanticMapping
    extends ColorThemeSemanticHighlightingMapping {
        public SemanticMapping(String pluginKey, String themeKey) {
            super(pluginKey, themeKey);
            this.setSeparator("_");
        }
    }
}

