/*
 * Decompiled with CFR 0.152.
 */
package com.github.eclipsecolortheme.mapper;

import com.github.eclipsecolortheme.Activator;
import com.github.eclipsecolortheme.ColorThemeMapping;
import com.github.eclipsecolortheme.ColorThemeSemanticHighlightingMapping;
import com.github.eclipsecolortheme.ColorThemeSetting;
import com.github.eclipsecolortheme.mapper.ThemePreferenceMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMapper
extends ThemePreferenceMapper {
    private Map<String, ColorThemeMapping> mappings = new HashMap<String, ColorThemeMapping>();
    protected ColorThemeSetting defaultBackground;

    public void parseMappings(InputStream input) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(input);
        this.parseMappings(document.getDocumentElement());
    }

    public void parseMappings(Element root) throws SAXException, IOException, ParserConfigurationException {
        this.parseMappings(root, this.mappings);
    }

    public void parseMappings(Element root, Map<String, ColorThemeMapping> mappings) throws SAXException, IOException, ParserConfigurationException {
        this.parseStandardMappings(root, mappings);
        this.parseSemanticHighlightingMappings(root, mappings);
    }

    private void parseStandardMappings(Element root, Map<String, ColorThemeMapping> mappings) {
        Node mappingsNode = root.getElementsByTagName("mappings").item(0);
        NodeList mappingNodes = mappingsNode.getChildNodes();
        int i = 0;
        while (i < mappingNodes.getLength()) {
            Node mappingNode = mappingNodes.item(i);
            if (mappingNode.hasAttributes()) {
                String pluginKey = GenericMapper.extractAttribute(mappingNode, "pluginKey");
                String themeKey = GenericMapper.extractAttribute(mappingNode, "themeKey");
                mappings.put(pluginKey, this.createMapping(pluginKey, themeKey));
            }
            ++i;
        }
    }

    private void parseSemanticHighlightingMappings(Element root, Map<String, ColorThemeMapping> mappings) {
        Node mappingsNode = root.getElementsByTagName("semanticHighlightingMappings").item(0);
        if (mappingsNode != null) {
            NodeList mappingNodes = mappingsNode.getChildNodes();
            int i = 0;
            while (i < mappingNodes.getLength()) {
                Node mappingNode = mappingNodes.item(i);
                if (mappingNode.hasAttributes()) {
                    String pluginKey = GenericMapper.extractAttribute(mappingNode, "pluginKey");
                    String themeKey = GenericMapper.extractAttribute(mappingNode, "themeKey");
                    mappings.put(pluginKey, this.createSemanticHighlightingMapping(pluginKey, themeKey));
                }
                ++i;
            }
        }
    }

    protected ColorThemeMapping createMapping(String pluginKey, String themeKey) {
        return new ColorThemeMapping(pluginKey, themeKey);
    }

    protected ColorThemeSemanticHighlightingMapping createSemanticHighlightingMapping(String pluginKey, String themeKey) {
        return new ColorThemeSemanticHighlightingMapping(pluginKey, themeKey);
    }

    private static String extractAttribute(Node node, String name) {
        return node.getAttributes().getNamedItem(name).getNodeValue();
    }

    @Override
    public void map(Map<String, ColorThemeSetting> theme, Map<String, ColorThemeMapping> overrideMappings) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.defaultBackground = store.getBoolean("forceDefaultBG") ? theme.get("background") : new ColorThemeSetting();
        for (String pluginKey : this.mappings.keySet()) {
            ColorThemeMapping mapping = overrideMappings != null && overrideMappings.containsKey(pluginKey) ? overrideMappings.get(pluginKey) : this.mappings.get(pluginKey);
            ColorThemeSetting setting = theme.get(mapping.getThemeKey());
            if (setting == null) continue;
            mapping.putPreferences(this.preferences, setting);
        }
    }

    @Override
    public void clear() {
        for (String pluginKey : this.mappings.keySet()) {
            ColorThemeMapping mapping = this.mappings.get(pluginKey);
            mapping.removePreferences(this.preferences);
        }
    }
}

